/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.carbuncle;

import com.hollingsworth.arsnouveau.api.event.EventQueue;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.debug.DebugEvent;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.GoToPosGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyTransportBehavior;
import com.hollingsworth.arsnouveau.common.event.OpenChestEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class TakeItemGoal<T extends StarbyTransportBehavior>
extends GoToPosGoal<T> {
    public TakeItemGoal(Starbuncle starbuncle, T behavior) {
        super(starbuncle, behavior, () -> starbuncle.getHeldStack().isEmpty());
    }

    @Override
    public boolean canUse() {
        boolean superCan = super.canUse();
        if (!superCan || ((StarbyTransportBehavior)this.behavior).FROM_LIST.isEmpty()) {
            return false;
        }
        if (this.getDestination() == null) {
            this.starbuncle.addGoalDebug(this, new DebugEvent("NoTakeDestination", "No valid take destination"));
            this.starbuncle.setBackOff(5 + this.starbuncle.level.random.nextInt(20));
            return false;
        }
        if (((StarbyTransportBehavior)this.behavior).isBedPowered()) {
            this.starbuncle.addGoalDebug(this, new DebugEvent("BedPowered", "Bed Powered, cannot take items"));
            return false;
        }
        return true;
    }

    @Override
    public boolean canContinueToUse() {
        return super.canContinueToUse() && !((StarbyTransportBehavior)this.behavior).isBedPowered();
    }

    @Override
    public void start() {
        super.start();
        this.starbuncle.goalState = Starbuncle.StarbuncleGoalState.TAKING_ITEM;
    }

    @Override
    public boolean isDestinationStillValid(BlockPos pos) {
        return ((StarbyTransportBehavior)this.behavior).isPositionValidTake(pos);
    }

    @Override
    @Nullable
    public BlockPos getDestination() {
        return ((StarbyTransportBehavior)this.behavior).getValidTakePos();
    }

    @Override
    public boolean onDestinationReached() {
        Level world = this.starbuncle.level;
        BlockEntity tileEntity = world.getBlockEntity(this.targetPos);
        if (tileEntity == null) {
            this.starbuncle.addGoalDebug(this, new DebugEvent("TakePosBroken", "Take Tile Broken"));
            return true;
        }
        IItemHandler iItemHandler = ((StarbyTransportBehavior)this.behavior).getItemCapFromTile(this.targetPos, (Direction)((StarbyTransportBehavior)this.behavior).FROM_DIRECTION_MAP.get(this.targetPos.hashCode()));
        if (iItemHandler == null) {
            this.starbuncle.addGoalDebug(this, new DebugEvent("NoItemHandler", "No item handler at " + this.targetPos.toString()));
            return true;
        }
        for (int j = 0; j < iItemHandler.getSlots() && this.starbuncle.getHeldStack().isEmpty(); ++j) {
            int count;
            ItemStack stack = iItemHandler.getStackInSlot(j);
            if (stack.isEmpty() || (count = ((StarbyTransportBehavior)this.behavior).getMaxTake(iItemHandler.getStackInSlot(j))) <= 0) continue;
            this.starbuncle.setHeldStack(iItemHandler.extractItem(j, Math.min(count, stack.getMaxStackSize()), false));
            this.starbuncle.addGoalDebug(this, new DebugEvent("SetHeld", "Taking " + count + "x " + this.starbuncle.getHeldStack().getHoverName().getString() + " from " + this.targetPos.toString()));
            this.starbuncle.level.playSound(null, this.starbuncle.getX(), this.starbuncle.getY(), this.starbuncle.getZ(), SoundEvents.ITEM_PICKUP, this.starbuncle.getSoundSource(), 1.0f, 1.0f);
            if (!(world instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)world;
            try {
                OpenChestEvent event = new OpenChestEvent(serverLevel, this.targetPos, 20);
                event.open();
                EventQueue.getServerInstance().addEvent(event);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.starbuncle.getHeldStack().isEmpty()) {
            this.starbuncle.addGoalDebug(this, new DebugEvent("TakeFromChest", "No items to take? Cancelling goal."));
        }
        return true;
    }
}

