/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.carbuncle;

import com.hollingsworth.arsnouveau.api.event.EventQueue;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.debug.DebugEvent;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.GoToPosGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyTransportBehavior;
import com.hollingsworth.arsnouveau.common.event.OpenChestEvent;
import com.hollingsworth.arsnouveau.common.items.ItemScroll;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class StoreItemGoal<T extends StarbyTransportBehavior>
extends GoToPosGoal<T> {
    public StoreItemGoal(Starbuncle starbuncle, T behavior) {
        super(starbuncle, behavior, () -> !starbuncle.getHeldStack().isEmpty());
    }

    @Override
    public void start() {
        super.start();
        this.starbuncle.goalState = Starbuncle.StarbuncleGoalState.STORING_ITEM;
    }

    @Override
    public BlockPos getDestination() {
        return ((StarbyTransportBehavior)this.behavior).getValidStorePos(this.starbuncle.getHeldStack());
    }

    @Override
    public boolean onDestinationReached() {
        this.starbuncle.getNavigation().stop();
        Level world = this.starbuncle.level;
        BlockEntity tileEntity = world.getBlockEntity(this.targetPos);
        if (tileEntity == null) {
            this.starbuncle.addGoalDebug(this, new DebugEvent("missing_tile", "store pos broken " + this.targetPos.toString()));
            this.starbuncle.setBackOff(5 + this.starbuncle.level.random.nextInt(20));
            return true;
        }
        IItemHandler iItemHandler = ((StarbyTransportBehavior)this.behavior).getItemCapFromTile(this.targetPos, (Direction)((StarbyTransportBehavior)this.behavior).TO_DIRECTION_MAP.get(this.targetPos.hashCode()));
        if (iItemHandler == null) {
            this.starbuncle.addGoalDebug(this, new DebugEvent("NoItemHandler", "No item handler at " + this.targetPos.toString()));
            return true;
        }
        ItemStack oldStack = new ItemStack((ItemLike)this.starbuncle.getHeldStack().getItem(), this.starbuncle.getHeldStack().getCount());
        ItemStack left = ItemHandlerHelper.insertItemStacked((IItemHandler)iItemHandler, (ItemStack)this.starbuncle.getHeldStack(), (boolean)false);
        if (left.equals(oldStack)) {
            this.starbuncle.setBackOff(5 + this.starbuncle.level.random.nextInt(20));
            this.starbuncle.addGoalDebug(this, new DebugEvent("no_room", this.targetPos.toString()));
            return true;
        }
        try {
            OpenChestEvent event = new OpenChestEvent((ServerLevel)this.starbuncle.level, this.targetPos, 20);
            event.open();
            EventQueue.getServerInstance().addEvent(event);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.starbuncle.setHeldStack(left);
        this.starbuncle.addGoalDebug(this, new DebugEvent("stored_item", "successful at " + this.targetPos.toString() + "set stack to " + left.getCount() + "x " + left.getHoverName().getString()));
        return true;
    }

    @Override
    public boolean isDestinationStillValid(BlockPos pos) {
        return ((StarbyTransportBehavior)this.behavior).sortPrefForStack(pos, this.starbuncle.getHeldStack()) != ItemScroll.SortPref.INVALID;
    }
}

