/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.carbuncle;

import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.block.SourceBerryBush;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.debug.DebugEvent;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyTransportBehavior;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class ForageManaBerries
extends Goal {
    private final Starbuncle entity;
    private final Level world;
    int timeSpent;
    BlockPos pos;
    StarbyTransportBehavior behavior;

    public ForageManaBerries(Starbuncle starbuncle, StarbyTransportBehavior transportBehavior) {
        this.entity = starbuncle;
        this.world = this.entity.level;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        this.behavior = transportBehavior;
    }

    public void start() {
        super.start();
        this.timeSpent = 0;
        this.entity.goalState = Starbuncle.StarbuncleGoalState.FORAGING;
    }

    public void stop() {
        super.stop();
        this.timeSpent = 0;
        this.entity.goalState = Starbuncle.StarbuncleGoalState.NONE;
    }

    public boolean canUse() {
        if (this.behavior.isPickupDisabled() || !this.entity.getHeldStack().isEmpty() || this.world.random.nextDouble() > 0.05 || this.behavior.getValidStorePos(new ItemStack(BlockRegistry.SOURCEBERRY_BUSH)) == null) {
            return false;
        }
        this.pos = this.getNearbyManaBerry();
        if (this.pos == null) {
            this.entity.addGoalDebug(this, new DebugEvent("NoBerries", "No Berries Nearby"));
            return false;
        }
        if (this.behavior.isBedPowered()) {
            this.entity.addGoalDebug(this, new DebugEvent("Bed Powered", "Bed powered, no berry pickin"));
            return false;
        }
        return this.pos != null;
    }

    public boolean isInterruptable() {
        return false;
    }

    public void tick() {
        super.tick();
        ++this.timeSpent;
        if (this.pos == null) {
            return;
        }
        if (BlockUtil.distanceFrom(this.entity.position, this.pos) >= 2.0) {
            this.entity.getNavigation().tryMoveToBlockPos(this.pos, 1.2);
            this.entity.addGoalDebug(this, new DebugEvent("PathTo", "Moving to berry " + this.pos.toString()));
        } else if (this.world.getBlockState(this.pos).getBlock() instanceof SourceBerryBush) {
            int i = (Integer)this.world.getBlockState(this.pos).getValue((Property)SourceBerryBush.AGE);
            boolean flag = i == 3;
            this.entity.lookAt(EntityAnchorArgument.Anchor.EYES, new Vec3((double)this.pos.getX(), (double)this.pos.getY(), (double)this.pos.getZ()));
            int j = 1 + this.world.random.nextInt(2);
            SourceBerryBush.popResource((Level)this.world, (BlockPos)this.pos, (ItemStack)new ItemStack(BlockRegistry.SOURCEBERRY_BUSH, j + (flag ? 1 : 0)));
            this.world.playSound(null, this.pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + this.world.random.nextFloat() * 0.4f);
            this.world.setBlock(this.pos, (BlockState)this.world.getBlockState(this.pos).setValue((Property)SourceBerryBush.AGE, (Comparable)Integer.valueOf(1)), 2);
            this.entity.addGoalDebug(this, new DebugEvent("PickedBerry", "Popped berries at " + this.pos.getX() + "," + this.pos.getY() + "," + this.pos.getZ()));
            this.pos = null;
        }
    }

    public boolean canContinueToUse() {
        if (this.pos == null || this.behavior.isPickupDisabled()) {
            return false;
        }
        return this.timeSpent <= 300 && this.world.getBlockState(this.pos).getBlock() instanceof SourceBerryBush && (Integer)this.world.getBlockState(this.pos).getValue((Property)SourceBerryBush.AGE) > 1;
    }

    public BlockPos getNearbyManaBerry() {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        for (BlockPos blockpos : BlockPos.withinManhattan((BlockPos)this.entity.blockPosition(), (int)10, (int)3, (int)10)) {
            if (!(this.world.getBlockState(blockpos).getBlock() instanceof SourceBerryBush) || (Integer)this.world.getBlockState(blockpos).getValue((Property)SourceBerryBush.AGE) <= 1) continue;
            posList.add(blockpos.immutable());
        }
        return posList.isEmpty() ? null : (BlockPos)posList.get(this.world.random.nextInt(posList.size()));
    }
}

