/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.amethyst_golem;

import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.datagen.ItemTagProvider;
import com.hollingsworth.arsnouveau.common.entity.AmethystGolem;
import java.util.Iterator;
import java.util.function.Supplier;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;

public class PickupAmethystGoal
extends Goal {
    public AmethystGolem golem;
    public Supplier<Boolean> canUse;
    ItemEntity targetEntity;
    int usingTicks;
    boolean isDone;

    public PickupAmethystGoal(AmethystGolem golem, Supplier<Boolean> canUse) {
        this.golem = golem;
        this.canUse = canUse;
    }

    public boolean canContinueToUse() {
        return this.targetEntity != null && !this.isDone;
    }

    public void tick() {
        super.tick();
        --this.usingTicks;
        if (this.usingTicks <= 0) {
            this.isDone = true;
            this.collectStacks();
            return;
        }
        if (this.targetEntity == null || this.targetEntity.isRemoved() || !this.targetEntity.getItem().is(ItemTagProvider.SHARD_TAG)) {
            this.isDone = true;
            return;
        }
        this.golem.getNavigation().tryMoveToBlockPos(this.targetEntity.blockPosition(), 1.0);
        if (BlockUtil.distanceFrom(this.golem.blockPosition(), this.targetEntity.blockPosition()) <= 1.5) {
            this.collectStacks();
            this.isDone = true;
            this.golem.pickupCooldown = 60 + this.golem.getRandom().nextInt(10);
        }
    }

    public void collectStacks() {
        if (this.golem.getHome() == null) {
            return;
        }
        for (ItemEntity i2 : this.golem.level.getEntitiesOfClass(ItemEntity.class, new AABB(this.golem.getHome()).inflate(10.0), i -> i.getItem().is(ItemTagProvider.SHARD_TAG))) {
            if (!this.golem.getHeldStack().isEmpty() && i2.getItem().getItem() != this.golem.getHeldStack().getItem()) continue;
            int maxTake = this.golem.getHeldStack().getMaxStackSize() - this.golem.getHeldStack().getCount();
            if (this.golem.getHeldStack().isEmpty()) {
                this.golem.setHeldStack(i2.getItem().copy());
                i2.getItem().setCount(0);
                continue;
            }
            int toTake = Math.min(i2.getItem().getCount(), maxTake);
            i2.getItem().shrink(toTake);
            this.golem.getHeldStack().grow(toTake);
        }
    }

    public void stop() {
        this.isDone = false;
        this.usingTicks = 80;
        this.golem.goalState = AmethystGolem.AmethystGolemGoalState.NONE;
        this.golem.pickupCooldown = 60 + this.golem.getRandom().nextInt(10);
    }

    public void start() {
        this.isDone = false;
        this.usingTicks = 80;
        Iterator iterator = this.golem.level.getEntitiesOfClass(ItemEntity.class, new AABB(this.golem.getHome()).inflate(10.0), entity -> entity.getItem().is(ItemTagProvider.SHARD_TAG)).iterator();
        if (iterator.hasNext()) {
            ItemEntity entity2 = (ItemEntity)iterator.next();
            this.golem.getNavigation().tryMoveToBlockPos(entity2.blockPosition(), 1.0);
            this.targetEntity = entity2;
        }
        if (this.targetEntity == null) {
            this.isDone = true;
        }
        this.golem.goalState = AmethystGolem.AmethystGolemGoalState.PICKUP;
    }

    public boolean isInterruptable() {
        return false;
    }

    public boolean canUse() {
        if (this.golem.getHome() == null) {
            return false;
        }
        return this.canUse.get() != false && this.golem.pickupCooldown <= 0 && this.golem.level.getCapability(Capabilities.ItemHandler.BLOCK, this.golem.getHome(), null) != null;
    }
}

