/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.familiar;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.item.inv.FilterableItemHandler;
import com.hollingsworth.arsnouveau.api.item.inv.InventoryManager;
import com.hollingsworth.arsnouveau.common.entity.EntityBookwyrm;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarEntity;
import com.hollingsworth.arsnouveau.common.entity.familiar.FlyingFamiliarEntity;
import com.hollingsworth.arsnouveau.common.entity.familiar.ISpellCastListener;
import com.hollingsworth.arsnouveau.common.items.ItemScroll;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.entity.player.PlayerXpEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.PlayerMainInvWrapper;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class FamiliarBookwyrm
extends FlyingFamiliarEntity
implements ISpellCastListener {
    public FamiliarBookwyrm(EntityType<? extends PathfinderMob> ent, Level world) {
        super(ent, world);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (this.level.isClientSide || hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = player.getItemInHand(hand);
        if (player.getMainHandItem().is(Tags.Items.DYES)) {
            DyeColor color = DyeColor.getColor((ItemStack)stack);
            if (color == null || ((String)this.entityData.get(COLOR)).equals(color.getName()) || !Arrays.asList(EntityBookwyrm.COLORS).contains(color.getName())) {
                return InteractionResult.SUCCESS;
            }
            this.setColor(color);
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level.isClientSide || this.level.getGameTime() % 20L != 0L) {
            return;
        }
        LivingEntity owner = this.getOwner();
        if (!(owner instanceof Player)) {
            return;
        }
        Player player = (Player)owner;
        final FilterableItemHandler filterableItemHandler = new FilterableItemHandler((IItemHandler)new PlayerMainInvWrapper(player.inventory), new ArrayList<Function<ItemStack, ItemScroll.SortPref>>());
        InventoryManager manager = new InventoryManager((List<FilterableItemHandler>)new ArrayList<FilterableItemHandler>(){
            {
                this.add(filterableItemHandler);
            }
        });
        for (Entity entity : this.level.getEntities((Entity)owner, new AABB(owner.getOnPos()).inflate(5.0))) {
            PlayerXpEvent.PickupXp pickupEvent;
            ExperienceOrb orb;
            if (entity instanceof ItemEntity) {
                ItemEntityPickupEvent.Pre prePickup;
                ItemEntity i = (ItemEntity)entity;
                ItemStack stack = i.getItem();
                if (stack.isEmpty() || i.hasPickUpDelay() || i.getPersistentData().getBoolean("PreventRemoteMovement") || !i.isAlive() || (prePickup = (ItemEntityPickupEvent.Pre)NeoForge.EVENT_BUS.post((Event)new ItemEntityPickupEvent.Pre(player, i))).canPickup().isFalse() || this.getOwnerID().equals(i.getOwner())) continue;
                stack = manager.insertStack(stack);
                i.setItem(stack);
            }
            if (!(entity instanceof ExperienceOrb) || (orb = (ExperienceOrb)entity).isRemoved() || (pickupEvent = (PlayerXpEvent.PickupXp)NeoForge.EVENT_BUS.post((Event)new PlayerXpEvent.PickupXp(player, orb))).isCanceled()) continue;
            player.giveExperiencePoints(orb.value);
            orb.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    @Override
    public PlayState walkPredicate(AnimationState event) {
        event.getController().setAnimation(RawAnimation.begin().thenPlay("fly"));
        return PlayState.CONTINUE;
    }

    public EntityType<?> getType() {
        return (EntityType)ModEntities.ENTITY_FAMILIAR_BOOKWYRM.get();
    }

    @Override
    public ResourceLocation getTexture(FamiliarEntity entity) {
        String color = this.getColor().toLowerCase();
        if (color.isEmpty()) {
            color = "blue";
        }
        return ArsNouveau.prefix("textures/entity/book_wyrm_" + color + ".png");
    }
}

