/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.entity.EntityChimeraProjectile;
import com.hollingsworth.arsnouveau.common.entity.SummonWolf;
import com.hollingsworth.arsnouveau.common.entity.goal.ConditionalMeleeGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.ConditionalWaterAvoidingGoal;
import com.hollingsworth.arsnouveau.setup.config.Config;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class WildenGuardian
extends Monster
implements GeoEntity {
    AnimatableInstanceCache manager = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int armorCooldown;
    public int armorTimeRemaining;
    public static final EntityDataAccessor<Boolean> IS_ARMORED = SynchedEntityData.defineId(WildenGuardian.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    AnimationController<WildenGuardian> controller;
    AnimationController<WildenGuardian> runController;
    AnimationController<WildenGuardian> idleController;

    public WildenGuardian(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
    }

    public WildenGuardian(Level worldIn) {
        this((EntityType<? extends Monster>)((EntityType)ModEntities.WILDEN_GUARDIAN.get()), worldIn);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.goalSelector.addGoal(5, (Goal)new ConditionalMeleeGoal((PathfinderMob)this, 1.2, true, () -> !this.isArmored()));
        this.goalSelector.addGoal(8, (Goal)new ConditionalWaterAvoidingGoal((PathfinderMob)this, 1.0, () -> !this.isArmored()));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        if (((Boolean)Config.GUARDIAN_ATTACK_ANIMALS.get()).booleanValue()) {
            this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Animal.class, 10, true, false, entity -> !(entity instanceof SummonWolf) || !((SummonWolf)entity).isWildenSummon));
        }
    }

    public boolean checkSpawnObstruction(LevelReader pLevel) {
        return pLevel.isUnobstructed((Entity)this);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
    }

    public boolean isArmored() {
        return (Boolean)this.entityData.get(IS_ARMORED);
    }

    public void setArmored(boolean isArmored) {
        this.entityData.set(IS_ARMORED, (Object)isArmored);
    }

    protected void actuallyHurt(DamageSource damageSrc, float damageAmount) {
        if (!this.level.isClientSide && this.armorCooldown == 0) {
            this.setArmored(true);
            this.armorCooldown = 200;
            this.armorTimeRemaining = 100;
            this.navigation.stop();
        }
        if (!this.level.isClientSide && this.isArmored() && !damageSrc.is(DamageTypeTags.BYPASSES_ARMOR)) {
            damageAmount = (float)((double)damageAmount * 0.75);
            if (damageSrc.getEntity() != null && BlockUtil.distanceFrom(damageSrc.getEntity().position, this.position) <= 2.0 && !damageSrc.type().msgId().equals("thorns")) {
                damageSrc.getEntity().hurt(this.level.damageSources().thorns((Entity)this), 3.0f);
            }
        }
        super.actuallyHurt(damageSrc, damageAmount);
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        if (pSource.is(DamageTypes.DROWN)) {
            return false;
        }
        return super.hurt(pSource, pAmount);
    }

    public void tick() {
        super.tick();
        if (!this.level.isClientSide) {
            if (this.armorTimeRemaining > 0) {
                --this.armorTimeRemaining;
            }
            if (this.armorTimeRemaining == 0 && this.isArmored()) {
                this.setArmored(false);
                this.explodeSpikes();
            }
            if (this.armorCooldown > 0) {
                --this.armorCooldown;
            }
        }
        if (this.isArmored() && !this.level.isClientSide) {
            this.getNavigation().stop();
        }
    }

    public void explodeSpikes() {
        for (int i = 0; i < 20; ++i) {
            EntityChimeraProjectile entity = new EntityChimeraProjectile(this.level);
            entity.shootFromRotation((Entity)this, this.level.random.nextInt(360), this.level.random.nextInt(360), 0.0f, (float)(1.0 + ParticleUtil.inRange(0.0, 0.5)), 1.0f);
            entity.setPos(this.position.x, this.position.y + 1.0, this.position.z);
            this.level.addFreshEntity((Entity)entity);
        }
        if (this.getTarget() != null) {
            EntityChimeraProjectile abstractarrowentity = new EntityChimeraProjectile(this.level);
            abstractarrowentity.setPos(this.getX(), this.getY(), this.getZ());
            double d0 = this.getTarget().getX() - this.getX();
            double d1 = this.getTarget().getY(0.3333333333333333) - abstractarrowentity.getY();
            double d2 = this.getTarget().getZ() - this.getZ();
            double d3 = Mth.sqrt((float)((float)(d0 * d0 + d2 * d2)));
            abstractarrowentity.shoot(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 1.0f);
            this.level.addFreshEntity((Entity)abstractarrowentity);
        }
    }

    private <T extends GeoAnimatable> PlayState runPredicate(AnimationState<T> tAnimationState) {
        if (this.isArmored()) {
            return PlayState.STOP;
        }
        if (tAnimationState.isMoving()) {
            tAnimationState.getController().setAnimation(RawAnimation.begin().thenPlay("run"));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private <T extends GeoAnimatable> PlayState idlePredicate(AnimationState<T> tAnimationState) {
        if (this.isArmored()) {
            return PlayState.STOP;
        }
        if (tAnimationState.isMoving()) {
            return PlayState.STOP;
        }
        tAnimationState.getController().setAnimation(RawAnimation.begin().thenPlay("idle"));
        return PlayState.CONTINUE;
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(IS_ARMORED, (Object)false);
    }

    private PlayState defendPredicate(AnimationState<?> event) {
        if (this.isArmored()) {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("defending"));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar animatableManager) {
        this.controller = new AnimationController((GeoAnimatable)this, "attackController", 1, this::defendPredicate);
        this.runController = new AnimationController((GeoAnimatable)this, "runController", 1, this::runPredicate);
        this.idleController = new AnimationController((GeoAnimatable)this, "idleController", 1, this::idlePredicate);
        animatableManager.add(this.controller);
        animatableManager.add(this.runController);
        animatableManager.add(this.idleController);
    }

    public int getAttackDuration() {
        return 80;
    }

    public boolean save(CompoundTag compound) {
        compound.putInt("armorCooldown", this.armorCooldown);
        compound.putInt("armorTimeRemaining", this.armorTimeRemaining);
        return super.save(compound);
    }

    public void load(CompoundTag compound) {
        super.load(compound);
        this.armorCooldown = compound.getInt("armorCooldown");
        this.armorTimeRemaining = compound.getInt("armorTimeRemaining");
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.manager;
    }

    public static AttributeSupplier.Builder getModdedAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 25.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.KNOCKBACK_RESISTANCE, (double)0.6f).add(Attributes.ATTACK_KNOCKBACK, 1.0).add(Attributes.ATTACK_DAMAGE, 4.5).add(Attributes.ARMOR, 2.0);
    }

    protected float getWaterSlowDown() {
        return 0.98f;
    }
}

