/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.camera.ICameraMountable;
import com.hollingsworth.arsnouveau.common.block.ScryerCrystal;
import com.hollingsworth.arsnouveau.common.block.tile.ScryerCrystalTile;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketSetCameraView;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;

public class ScryerCamera
extends Entity {
    public final double cameraSpeed;
    public int screenshotSoundCooldown = 0;
    protected int redstoneCooldown = 0;
    protected int toggleNightVisionCooldown = 0;
    private boolean shouldProvideNightVision = false;
    public float zoomAmount = 1.0f;
    public boolean zooming = false;
    private int viewDistance = -1;
    private boolean loadedChunks = false;

    public ScryerCamera(EntityType<ScryerCamera> type, Level level) {
        super(type, level);
        this.cameraSpeed = 3.3;
        this.noPhysics = true;
    }

    public ScryerCamera(Level level, BlockPos pos) {
        this((EntityType<ScryerCamera>)((EntityType)ModEntities.SCRYER_CAMERA.get()), level);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ScryerCrystalTile) {
            ScryerCrystalTile cam = (ScryerCrystalTile)blockEntity;
            double x = (double)pos.getX() + 0.5;
            double y = (double)pos.getY() + 0.5;
            double z = (double)pos.getZ() + 0.5;
            if (cam.down) {
                y += 0.25;
            }
            this.setPos(x, y, z);
            this.setInitialPitchYaw();
        } else {
            this.discard();
        }
    }

    public ScryerCamera(Level level, BlockPos pos, ScryerCamera oldCamera) {
        this(level, pos);
        oldCamera.discardCamera();
    }

    private void setInitialPitchYaw() {
        Direction facing = (Direction)this.level.getBlockState(this.blockPosition()).getValue((Property)ScryerCrystal.FACING);
        if (facing == Direction.NORTH) {
            this.setYRot(180.0f);
        } else if (facing == Direction.WEST) {
            this.setYRot(90.0f);
        } else if (facing == Direction.SOUTH) {
            this.setYRot(0.0f);
        } else if (facing == Direction.EAST) {
            this.setYRot(270.0f);
        } else if (facing == Direction.DOWN) {
            this.setXRot(75.0f);
        }
    }

    protected boolean repositionEntityAfterLoad() {
        return false;
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
    }

    public void tick() {
        if (this.level.isClientSide) {
            if (this.screenshotSoundCooldown > 0) {
                --this.screenshotSoundCooldown;
            }
            if (this.redstoneCooldown > 0) {
                --this.redstoneCooldown;
            }
            if (this.toggleNightVisionCooldown > 0) {
                --this.toggleNightVisionCooldown;
            }
        } else if (this.level.getBlockState(this.blockPosition()).getBlock() != BlockRegistry.SCRYERS_CRYSTAL.get()) {
            this.discard();
        }
    }

    public float getZoomAmount() {
        return this.zoomAmount;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isCameraDown() {
        BlockEntity var2 = this.level.getBlockEntity(this.blockPosition());
        if (!(var2 instanceof ScryerCrystalTile)) return false;
        ScryerCrystalTile cam = (ScryerCrystalTile)var2;
        if (!cam.down) return false;
        return true;
    }

    public void setRotation(float yaw, float pitch) {
        this.setRot(yaw, pitch);
    }

    public void stopViewing(ServerPlayer player) {
        if (!this.level.isClientSide) {
            this.discardCamera();
            player.camera = player;
            Networking.sendToPlayerClient(new PacketSetCameraView((Entity)player), player);
        }
    }

    public void discardCamera() {
        if (!this.level.isClientSide) {
            BlockEntity blockEntity = this.level.getBlockEntity(this.blockPosition());
            if (blockEntity instanceof ICameraMountable) {
                ICameraMountable camMount = (ICameraMountable)blockEntity;
                camMount.stopViewing();
            }
            SectionPos chunkPos = SectionPos.of((BlockPos)this.blockPosition());
            int view = this.viewDistance <= 0 ? this.level.getServer().getPlayerList().getViewDistance() : this.viewDistance;
            for (int x = chunkPos.getX() - view; x <= chunkPos.getX() + view; ++x) {
                for (int z = chunkPos.getZ() - view; z <= chunkPos.getZ() + view; ++z) {
                    ArsNouveau.ticketController.forceChunk((ServerLevel)this.level, (Entity)this, x, z, false, false);
                }
            }
        }
        this.discard();
    }

    public void setHasLoadedChunks(int initialViewDistance) {
        this.loadedChunks = true;
        this.viewDistance = initialViewDistance;
    }

    public boolean hasLoadedChunks() {
        return this.loadedChunks;
    }

    public void addAdditionalSaveData(CompoundTag tag) {
    }

    public void readAdditionalSaveData(CompoundTag tag) {
    }

    public boolean isAlwaysTicking() {
        return true;
    }
}

