/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;

public interface IFollowingSummon {
    public static final EntityDataAccessor<Optional<UUID>> OWNER_UNIQUE_ID = SynchedEntityData.defineId(TamableAnimal.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);

    public Level getWorld();

    public PathNavigation getPathNav();

    public LivingEntity getSummoner();

    public Mob getSelfEntity();

    public static class CopyOwnerTargetGoal<I extends PathfinderMob>
    extends TargetGoal {
        public CopyOwnerTargetGoal(I creature) {
            super(creature, false);
        }

        public boolean canUse() {
            Mob mob = this.mob;
            if (!(mob instanceof IFollowingSummon)) {
                return false;
            }
            IFollowingSummon summon = (IFollowingSummon)mob;
            return summon.getSummoner() != null && summon.getSummoner().getLastHurtMob() != null;
        }

        public void start() {
            IFollowingSummon summon;
            Mob mob = this.mob;
            if (mob instanceof IFollowingSummon && (summon = (IFollowingSummon)mob).getSummoner() != null) {
                this.mob.setTarget(summon.getSummoner().getLastHurtMob());
            }
            super.start();
        }
    }
}

