/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class EntitySpellArrow
extends Arrow {
    public SpellResolver spellResolver;
    public int pierceLeft;
    BlockPos lastPosHit;
    Entity lastEntityHit;
    public static final EntityDataAccessor<Integer> RED = SynchedEntityData.defineId(EntitySpellArrow.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> GREEN = SynchedEntityData.defineId(EntitySpellArrow.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> BLUE = SynchedEntityData.defineId(EntitySpellArrow.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public EntitySpellArrow(EntityType<? extends Arrow> type, Level worldIn) {
        super(type, worldIn);
        this.setDefaultColors();
    }

    public EntitySpellArrow(Level worldIn, double x, double y, double z, ItemStack pPickupItemStack, @Nullable ItemStack p_345233_) {
        super(worldIn, x, y, z, pPickupItemStack, p_345233_);
        this.setDefaultColors();
    }

    public EntitySpellArrow(Level worldIn, LivingEntity shooter, ItemStack pPickupItemStack, @Nullable ItemStack weaponStack) {
        super(worldIn, shooter, pPickupItemStack, weaponStack);
        this.setDefaultColors();
    }

    public void setDefaultColors() {
        this.setColors(ParticleColor.defaultParticleColor());
    }

    public void setColors(ParticleColor color) {
        ParticleColor.IntWrapper wrapper = color.toWrapper();
        this.entityData.set(RED, (Object)wrapper.r);
        this.entityData.set(GREEN, (Object)wrapper.g);
        this.entityData.set(BLUE, (Object)wrapper.b);
    }

    public void tick() {
        Vec3 vector3d3;
        boolean isNoClip = this.isNoPhysics();
        Vec3 vector3d = this.getDeltaMovement();
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            float f = Mth.sqrt((float)((float)vector3d.horizontalDistanceSqr()));
            this.yRot = (float)(Mth.atan2((double)vector3d.x, (double)vector3d.z) * 57.2957763671875);
            this.xRot = (float)(Mth.atan2((double)vector3d.y, (double)f) * 57.2957763671875);
            this.yRotO = this.yRot;
            this.xRotO = this.xRot;
        }
        BlockPos blockpos = this.blockPosition();
        BlockState blockstate = this.level.getBlockState(blockpos);
        if (this.shakeTime > 0) {
            --this.shakeTime;
        }
        if (this.isInWaterOrRain()) {
            this.clearFire();
        }
        this.inGroundTime = 0;
        Vec3 vector3d2 = this.position();
        BlockHitResult raytraceresult = this.level.clip(new ClipContext(vector3d2, vector3d3 = vector3d2.add(vector3d), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        if (raytraceresult.getType() != HitResult.Type.MISS) {
            vector3d3 = raytraceresult.getLocation();
        }
        while (!this.isRemoved()) {
            EntityHitResult entityraytraceresult = this.findHitEntity(vector3d2, vector3d3);
            if (entityraytraceresult != null) {
                raytraceresult = entityraytraceresult;
            }
            if (raytraceresult instanceof EntityHitResult) {
                EntityHitResult entityHitResult = (EntityHitResult)raytraceresult;
                Entity entity = entityHitResult.getEntity();
                Entity entity1 = this.getOwner();
                if (entity.noPhysics) {
                    raytraceresult = null;
                    entityraytraceresult = null;
                } else if (entity instanceof Player) {
                    Player player2;
                    Player player1 = (Player)entity;
                    if (entity1 instanceof Player && !(player2 = (Player)entity1).canHarmPlayer(player1)) {
                        raytraceresult = null;
                        entityraytraceresult = null;
                    }
                }
            }
            if (raytraceresult != null && raytraceresult.getType() != HitResult.Type.MISS && !isNoClip && !EventHooks.onProjectileImpact((Projectile)this, (HitResult)raytraceresult)) {
                this.onHit((HitResult)raytraceresult);
                this.hasImpulse = true;
            }
            if (entityraytraceresult == null || this.getPierceLevel() <= 0) break;
            raytraceresult = null;
        }
        vector3d = this.getDeltaMovement();
        double d3 = vector3d.x;
        double d4 = vector3d.y;
        double d0 = vector3d.z;
        if (this.isCritArrow()) {
            for (int i = 0; i < 4; ++i) {
                this.level.addParticle((ParticleOptions)ParticleTypes.CRIT, this.getX() + d3 * (double)i / 4.0, this.getY() + d4 * (double)i / 4.0, this.getZ() + d0 * (double)i / 4.0, -d3, -d4 + 0.2, -d0);
            }
        }
        double d5 = this.getX() + d3;
        double d1 = this.getY() + d4;
        double d2 = this.getZ() + d0;
        float f1 = Mth.sqrt((float)((float)vector3d.horizontalDistanceSqr()));
        this.yRot = isNoClip ? (float)(Mth.atan2((double)(-d3), (double)(-d0)) * 57.2957763671875) : (float)(Mth.atan2((double)d3, (double)d0) * 57.2957763671875);
        this.xRot = (float)(Mth.atan2((double)d4, (double)f1) * 57.2957763671875);
        this.xRot = EntitySpellArrow.lerpRotation((float)this.xRotO, (float)this.xRot);
        this.yRot = EntitySpellArrow.lerpRotation((float)this.yRotO, (float)this.yRot);
        float f2 = 0.99f;
        float f3 = 0.05f;
        if (this.isInWater()) {
            for (int j = 0; j < 4; ++j) {
                float f4 = 0.25f;
                this.level.addParticle((ParticleOptions)ParticleTypes.BUBBLE, d5 - d3 * 0.25, d1 - d4 * 0.25, d2 - d0 * 0.25, d3, d4, d0);
            }
            f2 = this.getWaterInertia();
        }
        this.setDeltaMovement(vector3d.scale((double)f2));
        if (!this.isNoGravity() && !isNoClip) {
            Vec3 vector3d4 = this.getDeltaMovement();
            this.setDeltaMovement(vector3d4.x, vector3d4.y - (double)0.05f, vector3d4.z);
        }
        this.setPos(d5, d1, d2);
        this.checkInsideBlocks();
        if (this.level.isClientSide && this.tickCount > 1) {
            double deltaX = this.getX() - this.xOld;
            double deltaY = this.getY() - this.yOld;
            double deltaZ = this.getZ() - this.zOld;
            double dist = Math.ceil(Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 8.0);
            int counter = 0;
            for (double j = 0.0; j < dist; j += 1.0) {
                double coeff = j / dist;
                if ((counter += this.level.random.nextInt(3)) % (((ParticleStatus)Minecraft.getInstance().options.particles().get()).getId() == 0 ? 1 : 2 * ((ParticleStatus)Minecraft.getInstance().options.particles().get()).getId()) != 0) continue;
                this.level.addParticle(GlowParticleData.createData(new ParticleColor((Integer)this.entityData.get(RED), (Integer)this.entityData.get(GREEN), (Integer)this.entityData.get(BLUE))), (double)((float)(this.xo + deltaX * coeff)), (double)((float)(this.yo + deltaY * coeff)), (double)((float)(this.zo + deltaZ * coeff)), (double)(0.0125f * (this.random.nextFloat() - 0.5f)), (double)(0.0125f * (this.random.nextFloat() - 0.5f)), (double)(0.0125f * (this.random.nextFloat() - 0.5f)));
            }
        }
    }

    protected void attemptRemoval() {
        if (this.level.isClientSide) {
            return;
        }
        --this.pierceLeft;
        if (this.pierceLeft < 0) {
            this.level.broadcastEntityEvent((Entity)this, (byte)3);
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    public byte getPierceLevel() {
        return 12;
    }

    protected void onHitEntity(EntityHitResult p_213868_1_) {
        Level level;
        super.onHitEntity(p_213868_1_);
        Entity entity = p_213868_1_.getEntity();
        float f = (float)this.getDeltaMovement().length();
        double d0 = this.getBaseDamage();
        Entity entity1 = this.getOwner();
        DamageSource damagesource = this.damageSources().arrow((AbstractArrow)this, (Entity)(entity1 != null ? entity1 : this));
        if (this.getWeaponItem() != null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            d0 = EnchantmentHelper.modifyDamage((ServerLevel)serverlevel, (ItemStack)this.getWeaponItem(), (Entity)entity, (DamageSource)damagesource, (float)((float)d0));
        }
        int j = Mth.ceil((double)Mth.clamp((double)((double)f * d0), (double)0.0, (double)2.147483647E9));
        if (this.isCritArrow()) {
            long k = this.random.nextInt(j / 2 + 2);
            j = (int)Math.min(k + (long)j, Integer.MAX_VALUE);
        }
        if (entity1 instanceof LivingEntity) {
            LivingEntity livingentity1 = (LivingEntity)entity1;
            livingentity1.setLastHurtMob(entity);
        }
        boolean flag = entity.getType() == EntityType.ENDERMAN;
        int i = entity.getRemainingFireTicks();
        if (this.isOnFire() && !flag) {
            entity.igniteForSeconds(5.0f);
        }
        if (entity.hurt(damagesource, (float)j)) {
            if (flag) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                if (!this.level().isClientSide && this.getPierceLevel() <= 0) {
                    livingentity.setArrowCount(livingentity.getArrowCount() + 1);
                }
                this.doKnockback(livingentity, damagesource);
                Level level2 = this.level();
                if (level2 instanceof ServerLevel) {
                    ServerLevel serverlevel1 = (ServerLevel)level2;
                    EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverlevel1, (Entity)livingentity, (DamageSource)damagesource, (ItemStack)this.getWeaponItem());
                }
                this.doPostHurtEffects(livingentity);
            }
        } else {
            entity.setRemainingFireTicks(i);
            this.deflect(ProjectileDeflection.REVERSE, entity, this.getOwner(), false);
            this.setDeltaMovement(this.getDeltaMovement().scale(0.2));
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(RED, (Object)0);
        pBuilder.define(GREEN, (Object)0);
        pBuilder.define(BLUE, (Object)0);
    }

    protected void onHit(HitResult result) {
        HitResult.Type raytraceresult$type;
        if (this.spellResolver != null) {
            this.spellResolver.onResolveEffect(this.level, result);
        }
        if ((raytraceresult$type = result.getType()) == HitResult.Type.ENTITY) {
            if (this.spellResolver != null) {
                this.spellResolver.onResolveEffect(this.level, result);
            }
            this.onHitEntity((EntityHitResult)result);
            this.attemptRemoval();
            this.lastEntityHit = ((EntityHitResult)result).getEntity();
        } else if (raytraceresult$type == HitResult.Type.BLOCK && !((BlockHitResult)result).getBlockPos().equals((Object)this.lastPosHit)) {
            if (this.spellResolver != null) {
                this.spellResolver.onResolveEffect(this.level, result);
            }
            this.onHitBlock((BlockHitResult)result);
            this.lastPosHit = ((BlockHitResult)result).getBlockPos();
            this.attemptRemoval();
        }
    }

    protected void onHitBlock(BlockHitResult p_230299_1_) {
        BlockState blockstate = this.level.getBlockState(p_230299_1_.getBlockPos());
        blockstate.onProjectileHit(this.level, blockstate, p_230299_1_, (Projectile)this);
        this.playSound(this.getHitGroundSoundEvent(), 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
    }

    public EntityType<?> getType() {
        return (EntityType)ModEntities.ENTITY_SPELL_ARROW.get();
    }
}

