/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.entity.ColoredProjectile;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EntityFollowProjectile
extends ColoredProjectile {
    public static final EntityDataAccessor<BlockPos> to = SynchedEntityData.defineId(EntityFollowProjectile.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    public static final EntityDataAccessor<BlockPos> from = SynchedEntityData.defineId(EntityFollowProjectile.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    public static final EntityDataAccessor<Boolean> SPAWN_TOUCH = SynchedEntityData.defineId(EntityFollowProjectile.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DESPAWN = SynchedEntityData.defineId(EntityFollowProjectile.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private int age;
    int maxAge = 500;

    public EntityFollowProjectile(Level world) {
        super((EntityType<? extends ColoredProjectile>)((EntityType)ModEntities.ENTITY_FOLLOW_PROJ.get()), world, 0.0, 0.0, 0.0);
    }

    public void setDespawnDistance(int distance) {
        this.getEntityData().set(DESPAWN, (Object)distance);
    }

    public EntityFollowProjectile(Level worldIn, Vec3 from, Vec3 to) {
        this((EntityType<? extends EntityFollowProjectile>)((EntityType)ModEntities.ENTITY_FOLLOW_PROJ.get()), worldIn);
        this.entityData.set(EntityFollowProjectile.to, (Object)BlockPos.containing((Position)to));
        this.entityData.set(EntityFollowProjectile.from, (Object)BlockPos.containing((Position)from));
        this.setPos(from.x + 0.5, from.y + 0.5, from.z + 0.5);
        this.entityData.set(RED, (Object)255);
        this.entityData.set(GREEN, (Object)25);
        this.entityData.set(BLUE, (Object)180);
        double distance = BlockUtil.distanceFrom(BlockPos.containing((Position)from), BlockPos.containing((Position)to));
        this.setDespawnDistance((int)(distance + 10.0));
    }

    public EntityFollowProjectile(Level worldIn, BlockPos from, BlockPos to, int r, int g, int b) {
        this(worldIn, new Vec3((double)from.getX(), (double)from.getY(), (double)from.getZ()), new Vec3((double)to.getX(), (double)to.getY(), (double)to.getZ()));
        this.entityData.set(RED, (Object)Math.min(r, 255));
        this.entityData.set(GREEN, (Object)Math.min(g, 255));
        this.entityData.set(BLUE, (Object)Math.min(b, 255));
    }

    public EntityFollowProjectile(Level worldIn, BlockPos from, BlockPos to, ParticleColor.IntWrapper color) {
        this(worldIn, from, to, color.r, color.g, color.b);
    }

    public EntityFollowProjectile(Level worldIn, BlockPos from, BlockPos to) {
        this(worldIn, new Vec3((double)from.getX(), (double)from.getY(), (double)from.getZ()), new Vec3((double)to.getX(), (double)to.getY(), (double)to.getZ()));
    }

    public EntityFollowProjectile(EntityType<? extends EntityFollowProjectile> entityAOEProjectileEntityType, Level world) {
        super(entityAOEProjectileEntityType, world);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(to, (Object)new BlockPos(0, 0, 0));
        pBuilder.define(from, (Object)new BlockPos(0, 0, 0));
        pBuilder.define(SPAWN_TOUCH, (Object)this.defaultsBurst());
        pBuilder.define(DESPAWN, (Object)10);
    }

    public boolean defaultsBurst() {
        return false;
    }

    public void tick() {
        super.tick();
        ++this.age;
        if (this.age > this.maxAge) {
            this.remove(Entity.RemovalReason.DISCARDED);
            return;
        }
        Vec3 vec3d2 = this.getDeltaMovement();
        BlockPos dest = (BlockPos)this.entityData.get(to);
        if (BlockUtil.distanceFrom(this.blockPosition(), dest) < 1.0 || this.age > 1000 || BlockUtil.distanceFrom(this.blockPosition(), dest) > (double)((Integer)this.entityData.get(DESPAWN)).intValue()) {
            if (this.level.isClientSide && ((Boolean)this.entityData.get(SPAWN_TOUCH)).booleanValue()) {
                ParticleUtil.spawnTouch((ClientLevel)this.level, this.getOnPos(), new ParticleColor((Integer)this.entityData.get(RED), (Integer)this.entityData.get(GREEN), (Integer)this.entityData.get(BLUE)));
            }
            this.remove(Entity.RemovalReason.DISCARDED);
            return;
        }
        double posX = this.getX();
        double posY = this.getY();
        double posZ = this.getZ();
        double motionX = this.getDeltaMovement().x;
        double motionY = this.getDeltaMovement().y;
        double motionZ = this.getDeltaMovement().z;
        if (dest.getX() != 0 || dest.getY() != 0 || dest.getZ() != 0) {
            double targetX = (double)dest.getX() + 0.5;
            double targetY = (double)dest.getY() + 0.5;
            double targetZ = (double)dest.getZ() + 0.5;
            Vec3 targetVector = new Vec3(targetX - posX, targetY - posY, targetZ - posZ);
            double length = targetVector.length();
            targetVector = targetVector.scale(0.3 / length);
            double weight = 0.0;
            if (length <= 3.0) {
                weight = 0.9 * ((3.0 - length) / 3.0);
            }
            motionX = (0.9 - weight) * motionX + (0.1 + weight) * targetVector.x;
            motionY = (0.9 - weight) * motionY + (0.1 + weight) * targetVector.y;
            motionZ = (0.9 - weight) * motionZ + (0.1 + weight) * targetVector.z;
        }
        this.setPos(posX += motionX, posY += motionY, posZ += motionZ);
        this.setDeltaMovement(motionX, motionY, motionZ);
        if (this.level.isClientSide && this.age > 1) {
            double deltaX = this.getX() - this.xOld;
            double deltaY = this.getY() - this.yOld;
            double deltaZ = this.getZ() - this.zOld;
            float dist = (float)(Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 8.0);
            for (double i = 0.0; i <= (double)dist; i += 1.0) {
                double coeff = i / (double)dist;
                this.level.addParticle(GlowParticleData.createData(new ParticleColor((Integer)this.entityData.get(RED), (Integer)this.entityData.get(GREEN), (Integer)this.entityData.get(BLUE))), this.getX() + deltaX * coeff, this.getY() + deltaY * coeff, this.getZ() + deltaZ * coeff, (double)(0.0125f * (this.random.nextFloat() - 0.5f)), (double)(0.0125f * (this.random.nextFloat() - 0.5f)), (double)(0.0125f * (this.random.nextFloat() - 0.5f)));
            }
        }
    }

    public void setRemoved(Entity.RemovalReason reason) {
        if (reason == Entity.RemovalReason.UNLOADED_TO_CHUNK) {
            reason = Entity.RemovalReason.DISCARDED;
        }
        super.setRemoved(reason);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(from, (Object)NBTUtil.getBlockPos(compound, "from"));
        this.entityData.set(to, (Object)NBTUtil.getBlockPos(compound, "to"));
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (from != null) {
            NBTUtil.storeBlockPos(compound, "from", (BlockPos)this.entityData.get(from));
        }
        if (to != null) {
            NBTUtil.storeBlockPos(compound, "to", (BlockPos)this.entityData.get(to));
        }
    }

    public EntityType<?> getType() {
        return (EntityType)ModEntities.ENTITY_FOLLOW_PROJ.get();
    }

    public boolean isNoGravity() {
        return true;
    }
}

