/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.entity.IDispellable;
import com.hollingsworth.arsnouveau.api.entity.ISummon;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.MageBlock;
import com.hollingsworth.arsnouveau.common.entity.EnchantedFallingBlock;
import com.hollingsworth.arsnouveau.common.entity.goal.ConditionalLeapGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.ConditionalMeleeGoal;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class AnimBlockSummon
extends TamableAnimal
implements GeoEntity,
ISummon,
IDispellable {
    public BlockState blockState;
    public int color;
    private int ticksLeft;
    public static final EntityDataAccessor<Integer> AGE = SynchedEntityData.defineId(AnimBlockSummon.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> CAN_WALK = SynchedEntityData.defineId(AnimBlockSummon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public boolean isAlternateSpawn;
    public boolean dropItem = true;
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.defineId(AnimBlockSummon.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    public static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.defineId(AnimBlockSummon.class, (EntityDataSerializer)EntityDataSerializers.INT);
    final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public AnimBlockSummon(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.isAlternateSpawn = this.random.nextBoolean();
    }

    public AnimBlockSummon(Level pLevel, BlockState state) {
        this((EntityType<? extends TamableAnimal>)((EntityType)ModEntities.ANIMATED_BLOCK.get()), pLevel);
        this.blockState = state;
    }

    public double getAttributeValue(Holder<Attribute> pAttribute) {
        if (pAttribute.is(Attributes.ATTACK_DAMAGE)) {
            return super.getAttributeValue(pAttribute) + (double)this.getStateDamageBonus();
        }
        return super.getAttributeValue(pAttribute);
    }

    public float getStateDamageBonus() {
        float destroySpeed = 1.0f;
        try {
            destroySpeed = this.blockState.getDestroySpeed((BlockGetter)this.level, this.blockPosition());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return destroySpeed;
    }

    public EntityType<?> getType() {
        return (EntityType)ModEntities.ANIMATED_BLOCK.get();
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(4, (Goal)new ConditionalLeapGoal((Mob)this, 0.4f, () -> (Boolean)this.entityData.get(CAN_WALK)));
        this.goalSelector.addGoal(5, (Goal)new ConditionalMeleeGoal((PathfinderMob)this, 1.0, true, () -> (Boolean)this.entityData.get(CAN_WALK)));
        this.goalSelector.addGoal(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f));
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{AnimBlockSummon.class}).setAlertOthers(new Class[]{AnimBlockSummon.class}));
    }

    public boolean doHurtTarget(Entity pEntity) {
        if (this.getOwner() != null && pEntity.isAlliedTo((Entity)this.getOwner())) {
            return false;
        }
        boolean result = super.doHurtTarget(pEntity);
        if (result) {
            this.ticksLeft -= 400;
        }
        return result;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.MAX_HEALTH, 4.0).add(Attributes.ATTACK_DAMAGE, 2.0);
    }

    public boolean canAttack(LivingEntity pTarget) {
        if (this.getOwnerUUID() != null) {
            if (pTarget.getUUID().equals(this.getOwnerUUID())) {
                return false;
            }
            if (pTarget instanceof ISummon) {
                ISummon summon = (ISummon)pTarget;
                return super.canAttack(pTarget) && !this.getOwnerUUID().equals(summon.getOwnerUUID());
            }
        }
        return super.canAttack(pTarget);
    }

    public void tick() {
        super.tick();
        if (!this.level.isClientSide) {
            --this.ticksLeft;
            this.entityData.set(AGE, (Object)((Integer)this.entityData.get(AGE) + 1));
            if ((Integer)this.entityData.get(AGE) > 20) {
                this.entityData.set(CAN_WALK, (Object)true);
            }
            if (this.ticksLeft <= 0) {
                ParticleUtil.spawnPoof((ServerLevel)this.level, this.blockPosition());
                this.returnToFallingBlock(this.blockState);
                this.remove(Entity.RemovalReason.DISCARDED);
                this.onSummonDeath(this.level, null, true);
            }
        }
    }

    public void returnToFallingBlock(BlockState blockState) {
        if (blockState == null) {
            return;
        }
        EnchantedFallingBlock fallingBlock = new EnchantedFallingBlock(this.level, this.blockPosition(), blockState);
        fallingBlock.setOwner((Entity)this.getOwner());
        fallingBlock.setDeltaMovement(this.getDeltaMovement());
        fallingBlock.setColor(ParticleColor.fromInt(this.color));
        fallingBlock.dropItem = this.dropItem;
        if (blockState.getBlock() instanceof MageBlock) {
            fallingBlock.dropItem = false;
        }
        this.level.addFreshEntity((Entity)fallingBlock);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel pLevel, AgeableMob pOtherParent) {
        return null;
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(OWNER_UUID, Optional.of(Util.NIL_UUID));
        pBuilder.define(COLOR, (Object)ParticleColor.defaultParticleColor().getColor());
        pBuilder.define(AGE, (Object)0);
        pBuilder.define(CAN_WALK, (Object)false);
    }

    public void die(DamageSource cause) {
        super.die(cause);
        this.returnToFallingBlock(this.getBlockState());
        this.onSummonDeath(this.level, cause, false);
    }

    @Nullable
    public LivingEntity getOwner() {
        return this.dead ? null : super.getOwner();
    }

    public boolean canBreed() {
        return false;
    }

    public boolean canMate(Animal pOtherAnimal) {
        return false;
    }

    public boolean isFood(ItemStack stack) {
        return false;
    }

    protected int getBaseExperienceReward() {
        return 0;
    }

    @Override
    public int getTicksLeft() {
        return this.ticksLeft;
    }

    @Override
    public void setTicksLeft(int ticks) {
        this.ticksLeft = ticks;
    }

    @Nullable
    public UUID getOwnerUUID() {
        return ((Optional)this.getEntityData().get(OWNER_UUID)).isEmpty() ? this.getUUID() : (UUID)((Optional)this.getEntityData().get(OWNER_UUID)).get();
    }

    @Override
    public void setOwnerID(UUID uuid) {
        this.getEntityData().set(OWNER_UUID, Optional.ofNullable(uuid));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        String spawnAnim = "spawn";
        data.add(new AnimationController((GeoAnimatable)this, spawnAnim, 0, e -> {
            if (!((Boolean)this.entityData.get(CAN_WALK)).booleanValue()) {
                e.getController().setAnimation(RawAnimation.begin().thenPlay(spawnAnim));
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        }));
        data.add(new AnimationController((GeoAnimatable)this, "run", 1, e -> {
            if (e.isMoving() && ((Boolean)this.entityData.get(CAN_WALK)).booleanValue()) {
                e.getController().setAnimation(RawAnimation.begin().thenPlay("run"));
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        }));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public BlockState getBlockState() {
        return this.blockState != null ? this.blockState : ((MageBlock)BlockRegistry.MAGE_BLOCK.get()).defaultBlockState();
    }

    public void recreateFromPacket(ClientboundAddEntityPacket pPacket) {
        super.recreateFromPacket(pPacket);
        this.blockState = Block.stateById((int)pPacket.getData());
        double d0 = pPacket.getX();
        double d1 = pPacket.getY();
        double d2 = pPacket.getZ();
        this.setPos(d0, d1, d2);
    }

    public void setColor(int color) {
        this.color = color;
        this.getEntityData().set(COLOR, (Object)color);
    }

    public boolean save(CompoundTag pCompound) {
        pCompound.putInt("color", this.color);
        return super.save(pCompound);
    }

    public void load(CompoundTag pCompound) {
        super.load(pCompound);
        this.getEntityData().set(COLOR, (Object)pCompound.getInt("color"));
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.ticksLeft = pCompound.getInt("left");
        this.color = pCompound.getInt("color");
        this.blockState = Block.stateById((int)pCompound.getInt("blockState"));
        this.getEntityData().set(AGE, (Object)pCompound.getInt("ticksAlive"));
        this.getEntityData().set(CAN_WALK, (Object)pCompound.getBoolean("canWalk"));
        this.dropItem = !pCompound.contains("dropItem") || pCompound.getBoolean("dropItem");
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putInt("left", this.ticksLeft);
        pCompound.putInt("color", this.color);
        pCompound.putInt("blockState", Block.getId((BlockState)this.blockState));
        pCompound.putInt("ticksAlive", ((Integer)this.getEntityData().get(AGE)).intValue());
        pCompound.putBoolean("canWalk", ((Boolean)this.getEntityData().get(CAN_WALK)).booleanValue());
        pCompound.putBoolean("dropItem", this.dropItem);
    }

    public int getColor() {
        if (this.color == 0) {
            this.color = (Integer)this.entityData.get(COLOR);
        }
        return this.color;
    }

    @Override
    public boolean onDispel(@NotNull LivingEntity caster) {
        this.setTicksLeft(0);
        return true;
    }
}

