/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.datagen;

import com.google.gson.JsonElement;
import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.common.crafting.recipes.ScryRitualRecipe;
import com.hollingsworth.arsnouveau.common.datagen.SimpleDataProvider;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class ScryRitualProvider
extends SimpleDataProvider {
    public List<ScryRecipeWrapper> recipes = new ArrayList<ScryRecipeWrapper>();

    public ScryRitualProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    @Override
    public void collectJsons(CachedOutput pOutput) {
        this.addEntries();
        for (ScryRecipeWrapper recipe : this.recipes) {
            Path path = ScryRitualProvider.getRecipePath(this.output, recipe.id().getPath());
            this.saveStable(pOutput, (JsonElement)ScryRitualRecipe.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)recipe.recipe()).getOrThrow(), path);
        }
    }

    protected void addEntries() {
        String[] defaultOres;
        for (String ore : defaultOres = new String[]{"coal", "copper", "diamond", "emerald", "gold", "iron", "lapis", "netherite_scrap", "quartz", "redstone"}) {
            this.addForgeOreRecipe(ore);
        }
        this.recipes.add(new ScryRecipeWrapper(ArsNouveau.prefix("amethyst_gems"), this.forgeItemTag("gems/amethyst"), this.forgeBlockTag("storage_blocks/amethyst")));
        this.recipes.add(new ScryRecipeWrapper(ArsNouveau.prefix("amethyst_blocks"), this.forgeItemTag("storage_blocks/amethyst"), this.forgeBlockTag("storage_blocks/amethyst")));
    }

    private void addForgeOreRecipe(String ore) {
        this.recipes.add(new ScryRecipeWrapper(ArsNouveau.prefix(ore + "_ores"), this.forgeItemTag("ores/" + ore), this.forgeBlockTag("ores/" + ore)));
    }

    private TagKey<Block> forgeBlockTag(String path) {
        return BlockTags.create((ResourceLocation)this.forgeTag(path));
    }

    private TagKey<Item> forgeItemTag(String path) {
        return ItemTags.create((ResourceLocation)this.forgeTag(path));
    }

    private ResourceLocation forgeTag(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)path);
    }

    protected static Path getRecipePath(Path path, String id) {
        return path.resolve("data/ars_nouveau/recipe/scry_ritual/" + id + ".json");
    }

    public String getName() {
        return "Scry Ritual Datagen";
    }

    public record ScryRecipeWrapper(ResourceLocation id, TagKey<Item> augment, TagKey<Block> highlight) {
        public ScryRitualRecipe recipe() {
            return new ScryRitualRecipe(this.augment, this.highlight);
        }
    }
}

