/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.datagen;

import com.hollingsworth.arsnouveau.setup.registry.DamageTypesRegistry;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.DamageTypeTagsProvider;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DamageTypesProvider
extends DatapackBuiltinEntriesProvider {
    private static final RegistrySetBuilder BUILDER = new RegistrySetBuilder().add(Registries.DAMAGE_TYPE, DamageTypesProvider::bootstrap);

    public static void bootstrap(BootstrapContext<DamageType> ctx) {
        ctx.register(DamageTypesRegistry.GENERIC_SPELL_DAMAGE, (Object)new DamageType("player", 0.1f));
        ctx.register(DamageTypesRegistry.COLD_SNAP, (Object)new DamageType("freeze", 0.1f));
        ctx.register(DamageTypesRegistry.FLARE, (Object)new DamageType("fire", 0.1f));
        ctx.register(DamageTypesRegistry.CRUSH, (Object)new DamageType("player", 0.1f));
        ctx.register(DamageTypesRegistry.WINDSHEAR, (Object)new DamageType("player", 0.1f));
    }

    public DamageTypesProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, BUILDER, Set.of("ars_nouveau"));
    }

    @NotNull
    public String getName() {
        return "Ars Nouveau's Damage Type Data";
    }

    public static class DamageTypesTagsProvider
    extends DamageTypeTagsProvider {
        TagKey<DamageType> FORGE_MAGIC = TagKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"is_magic"));

        public DamageTypesTagsProvider(PackOutput pPackOutput, CompletableFuture<HolderLookup.Provider> provider, @Nullable ExistingFileHelper existingFileHelper) {
            super(pPackOutput, provider, "ars_nouveau", existingFileHelper);
        }

        protected void addTags(HolderLookup.Provider pProvider) {
            this.tag(DamageTypeTags.IS_FIRE).addOptional(DamageTypesRegistry.FLARE.location());
            this.tag(DamageTypeTags.IS_FREEZING).addOptional(DamageTypesRegistry.COLD_SNAP.location());
            this.tag(DamageTypeTags.BYPASSES_ARMOR).addOptional(DamageTypesRegistry.CRUSH.location()).addOptional(DamageTypesRegistry.WINDSHEAR.location());
            this.tag(DamageTypeTags.IS_FALL).addOptional(DamageTypesRegistry.WINDSHEAR.location());
            this.tag(this.FORGE_MAGIC).addOptional(DamageTypesRegistry.GENERIC_SPELL_DAMAGE.location()).addOptional(DamageTypesRegistry.COLD_SNAP.location()).addOptional(DamageTypesRegistry.FLARE.location()).addOptional(DamageTypesRegistry.CRUSH.location()).addOptional(DamageTypesRegistry.WINDSHEAR.location());
            this.tag(DamageTypeTags.ALWAYS_HURTS_ENDER_DRAGONS).addOptional(DamageTypesRegistry.GENERIC_SPELL_DAMAGE.location()).addOptional(DamageTypesRegistry.COLD_SNAP.location()).addOptional(DamageTypesRegistry.FLARE.location()).addOptional(DamageTypesRegistry.CRUSH.location()).addOptional(DamageTypesRegistry.WINDSHEAR.location());
        }
    }
}

