/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.datagen;

import com.google.gson.JsonElement;
import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.sound.ConfiguredSpellSound;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.crafting.recipes.CasterTomeData;
import com.hollingsworth.arsnouveau.common.datagen.SimpleDataProvider;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAccelerate;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDurationDown;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSplit;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectAnimate;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectBlink;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectBreak;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectBurst;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectConjureWater;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectDelay;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectDispel;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectExplosion;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectFangs;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectFirework;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectFreeze;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectGlide;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectHarm;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectHeal;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectHex;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectIgnite;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectIntangible;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectKnockback;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectLaunch;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectLeap;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectLight;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectLightning;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectLinger;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectName;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectOrbit;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectPhantomBlock;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectPull;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectRune;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectSlowfall;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectSnare;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectSummonDecoy;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectWall;
import com.hollingsworth.arsnouveau.common.spell.method.MethodProjectile;
import com.hollingsworth.arsnouveau.common.spell.method.MethodSelf;
import com.hollingsworth.arsnouveau.common.spell.method.MethodTouch;
import com.hollingsworth.arsnouveau.common.spell.method.MethodUnderfoot;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.hollingsworth.arsnouveau.setup.registry.SoundRegistry;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public class CasterTomeProvider
extends SimpleDataProvider {
    public List<CasterRecipeWrapper> tomes = new ArrayList<CasterRecipeWrapper>();

    public CasterTomeProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    @Override
    public void collectJsons(CachedOutput pOutput) {
        this.tomes.add(this.buildTome("glow", "Glow Trap", new Spell().add((AbstractSpellPart)MethodTouch.INSTANCE).add((AbstractSpellPart)EffectRune.INSTANCE).add((AbstractSpellPart)EffectSnare.INSTANCE).add((AbstractSpellPart)AugmentExtendTime.INSTANCE).add((AbstractSpellPart)EffectLight.INSTANCE), "Snares the target and grants other targets Glowing."));
        this.tomes.add(this.buildTome("bailey", "Bailey's Bovine Rocket", new Spell().add((AbstractSpellPart)MethodProjectile.INSTANCE).add((AbstractSpellPart)EffectLaunch.INSTANCE).add((AbstractSpellPart)AugmentAmplify.INSTANCE, 2).add((AbstractSpellPart)EffectDelay.INSTANCE).add((AbstractSpellPart)EffectExplosion.INSTANCE).add((AbstractSpellPart)AugmentAmplify.INSTANCE), "To the MOOn"));
        this.tomes.add(this.buildTome("arachne", "Arachne's Weaving", new Spell().add((AbstractSpellPart)MethodProjectile.INSTANCE).add((AbstractSpellPart)AugmentSplit.INSTANCE, 2).add((AbstractSpellPart)EffectSnare.INSTANCE).add((AbstractSpellPart)AugmentExtendTime.INSTANCE).add((AbstractSpellPart)AugmentExtendTime.INSTANCE), "Creates three snaring projectiles."));
        this.tomes.add(this.buildTome("warp_impact", "Warp Impact", new Spell().add((AbstractSpellPart)MethodProjectile.INSTANCE).add((AbstractSpellPart)EffectBlink.INSTANCE).add((AbstractSpellPart)EffectExplosion.INSTANCE).add((AbstractSpellPart)AugmentAOE.INSTANCE), "Teleportation, with style!"));
        this.tomes.add(this.buildTome("farfalla", "Farfalla's Frosty Flames", new Spell().add((AbstractSpellPart)MethodProjectile.INSTANCE).add((AbstractSpellPart)EffectIgnite.INSTANCE).add((AbstractSpellPart)EffectDelay.INSTANCE).add((AbstractSpellPart)EffectConjureWater.INSTANCE).add((AbstractSpellPart)EffectFreeze.INSTANCE), "Creates a fire that quickly freezes to ice."));
        this.tomes.add(this.buildTome("gootastic", "Gootastic's Telekinetic Fishing Rod", new Spell().add((AbstractSpellPart)MethodProjectile.INSTANCE).add((AbstractSpellPart)EffectLaunch.INSTANCE).add((AbstractSpellPart)AugmentAmplify.INSTANCE, 2).add((AbstractSpellPart)EffectDelay.INSTANCE).add((AbstractSpellPart)EffectPull.INSTANCE).add((AbstractSpellPart)AugmentAmplify.INSTANCE, 2), "The squid's Lovecraftian roots appear to make it immune."));
        this.tomes.add(this.buildTome("toxin", "Potent Toxin", new Spell().add((AbstractSpellPart)MethodProjectile.INSTANCE).add((AbstractSpellPart)EffectHex.INSTANCE).add((AbstractSpellPart)EffectHarm.INSTANCE).add((AbstractSpellPart)AugmentExtendTime.INSTANCE), "Poisons that target and causes them to take additional damage from all sources."));
        this.tomes.add(this.buildTome("shadow", "The Shadow's Temporary Tunnel", new Spell().add((AbstractSpellPart)MethodTouch.INSTANCE).add((AbstractSpellPart)EffectIntangible.INSTANCE).add((AbstractSpellPart)AugmentAOE.INSTANCE, 2).add((AbstractSpellPart)AugmentPierce.INSTANCE, 5).add((AbstractSpellPart)AugmentExtendTime.INSTANCE), "Creates a temporary tunnel of blocks."));
        this.tomes.add(this.buildTome("vault", "Vault", new Spell().add((AbstractSpellPart)MethodSelf.INSTANCE).add((AbstractSpellPart)EffectLaunch.INSTANCE).add((AbstractSpellPart)EffectDelay.INSTANCE).add((AbstractSpellPart)EffectLeap.INSTANCE).add((AbstractSpellPart)EffectSlowfall.INSTANCE), "Sometimes you just need to get over that wall."));
        this.tomes.add(this.buildTome("fireball", "Fireball!", new Spell().add((AbstractSpellPart)MethodProjectile.INSTANCE).add((AbstractSpellPart)EffectIgnite.INSTANCE).add((AbstractSpellPart)EffectExplosion.INSTANCE).add((AbstractSpellPart)AugmentAmplify.INSTANCE, 2).add((AbstractSpellPart)AugmentAOE.INSTANCE, 2), "A classic."));
        this.tomes.add(this.buildTome("renew_rune", "Rune of Renewing", new Spell().add((AbstractSpellPart)MethodTouch.INSTANCE).add((AbstractSpellPart)EffectRune.INSTANCE).add((AbstractSpellPart)EffectDispel.INSTANCE).add((AbstractSpellPart)EffectHeal.INSTANCE).add((AbstractSpellPart)AugmentAmplify.INSTANCE), "Cures status effects and heals the user."));
        this.tomes.add(this.buildTome("yeet", "Knocked out of Orbit", new Spell().add((AbstractSpellPart)MethodSelf.INSTANCE).add((AbstractSpellPart)EffectOrbit.INSTANCE).add((AbstractSpellPart)EffectLaunch.INSTANCE).add((AbstractSpellPart)AugmentAmplify.INSTANCE, 2).add((AbstractSpellPart)EffectDelay.INSTANCE).add((AbstractSpellPart)EffectKnockback.INSTANCE).add((AbstractSpellPart)AugmentAmplify.INSTANCE, 2), "Summons orbiting projectiles that will launch nearby enemies."));
        this.tomes.add(this.buildTome("takeoff", "Takeoff!", new Spell().add((AbstractSpellPart)MethodSelf.INSTANCE).add((AbstractSpellPart)EffectLaunch.INSTANCE, 2).add((AbstractSpellPart)EffectGlide.INSTANCE).add((AbstractSpellPart)AugmentDurationDown.INSTANCE), "Launches the caster into the air and grants temporary elytra flight!"));
        this.tomes.add(this.buildTome("kirin", "KirinDave's Sinister Switch", new Spell().add((AbstractSpellPart)MethodSelf.INSTANCE).add((AbstractSpellPart)EffectSummonDecoy.INSTANCE).add((AbstractSpellPart)EffectBlink.INSTANCE).add((AbstractSpellPart)AugmentAmplify.INSTANCE), "Heroes are so straightforward, so easily befuddled...", new ParticleColor(25, 255, 255)));
        this.tomes.add(this.buildTome("xacris", "Xacris' Tiny Hut", new Spell().add((AbstractSpellPart)MethodUnderfoot.INSTANCE).add((AbstractSpellPart)EffectPhantomBlock.INSTANCE).add((AbstractSpellPart)AugmentAOE.INSTANCE, 3).add((AbstractSpellPart)AugmentPierce.INSTANCE, 3), "Builds a small hut around the user."));
        this.tomes.add(this.buildTome("xacris_2", "Xacris's Firework Display", new Spell().add((AbstractSpellPart)MethodProjectile.INSTANCE).add((AbstractSpellPart)EffectWall.INSTANCE).add((AbstractSpellPart)AugmentSensitive.INSTANCE).add((AbstractSpellPart)AugmentAOE.INSTANCE).add((AbstractSpellPart)EffectFirework.INSTANCE).add((AbstractSpellPart)AugmentExtendTime.INSTANCE, 4).add((AbstractSpellPart)AugmentAmplify.INSTANCE), "Light up the sky", new ParticleColor(25, 255, 255)));
        this.tomes.add(this.buildTome("othy", "Othy's Misdirection", new Spell().add((AbstractSpellPart)MethodSelf.INSTANCE).add((AbstractSpellPart)AugmentExtendTime.INSTANCE).add((AbstractSpellPart)EffectSummonDecoy.INSTANCE).add((AbstractSpellPart)EffectBlink.INSTANCE).add((AbstractSpellPart)AugmentAmplify.INSTANCE, 2), "Swarm your enemies with bladed spirits.", new ParticleColor(255, 255, 255)));
        this.tomes.add(this.buildTome("aurellia", "Aurellia's Bite Storm", new Spell().add((AbstractSpellPart)MethodProjectile.INSTANCE).add((AbstractSpellPart)EffectLinger.INSTANCE).add((AbstractSpellPart)AugmentSensitive.INSTANCE).add((AbstractSpellPart)EffectFangs.INSTANCE).add((AbstractSpellPart)EffectLightning.INSTANCE).add((AbstractSpellPart)AugmentAmplify.INSTANCE, 2).add((AbstractSpellPart)AugmentExtendTime.INSTANCE, 3).withSound(new ConfiguredSpellSound(SoundRegistry.TEMPESTRY_SPELL_SOUND)), "The bite from this storm is worse than its bark.", new ParticleColor(255, 119, 203)));
        this.tomes.add(this.buildTome("poseidon", "Poseidon's Refuge", new Spell(MethodProjectile.INSTANCE).add((AbstractSpellPart)AugmentSensitive.INSTANCE).add((AbstractSpellPart)EffectLight.INSTANCE).add((AbstractSpellPart)EffectBurst.INSTANCE).add((AbstractSpellPart)AugmentAOE.INSTANCE, 2).add((AbstractSpellPart)AugmentSensitive.INSTANCE).add((AbstractSpellPart)EffectFreeze.INSTANCE).add((AbstractSpellPart)EffectBreak.INSTANCE).add((AbstractSpellPart)EffectFreeze.INSTANCE).withSound(new ConfiguredSpellSound(SoundRegistry.TEMPESTRY_SPELL_SOUND)), "Fire at a body of water to create a Ice bubble in the depths.", new ParticleColor(0, 0, 255)));
        this.tomes.add(this.buildTome("chems", "Chem's Scientific Repulsion Runes", new Spell(MethodProjectile.INSTANCE).add((AbstractSpellPart)EffectLinger.INSTANCE).add((AbstractSpellPart)AugmentSensitive.INSTANCE).add((AbstractSpellPart)EffectRune.INSTANCE).add((AbstractSpellPart)EffectLaunch.INSTANCE, 4), "Smothers an area with runes that launch entities upward. Do NOT get covered in the Repulsion Runes.", new ParticleColor(61, 207, 248)));
        this.tomes.add(this.buildTome("ivy", "Ivy", new Spell(MethodTouch.INSTANCE).add((AbstractSpellPart)EffectAnimate.INSTANCE).add((AbstractSpellPart)AugmentExtendTime.INSTANCE, 7).add((AbstractSpellPart)EffectName.INSTANCE), "Now you never have to be lonely again! You will always have a friend with you! Feel free to change their name to whatever you want! :D", new ParticleColor(255, 105, 180)));
        this.tomes.add(this.buildTome("darkfira", "Darkfira's Flash Freeze", new Spell(MethodProjectile.INSTANCE).add((AbstractSpellPart)EffectBurst.INSTANCE).add((AbstractSpellPart)AugmentSensitive.INSTANCE).add((AbstractSpellPart)AugmentAOE.INSTANCE, 3).add((AbstractSpellPart)EffectConjureWater.INSTANCE).add((AbstractSpellPart)EffectFreeze.INSTANCE).add((AbstractSpellPart)EffectLightning.INSTANCE).add((AbstractSpellPart)AugmentAmplify.INSTANCE).withSound(new ConfiguredSpellSound(SoundRegistry.TEMPESTRY_SPELL_SOUND, 1.69f, 1.9f)), "Encases your enemies or friends in a tomb of ice. Guaranteed to leave them shocked and confused.", new ParticleColor(25, 255, 255)));
        this.tomes.add(this.buildTome("spinoftw", "You were hurt, but you're fine", new Spell(MethodSelf.INSTANCE).add((AbstractSpellPart)EffectConjureWater.INSTANCE).add((AbstractSpellPart)EffectHeal.INSTANCE).add((AbstractSpellPart)AugmentAmplify.INSTANCE, 2).add((AbstractSpellPart)EffectPhantomBlock.INSTANCE).add((AbstractSpellPart)AugmentAOE.INSTANCE, 3), " A utility spell to aid you in your adventures", new ParticleColor(225, 90, 1)));
        this.tomes.add(this.buildTome("lyrellion", "Lyrellion\u2019s Wall of Force", new Spell(MethodProjectile.INSTANCE).add((AbstractSpellPart)AugmentAccelerate.INSTANCE).add((AbstractSpellPart)EffectWall.INSTANCE).add((AbstractSpellPart)AugmentSensitive.INSTANCE).add((AbstractSpellPart)EffectPhantomBlock.INSTANCE).add((AbstractSpellPart)AugmentPierce.INSTANCE).add((AbstractSpellPart)AugmentAmplify.INSTANCE), "You. Shall. Not. Pass."));
        this.tomes.add(this.buildTome("silvanus", "Emergency Flair", new Spell(MethodTouch.INSTANCE).add((AbstractSpellPart)EffectLight.INSTANCE).add((AbstractSpellPart)AugmentExtendTime.INSTANCE, 3), "When you want to go deeper but just don't have the torches", new ParticleColor(0, 255, 0)));
        this.tomes.add(this.buildTome("uni", "Uni's Windshield", new Spell(MethodSelf.INSTANCE, EffectOrbit.INSTANCE, EffectKnockback.INSTANCE).add((AbstractSpellPart)AugmentAmplify.INSTANCE, 8), "Stay away!"));
        for (CasterRecipeWrapper g : this.tomes) {
            Path path = this.getRecipePath(this.output, g.id().getPath());
            this.saveStable(pOutput, (JsonElement)CasterTomeData.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)g.toData()).getOrThrow(), path);
        }
    }

    protected Path getRecipePath(Path pathIn, String str) {
        return pathIn.resolve("data/ars_nouveau/recipe/tomes/" + str + ".json");
    }

    public CasterRecipeWrapper buildTome(String id, String name, Spell spell, String flavorText) {
        return new CasterRecipeWrapper(ArsNouveau.prefix(id + "_tome"), name, spell.serializeRecipe(), ItemsRegistry.CASTER_TOME.registryObject.getId(), flavorText, spell.color().serialize(), spell.sound());
    }

    public CasterRecipeWrapper buildTome(String id, String name, Spell spell, String flavorText, ParticleColor color) {
        return new CasterRecipeWrapper(ArsNouveau.prefix(id + "_tome"), name, spell.serializeRecipe(), ItemsRegistry.CASTER_TOME.registryObject.getId(), flavorText, color.serialize(), spell.sound());
    }

    public String getName() {
        return "Ars Nouveau Caster Tomes Datagen";
    }

    public record CasterRecipeWrapper(ResourceLocation id, String name, List<ResourceLocation> spell, ResourceLocation tomeType, String flavorText, CompoundTag particleColor, ConfiguredSpellSound sound) {
        public CasterTomeData toData() {
            return new CasterTomeData(this.name, this.spell, this.tomeType, this.flavorText, this.particleColor, this.sound);
        }
    }
}

