/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.datagen;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.common.lib.LibBlockNames;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class BlockStatesDatagen
extends BlockStateProvider {
    public BlockStatesDatagen(PackOutput output, String modid, ExistingFileHelper exFileHelper) {
        super(output, modid, exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.registerOnlyState((Block)BlockRegistry.SOURCE_GEM_BLOCK.get(), "source_gem_block");
        this.registerOnlyState((Block)BlockRegistry.RED_SBED.get(), "red_sbed");
        this.registerOnlyState((Block)BlockRegistry.BLUE_SBED.get(), "blue_sbed");
        this.registerOnlyState((Block)BlockRegistry.GREEN_SBED.get(), "green_sbed");
        this.registerOnlyState((Block)BlockRegistry.YELLOW_SBED.get(), "yellow_sbed");
        this.registerOnlyState((Block)BlockRegistry.ORANGE_SBED.get(), "orange_sbed");
        this.registerOnlyState((Block)BlockRegistry.PURPLE_SBED.get(), "purple_sbed");
        this.registerOnlyState((Block)BlockRegistry.POTION_DIFFUSER.get(), "potion_diffuser");
        this.registerOnlyState((Block)BlockRegistry.AGRONOMIC_SOURCELINK.get(), "agronomic_sourcelink");
        this.registerOnlyState((Block)BlockRegistry.ALCHEMICAL_BLOCK.get(), "alchemical_sourcelink");
        this.registerOnlyState((Block)BlockRegistry.MYCELIAL_BLOCK.get(), "mycelial_sourcelink");
        this.registerOnlyState((Block)BlockRegistry.VITALIC_BLOCK.get(), "vitalic_sourcelink");
        this.registerOnlyState((Block)BlockRegistry.VOLCANIC_BLOCK.get(), "volcanic_sourcelink");
        for (Map.Entry<Supplier<ResourceLocation>, FlowerPotBlock> pot : BlockRegistry.flowerPots.entrySet()) {
            this.registerOnlyState((Block)pot.getValue(), "pots/" + LibBlockNames.Pot(pot.getKey().get().getPath()));
        }
        this.registerDoor((DoorBlock)BlockRegistry.ARCHWOOD_DOOR.get(), "archwood_door");
        this.registerNormalCube((Block)BlockRegistry.VOID_PRISM.get(), "void_prism");
        for (String s : LibBlockNames.DECORATIVE_SOURCESTONE) {
            this.registerNormalCube((Block)BuiltInRegistries.BLOCK.get(ArsNouveau.prefix(s)), s);
        }
        this.registerNormalCube((Block)BlockRegistry.MAGEBLOOM_BLOCK.get(), "magebloom_block");
        this.registerNormalCube((Block)BlockRegistry.FALSE_WEAVE.get(), "falseweave");
        this.registerNormalCube((Block)BlockRegistry.GHOST_WEAVE.get(), "ghostweave");
        this.registerNormalCube((Block)BlockRegistry.MIRROR_WEAVE.get(), "mirrorweave");
        for (String s : LibBlockNames.DECORATIVE_SOURCESTONE) {
            ResourceLocation tex = ArsNouveau.prefix("block/" + s);
            Block block = (Block)BuiltInRegistries.BLOCK.get(ArsNouveau.prefix(s + "_stairs"));
            this.stairsBlock((StairBlock)block, tex);
            Block slab = (Block)BuiltInRegistries.BLOCK.get(ArsNouveau.prefix(s + "_slab"));
            this.slabBlock((SlabBlock)slab, ArsNouveau.prefix(s), tex);
        }
    }

    private void registerOnlyState(Block block, String registry) {
        this.simpleBlock(block, BlockStatesDatagen.getUncheckedModel(registry));
    }

    private void registerDoor(DoorBlock door, String reg) {
        this.doorBlock(door, reg, this.getBlockLoc(reg + "_bottom"), this.getBlockLoc(reg + "_top"));
    }

    public void registerNormalCube(Block block, String registry) {
        this.buildNormalCube(registry);
        if (LibBlockNames.DIRECTIONAL_SOURCESTONE.contains(registry)) {
            this.horizontalBlock(block, BlockStatesDatagen.getUncheckedModel(registry));
        } else {
            this.simpleBlock(block, BlockStatesDatagen.getUncheckedModel(registry));
        }
    }

    public static ModelFile getUncheckedModel(String registry) {
        return new ModelFile.UncheckedModelFile("ars_nouveau:block/" + registry);
    }

    public void buildNormalCube(String registryName) {
        ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(registryName)).parent((ModelFile)new ModelFile.UncheckedModelFile("block/cube_all"))).texture("all", this.getBlockLoc(registryName));
    }

    public ResourceLocation getBlockLoc(String registryName) {
        return ArsNouveau.prefix("block/" + registryName);
    }
}

