/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.crafting.recipes;

import com.hollingsworth.arsnouveau.common.crafting.recipes.ApparatusRecipeInput;
import com.hollingsworth.arsnouveau.common.crafting.recipes.IEnchantingRecipe;
import com.hollingsworth.arsnouveau.common.crafting.recipes.Serializers;
import com.hollingsworth.arsnouveau.setup.registry.RecipeRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.RecipeMatcher;

public class EnchantingApparatusRecipe
implements IEnchantingRecipe {
    private final Ingredient reagent;
    private final ItemStack result;
    private final List<Ingredient> pedestalItems;
    private final int sourceCost;
    private final boolean keepNbtOfReagent;

    public EnchantingApparatusRecipe(Ingredient reagent, ItemStack result, List<Ingredient> pedestalItems, int sourceCost, boolean keepNbtOfReagent) {
        this.reagent = reagent;
        this.result = result;
        this.pedestalItems = pedestalItems;
        this.sourceCost = sourceCost;
        this.keepNbtOfReagent = keepNbtOfReagent;
    }

    public boolean excludeJei() {
        return false;
    }

    @Override
    public boolean matches(ApparatusRecipeInput input, Level level, @Nullable Player player) {
        List<ItemStack> pedestalItems = input.pedestals().stream().filter(itemStack -> !itemStack.isEmpty()).collect(Collectors.toList());
        return this.doesReagentMatch(input, level, player) && this.pedestalItems.size() == pedestalItems.size() && EnchantingApparatusRecipe.doItemsMatch(pedestalItems, this.pedestalItems);
    }

    public boolean doesReagentMatch(ApparatusRecipeInput input, Level level, @Nullable Player player) {
        return this.reagent.test(input.catalyst());
    }

    public static boolean doItemsMatch(List<ItemStack> inputs, List<Ingredient> recipeItems) {
        StackedContents recipeitemhelper = new StackedContents();
        for (ItemStack i : inputs) {
            recipeitemhelper.accountStack(i, 1);
        }
        return inputs.size() == recipeItems.size() && RecipeMatcher.findMatches(inputs, recipeItems) != null;
    }

    public ItemStack assemble(ApparatusRecipeInput input, HolderLookup.Provider p_346030_) {
        ItemStack result = this.result.copy();
        ItemStack reagent = input.catalyst();
        if (this.keepNbtOfReagent) {
            result.applyComponents(reagent.getComponents());
            result.setDamageValue(0);
        }
        return result.copy();
    }

    @Override
    public boolean consumesSource() {
        return this.sourceCost() > 0;
    }

    @Override
    public int sourceCost() {
        return this.sourceCost;
    }

    public ItemStack getResultItem(HolderLookup.Provider pRegistries) {
        return this.result.copy();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipeRegistry.APPARATUS_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)RecipeRegistry.APPARATUS_TYPE.get();
    }

    public Ingredient reagent() {
        return this.reagent;
    }

    public ItemStack result() {
        return this.result;
    }

    public List<Ingredient> pedestalItems() {
        return this.pedestalItems;
    }

    public boolean keepNbtOfReagent() {
        return this.keepNbtOfReagent;
    }

    public static class Serializer
    implements RecipeSerializer<EnchantingApparatusRecipe> {
        public static MapCodec<EnchantingApparatusRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("reagent").forGetter(EnchantingApparatusRecipe::reagent), (App)ItemStack.CODEC.fieldOf("result").forGetter(EnchantingApparatusRecipe::result), (App)Ingredient.CODEC.listOf().fieldOf("pedestalItems").forGetter(EnchantingApparatusRecipe::pedestalItems), (App)Codec.INT.fieldOf("sourceCost").forGetter(EnchantingApparatusRecipe::sourceCost), (App)Codec.BOOL.fieldOf("keepNbtOfReagent").forGetter(EnchantingApparatusRecipe::keepNbtOfReagent)).apply((Applicative)instance, EnchantingApparatusRecipe::new));
        public static StreamCodec<RegistryFriendlyByteBuf, EnchantingApparatusRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, EnchantingApparatusRecipe::reagent, (StreamCodec)ItemStack.STREAM_CODEC, EnchantingApparatusRecipe::result, Serializers.INGREDIENT_LIST_STREAM, EnchantingApparatusRecipe::pedestalItems, (StreamCodec)ByteBufCodecs.VAR_INT, EnchantingApparatusRecipe::sourceCost, (StreamCodec)ByteBufCodecs.BOOL, EnchantingApparatusRecipe::keepNbtOfReagent, EnchantingApparatusRecipe::new);

        public MapCodec<EnchantingApparatusRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, EnchantingApparatusRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

