/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.api.recipe.CraftingManager;
import com.hollingsworth.arsnouveau.api.recipe.IRecipeWrapper;
import com.hollingsworth.arsnouveau.api.recipe.MultiRecipeWrapper;
import com.hollingsworth.arsnouveau.api.recipe.PotionCraftingManager;
import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.client.particle.ColorPos;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.WixieCauldron;
import com.hollingsworth.arsnouveau.common.block.tile.ArcanePedestalTile;
import com.hollingsworth.arsnouveau.common.block.tile.PotionJarTile;
import com.hollingsworth.arsnouveau.common.block.tile.SummoningTile;
import com.hollingsworth.arsnouveau.common.entity.EntityFollowProjectile;
import com.hollingsworth.arsnouveau.common.entity.EntityWixie;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.common.util.PotionUtil;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class WixieCauldronTile
extends SummoningTile
implements ITooltipProvider,
IWandable {
    private List<BlockPos> cachedInventories;
    public List<BlockPos> boundedInvs = new ArrayList<BlockPos>();
    private ItemStack setStack;
    private ItemStack stackBeingCrafted;
    public int entityID;
    public boolean hasSource;
    public boolean isCraftingPotion;
    private boolean needsPotionStorage;
    public CraftingManager craftManager = new CraftingManager();
    private int craftCooldown;
    public int craftingIndex;

    public WixieCauldronTile(BlockEntityType<? extends WixieCauldronTile> wixieCauldronType, BlockPos pos, BlockState state) {
        super(wixieCauldronType, pos, state);
    }

    public WixieCauldronTile(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends WixieCauldronTile>)((BlockEntityType)BlockRegistry.WIXIE_CAULDRON_TYPE.get()), pos, state);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level == null || this.level.isClientSide()) {
            return;
        }
        if (this.craftCooldown > 0) {
            --this.craftCooldown;
            return;
        }
        if (!this.hasSource && this.level.getGameTime() % 5L == 0L && SourceUtil.takeSourceWithParticles(this.worldPosition, this.level, 6, 50) != null) {
            this.hasSource = true;
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.level.getBlockState(this.worldPosition).setValue((Property)WixieCauldron.FILLED, (Comparable)Boolean.valueOf(true)));
            this.setChanged();
        }
        if (!this.hasSource) {
            return;
        }
        if (this.level.getGameTime() % 100L == 0L) {
            this.updateInventories();
        }
        if (!this.level.isClientSide() && this.level.getGameTime() % 20L == 0L && this.craftManager.isCraftCompleted()) {
            this.rotateCraft();
        }
    }

    @Override
    public void onFinishedConnectionLast(@Nullable BlockPos storedPos, @Nullable LivingEntity storedEntity, Player playerEntity) {
        if (storedPos == null) {
            return;
        }
        IItemHandler itemHandler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, storedPos, null);
        if (itemHandler == null) {
            return;
        }
        if (!this.boundedInvs.contains(storedPos = storedPos.immutable())) {
            this.boundedInvs.add(storedPos);
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.wixie_cauldron.bound"));
        } else {
            this.boundedInvs.remove(storedPos);
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.wixie_cauldron.removed"));
        }
        this.updateBlock();
    }

    @Override
    public void onWanded(Player playerEntity) {
        if (!this.boundedInvs.isEmpty()) {
            this.boundedInvs = new ArrayList<BlockPos>();
            this.setStack = ItemStack.EMPTY;
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.wixie_cauldron.cleared"));
            this.updateBlock();
        }
    }

    @Override
    public List<ColorPos> getWandHighlight(List<ColorPos> list) {
        for (BlockPos blockPos : this.boundedInvs) {
            list.add(ColorPos.centered(blockPos, ParticleColor.FROM_HIGHLIGHT));
        }
        return list;
    }

    public void rotateCraft() {
        ICustomIngredient iCustomIngredient;
        BlockPos leftBound = this.worldPosition.below().south().east();
        BlockPos rightBound = this.worldPosition.above().north().west();
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        if (this.setStack != null && !this.setStack.isEmpty()) {
            itemStacks.add(this.setStack);
        }
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)leftBound, (BlockPos)rightBound)) {
            ArcanePedestalTile pedestalTile;
            BlockEntity blockEntity = this.level.getBlockEntity(pos);
            if (!(blockEntity instanceof ArcanePedestalTile) || (pedestalTile = (ArcanePedestalTile)blockEntity).getStack().isEmpty() || pedestalTile.hasSignal) continue;
            itemStacks.add(pedestalTile.getStack().copy());
        }
        if (itemStacks.isEmpty()) {
            return;
        }
        if (this.craftingIndex >= itemStacks.size()) {
            this.craftingIndex = 0;
        }
        ItemStack nextStack = (ItemStack)itemStacks.get(this.craftingIndex);
        MultiRecipeWrapper recipeWrapper = this.getRecipesForStack(nextStack);
        ++this.craftingIndex;
        if (recipeWrapper == null || recipeWrapper.isEmpty()) {
            return;
        }
        Map<Item, Integer> count = this.getInventoryCount();
        IRecipeWrapper.InstructionsForRecipe instructions = recipeWrapper.canCraft(count, this.level, this.worldPosition);
        if (instructions == null) {
            return;
        }
        if (!recipeWrapper.isEmpty() && (iCustomIngredient = instructions.recipe().recipeIngredients.get(0).getCustomIngredient()) instanceof DataComponentIngredient) {
            boolean foundRoomForOutput;
            DataComponentIngredient custom = (DataComponentIngredient)iCustomIngredient;
            Ingredient itemIngred = instructions.recipe().recipeIngredients.get(1);
            ArrayList<ItemStack> needed = new ArrayList<ItemStack>(Arrays.asList(itemIngred.getItems()));
            PotionContents potionNeeded = (PotionContents)((ItemStack)custom.getItems().toList().get(0)).get(DataComponents.POTION_CONTENTS);
            PotionContents potionOutput = PotionUtil.getContents(instructions.recipe().outputStack);
            boolean foundInput = potionNeeded.is(Potions.WATER) || WixieCauldronTile.findNeededPotion(potionNeeded, 300, this.level, this.worldPosition) != null;
            boolean bl = foundRoomForOutput = WixieCauldronTile.findPotionStorage(this.level, this.worldPosition, potionOutput) != null;
            if (!foundRoomForOutput || !foundInput) {
                return;
            }
            this.craftManager = new PotionCraftingManager(potionNeeded, needed, potionOutput);
        } else {
            this.craftManager = new CraftingManager(instructions.recipe().outputStack.copy(), instructions.itemsNeeded());
        }
        this.onCraftStart();
        this.level.sendBlockUpdated(this.worldPosition, this.level.getBlockState(this.worldPosition), this.level.getBlockState(this.worldPosition), 3);
        this.stackBeingCrafted = nextStack.copy();
        this.updateBlock();
    }

    public boolean hasWixie() {
        return !this.converted || this.level.getEntity(this.entityID) != null;
    }

    public boolean isCraftingDone() {
        return this.craftManager.canBeCompleted();
    }

    public boolean needsPotion() {
        PotionCraftingManager potionCraftingManager;
        CraftingManager craftingManager = this.craftManager;
        return craftingManager instanceof PotionCraftingManager && (potionCraftingManager = (PotionCraftingManager)craftingManager).needsPotion();
    }

    public PotionContents getNeededPotion() {
        PotionContents potionContents;
        CraftingManager craftingManager = this.craftManager;
        if (craftingManager instanceof PotionCraftingManager) {
            PotionCraftingManager potionCraftingManager = (PotionCraftingManager)craftingManager;
            potionContents = potionCraftingManager.getPotionNeeded();
        } else {
            potionContents = null;
        }
        return potionContents;
    }

    public void givePotion() {
        CraftingManager craftingManager = this.craftManager;
        if (craftingManager instanceof PotionCraftingManager) {
            PotionCraftingManager potionCraftingManager = (PotionCraftingManager)craftingManager;
            potionCraftingManager.setObtainedPotion(true);
            this.level.sendBlockUpdated(this.worldPosition, this.level.getBlockState(this.worldPosition), this.level.getBlockState(this.worldPosition), 3);
        }
    }

    public boolean giveItem(ItemStack stack) {
        boolean res = this.craftManager.giveItem(stack.getItem());
        this.level.sendBlockUpdated(this.worldPosition, this.level.getBlockState(this.worldPosition), this.level.getBlockState(this.worldPosition), 3);
        return res;
    }

    public void attemptFinish() {
        if (!this.craftManager.canBeCompleted() || this.craftManager.isCraftCompleted()) {
            return;
        }
        this.craftManager.completeCraft(this);
        this.craftCooldown = 1;
        this.stackBeingCrafted = ItemStack.EMPTY;
        this.updateBlock();
    }

    public MultiRecipeWrapper getRecipesForStack(ItemStack stack) {
        return MultiRecipeWrapper.fromStack(stack, this.level);
    }

    public void updateInventories() {
        if (!this.boundedInvs.isEmpty()) {
            return;
        }
        this.cachedInventories = new ArrayList<BlockPos>();
        for (BlockPos bPos : BlockPos.betweenClosed((BlockPos)this.worldPosition.north(6).east(6).below(2), (BlockPos)this.worldPosition.south(6).west(6).above(2))) {
            BlockEntity blockEntity;
            if (!this.level.isLoaded(bPos) || (blockEntity = this.level.getBlockEntity(bPos)) == null || blockEntity instanceof ArcanePedestalTile || this.level.getCapability(Capabilities.ItemHandler.BLOCK, bPos, null) == null) continue;
            this.cachedInventories.add(bPos.immutable());
        }
        this.setChanged();
    }

    @Nullable
    public static BlockPos findPotionStorage(Level level, BlockPos worldPosition, PotionContents passedPot) {
        for (BlockPos bPos : BlockPos.withinManhattan((BlockPos)worldPosition.below(2), (int)4, (int)3, (int)4)) {
            PotionJarTile tile;
            BlockEntity blockEntity = level.getBlockEntity(bPos);
            if (!(blockEntity instanceof PotionJarTile) || !(tile = (PotionJarTile)blockEntity).canAccept(passedPot, 300)) continue;
            return bPos.immutable();
        }
        return null;
    }

    @Nullable
    public static BlockPos findNeededPotion(PotionContents passedPot, int amount, Level level, BlockPos worldPosition) {
        for (BlockPos bPos : BlockPos.withinManhattan((BlockPos)worldPosition.below(2), (int)4, (int)3, (int)4)) {
            PotionJarTile tile;
            BlockEntity blockEntity = level.getBlockEntity(bPos);
            if (!(blockEntity instanceof PotionJarTile) || (tile = (PotionJarTile)blockEntity).getAmount() < amount || !PotionUtil.arePotionContentsEqual(tile.getData(), passedPot)) continue;
            return bPos.immutable();
        }
        return null;
    }

    @Override
    public void convertedEffect() {
        super.convertedEffect();
        if (this.tickCounter >= 120 && !this.level.isClientSide) {
            this.converted = true;
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)((BlockState)this.level.getBlockState(this.worldPosition).setValue((Property)WixieCauldron.FILLED, (Comparable)Boolean.valueOf(false))).setValue((Property)SummoningTile.CONVERTED, (Comparable)Boolean.valueOf(true)));
            EntityWixie wixie = new EntityWixie(this.level, this.worldPosition);
            wixie.setPos((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 1.0, (double)this.worldPosition.getZ() + 0.5);
            this.level.addFreshEntity((Entity)wixie);
            ParticleUtil.spawnPoof((ServerLevel)this.level, this.worldPosition.above());
            this.entityID = wixie.getId();
            this.tickCounter = 0;
            this.setChanged();
            return;
        }
        if (this.tickCounter % 10 == 0 && !this.level.isClientSide) {
            RandomSource r = this.level.random;
            int min = -2;
            int max = 2;
            EntityFollowProjectile proj1 = new EntityFollowProjectile(this.level, this.worldPosition.offset(r.nextInt(max - min) + min, 3, r.nextInt(max - min) + min), this.worldPosition, r.nextInt(255), r.nextInt(255), r.nextInt(255));
            this.level.addFreshEntity((Entity)proj1);
        }
    }

    private Map<Item, Integer> getInventoryCount() {
        ArrayList<BlockPos> stale = new ArrayList<BlockPos>();
        HashMap<Item, Integer> itemsAvailable = new HashMap<Item, Integer>();
        if (this.cachedInventories == null && this.boundedInvs.isEmpty()) {
            return itemsAvailable;
        }
        for (BlockPos p : this.getInventories()) {
            BlockEntity blockEntity = this.level.getBlockEntity(p);
            if (blockEntity == null) {
                stale.add(p);
                continue;
            }
            IItemHandler handler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, p, null);
            if (handler == null) {
                stale.add(p);
                continue;
            }
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (stack == null) {
                    System.out.println("======");
                    System.out.println("A MOD IS RETURNING A NULL STACK. THIS IS NOT ALLOWED YOU NERD. TELL THIS MOD AUTHOR TO FIX IT");
                    System.out.println(blockEntity.toString());
                    System.out.println("AT POS " + p.toString());
                    continue;
                }
                if (!itemsAvailable.containsKey(stack.getItem())) {
                    itemsAvailable.put(stack.getItem(), stack.getCount());
                    continue;
                }
                itemsAvailable.put(stack.getItem(), (Integer)itemsAvailable.get(stack.getItem()) + stack.getCount());
            }
        }
        if (this.boundedInvs.isEmpty()) {
            for (BlockPos p : stale) {
                this.cachedInventories.remove(p);
            }
        }
        return itemsAvailable;
    }

    @Override
    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.loadAdditional(compound, pRegistries);
        this.setStack = ItemStack.EMPTY;
        this.stackBeingCrafted = ItemStack.EMPTY;
        if (compound.contains("crafting")) {
            this.setStack = ItemStack.parseOptional((HolderLookup.Provider)pRegistries, (CompoundTag)compound.getCompound("crafting"));
        }
        if (compound.contains("currentCraft")) {
            this.stackBeingCrafted = ItemStack.parseOptional((HolderLookup.Provider)pRegistries, (CompoundTag)compound.getCompound("currentCraft"));
        }
        this.craftManager = CraftingManager.fromTag(pRegistries, compound);
        this.entityID = compound.getInt("entityid");
        this.hasSource = compound.getBoolean("hasmana");
        this.isCraftingPotion = compound.getBoolean("isPotion");
        this.needsPotionStorage = compound.getBoolean("storage");
        this.craftingIndex = compound.getInt("craftingIndex");
        this.boundedInvs = new ArrayList<BlockPos>();
        if (compound.contains("boundedInvs")) {
            ListTag list = compound.getList("boundedInvs", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag tag = list.getCompound(i);
                BlockPos pos = new BlockPos(tag.getInt("x"), tag.getInt("y"), tag.getInt("z"));
                this.boundedInvs.add(pos);
            }
        }
        this.craftCooldown = compound.getInt("craftCooldown");
    }

    @Override
    public void saveAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        Tag itemTag;
        super.saveAdditional(compound, pRegistries);
        if (this.setStack != null && !this.setStack.isEmpty()) {
            itemTag = this.setStack.save(pRegistries);
            compound.put("crafting", itemTag);
        }
        if (this.stackBeingCrafted != null) {
            itemTag = this.stackBeingCrafted.save(pRegistries);
            compound.put("currentCraft", itemTag);
        }
        if (this.craftManager != null) {
            this.craftManager.write(pRegistries, compound);
        }
        compound.putInt("entityid", this.entityID);
        compound.putBoolean("hasmana", this.hasSource);
        compound.putBoolean("isPotion", this.isCraftingPotion);
        compound.putBoolean("storage", this.needsPotionStorage);
        compound.putInt("craftingIndex", this.craftingIndex);
        ListTag boundedList = new ListTag();
        for (BlockPos pos : this.boundedInvs) {
            CompoundTag tag = new CompoundTag();
            tag.putInt("x", pos.getX());
            tag.putInt("y", pos.getY());
            tag.putInt("z", pos.getZ());
            boundedList.add((Object)tag);
        }
        compound.put("boundedInvs", (Tag)boundedList);
        compound.putInt("craftCooldown", this.craftCooldown);
    }

    @Override
    public void getTooltip(List<Component> tooltip) {
        CraftingManager contents;
        ItemStack potionStack;
        PotionCraftingManager potionCraftingManager;
        if (this.craftCooldown > 0) {
            return;
        }
        if (this.stackBeingCrafted == null || this.stackBeingCrafted.isEmpty()) {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.no_stack_crafting").withStyle(ChatFormatting.GOLD));
            return;
        }
        if (this.isOff) {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.tooltip.turned_off"));
        }
        if (!this.boundedInvs.isEmpty()) {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.cauldron.num_bounded", (Object[])new Object[]{this.boundedInvs.size()}));
        }
        if (this.craftManager != null && !(this.craftManager instanceof PotionCraftingManager)) {
            tooltip.add((Component)Component.literal((String)(Component.translatable((String)"ars_nouveau.wixie.crafting").getString() + Component.translatable((String)this.stackBeingCrafted.getDescriptionId()).getString())));
            if (this.stackBeingCrafted.getItem() == Items.POTION) {
                PotionUtil.getContents(this.stackBeingCrafted).addPotionTooltip(tooltip::add, 1.0f, 20.0f);
            }
        } else {
            CraftingManager craftingManager = this.craftManager;
            if (craftingManager instanceof PotionCraftingManager) {
                potionCraftingManager = (PotionCraftingManager)craftingManager;
                potionStack = new ItemStack((ItemLike)Items.POTION);
                potionStack.set(DataComponents.POTION_CONTENTS, (Object)potionCraftingManager.potionOut);
                tooltip.add((Component)Component.literal((String)(Component.translatable((String)"ars_nouveau.wixie.crafting").getString() + potionStack.getHoverName().getString())));
                potionCraftingManager.potionOut.addPotionTooltip(tooltip::add, 1.0f, 20.0f);
            }
        }
        if (!this.hasSource) {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.wixie.need_mana").withStyle(ChatFormatting.GOLD));
        }
        if (this.craftManager != null && !this.craftManager.neededItems.isEmpty()) {
            ItemStack neededStack = this.craftManager.neededItems.get(0);
            tooltip.add((Component)Component.literal((String)(Component.translatable((String)"ars_nouveau.wixie.needs").getString() + Component.translatable((String)neededStack.getDescriptionId()).getString())).withStyle(ChatFormatting.GOLD));
            if (neededStack.getItem() == Items.POTION) {
                contents = PotionUtil.getContents(neededStack);
                contents.addPotionTooltip(tooltip::add, 1.0f, 20.0f);
            }
        }
        if ((contents = this.craftManager) instanceof PotionCraftingManager && (potionCraftingManager = (PotionCraftingManager)contents).needsPotion()) {
            potionStack = new ItemStack((ItemLike)Items.POTION);
            potionStack.set(DataComponents.POTION_CONTENTS, (Object)potionCraftingManager.getPotionNeeded());
            tooltip.add((Component)Component.literal((String)(Component.translatable((String)"ars_nouveau.wixie.needs").getString() + potionStack.getHoverName().getString())).withStyle(ChatFormatting.GOLD));
        }
        if (this.needsPotionStorage) {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.wixie.needs_storage").withStyle(ChatFormatting.GOLD));
        }
    }

    public void setSetStack(ItemStack setStack) {
        this.setStack = setStack;
        this.updateBlock();
    }

    public List<BlockPos> getInventories() {
        return this.boundedInvs.isEmpty() ? this.cachedInventories : this.boundedInvs;
    }

    public boolean needsPotionStorage() {
        return this.needsPotionStorage;
    }

    public void setNeedsPotionStorage(boolean needsPotionStorage) {
        this.needsPotionStorage = needsPotionStorage;
        this.updateBlock();
    }

    public void onCraftingComplete() {
        this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.level.getBlockState(this.worldPosition).setValue((Property)WixieCauldron.FILLED, (Comparable)Boolean.valueOf(false)));
        this.level.playSound(null, this.worldPosition, SoundEvents.ILLUSIONER_CAST_SPELL, SoundSource.BLOCKS, 0.15f, 0.6f);
    }

    public void onCraftStart() {
    }
}

