/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.common.block.tile.LightTile;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TempLightTile
extends LightTile {
    int age;
    public double lengthModifier;

    public TempLightTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockRegistry.T_LIGHT_TILE.get(), pos, state);
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        this.age = nbt.getInt("age");
        this.lengthModifier = nbt.getDouble("modifier");
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(tag, pRegistries);
        tag.putDouble("modifier", this.lengthModifier);
        tag.put("age", (Tag)IntTag.valueOf((int)this.age));
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level != null && !this.level.isClientSide) {
            ++this.age;
            if ((double)this.age > 300.0 + 100.0 * this.lengthModifier) {
                this.level.destroyBlock(this.getBlockPos(), false);
                this.level.removeBlockEntity(this.getBlockPos());
            }
        }
    }
}

