/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.block.tile.ArcanePedestalTile;
import com.hollingsworth.arsnouveau.common.block.tile.SourcelinkTile;
import com.hollingsworth.arsnouveau.common.datagen.BlockTagProvider;
import com.hollingsworth.arsnouveau.common.datagen.ItemTagProvider;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketANEffect;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class MycelialSourcelinkTile
extends SourcelinkTile {
    public MycelialSourcelinkTile(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public MycelialSourcelinkTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockRegistry.MYCELIAL_TILE.get(), pos, state);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level.isClientSide) {
            return;
        }
        if (this.level.getGameTime() % 40L == 0L && this.canAcceptSource()) {
            ItemStack containerItem;
            for (ItemEntity itemEntity : this.level.getEntitiesOfClass(ItemEntity.class, new AABB(this.worldPosition).inflate(1.0))) {
                if (itemEntity.getItem().getItem().getFoodProperties(itemEntity.getItem(), null) == null) continue;
                int source = this.getSourceValue(itemEntity.getItem());
                this.addSource(source);
                containerItem = itemEntity.getItem().getCraftingRemainingItem();
                itemEntity.getItem().shrink(1);
                if (!containerItem.isEmpty()) {
                    this.level.addFreshEntity((Entity)new ItemEntity(this.level, itemEntity.getX(), itemEntity.getY(), itemEntity.getZ(), containerItem));
                }
                Networking.sendToNearbyClient(this.level, this.getBlockPos(), (CustomPacketPayload)new PacketANEffect(PacketANEffect.EffectType.BURST, itemEntity.blockPosition(), new ParticleColor(255, 255, 255), new int[0]));
            }
            for (ArcanePedestalTile arcanePedestalTile : this.getSurroundingPedestals()) {
                int sourceValue = this.getSourceValue(arcanePedestalTile.getItem(0));
                if (sourceValue <= 0) continue;
                this.addSource(sourceValue);
                containerItem = arcanePedestalTile.getItem(0).getCraftingRemainingItem();
                arcanePedestalTile.removeItem(0, 1);
                arcanePedestalTile.setItem(0, containerItem);
                Networking.sendToNearbyClient(this.level, this.getBlockPos(), (CustomPacketPayload)new PacketANEffect(PacketANEffect.EffectType.BURST, arcanePedestalTile.getBlockPos().above(), new ParticleColor(255, 255, 255), new int[0]));
            }
        }
    }

    public int getSourceValue(ItemStack i) {
        BlockItem blockItem;
        Item item;
        FoodProperties food = i.getItem().getFoodProperties(i, null);
        if (food == null) {
            return 0;
        }
        int mana = 0;
        mana += 11 * food.nutrition();
        mana = (int)((float)mana + 30.0f * food.saturation());
        ++this.progress;
        if (i.is(ItemTagProvider.MAGIC_FOOD) || (item = i.getItem()) instanceof BlockItem && (blockItem = (BlockItem)item).getBlock().defaultBlockState().is(BlockTagProvider.MAGIC_PLANTS)) {
            this.progress += 4;
            mana += 10;
            mana *= 2;
        }
        return mana;
    }

    @Override
    public void doRandomAction() {
        BlockPos dirtPos;
        super.doRandomAction();
        if (this.level.isClientSide) {
            return;
        }
        if (this.progress > 10) {
            for (BlockPos p : BlockPos.withinManhattan((BlockPos)this.worldPosition, (int)1, (int)0, (int)1)) {
                if (!this.level.getBlockState(p).isAir() || this.level.getBlockState(p.below()).getBlock() != Blocks.MYCELIUM) continue;
                this.level.setBlockAndUpdate(p, (double)this.level.getRandom().nextFloat() > 0.5 ? Blocks.BROWN_MUSHROOM.defaultBlockState() : Blocks.RED_MUSHROOM.defaultBlockState());
                this.progress -= 10;
                break;
            }
        }
        BlockPos blockPos = dirtPos = (dirtPos = this.getBlockInArea(Blocks.DIRT, 1)) == null ? this.getBlockInArea(Blocks.GRASS_BLOCK, 1) : dirtPos;
        if (dirtPos != null && this.progress >= 25) {
            this.level.setBlockAndUpdate(dirtPos, Blocks.MYCELIUM.defaultBlockState());
            this.progress -= 25;
        }
    }

    public BlockPos getBlockInArea(Block block, int range) {
        AtomicReference posFound = new AtomicReference();
        BlockPos.betweenClosedStream((BlockPos)this.worldPosition.offset(range, -1, range), (BlockPos)this.worldPosition.offset(-range, -1, -range)).forEach(blockPos -> {
            blockPos = blockPos.immutable();
            if (posFound.get() == null && this.level.getBlockState(blockPos).getBlock() == block) {
                posFound.set(blockPos);
            }
        });
        return (BlockPos)posFound.get();
    }
}

