/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.block.IPedestalMachine;
import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.source.AbstractSourceMachine;
import com.hollingsworth.arsnouveau.api.source.ISpecialSourceProvider;
import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleLineData;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.common.block.tile.ArcanePedestalTile;
import com.hollingsworth.arsnouveau.common.crafting.recipes.ImbuementRecipe;
import com.hollingsworth.arsnouveau.common.entity.EntityFlyingItem;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.RecipeRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ImbuementTile
extends AbstractSourceMachine
implements Container,
ITickable,
GeoBlockEntity,
ITooltipProvider,
IPedestalMachine,
RecipeInput {
    public ItemStack stack = ItemStack.EMPTY;
    public ItemEntity entity;
    public boolean draining;
    ImbuementRecipe recipe;
    int backoff;
    public float frames;
    boolean hasRecipe;
    int craftTicks;
    AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public ImbuementTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockRegistry.IMBUEMENT_TILE.get(), pos, state);
    }

    @Override
    public int getTransferRate() {
        return 0;
    }

    @Override
    public void lightPedestal(Level level) {
        if (level != null) {
            for (BlockPos pos : this.pedestalList(this.getBlockPos(), 1, level)) {
                ParticleUtil.spawnOrb(level, ParticleColor.makeRandomColor(255, 255, 255, level.random), pos.above(), 300);
            }
        }
    }

    @Override
    public void tick() {
        RecipeHolder<ImbuementRecipe> foundRecipe;
        if (this.level == null) {
            return;
        }
        if (this.level.isClientSide) {
            float scaleAge;
            int baseAge = this.draining ? 20 : 40;
            int randBound = this.draining ? 3 : 6;
            int numParticles = this.draining ? 2 : 1;
            float f = scaleAge = this.draining ? (float)ParticleUtil.inRange(0.1, 0.2) : (float)ParticleUtil.inRange(0.05, 0.15);
            if (this.level.random.nextInt(randBound) == 0 && !Minecraft.getInstance().isPaused()) {
                for (int i = 0; i < numParticles; ++i) {
                    Vec3 particlePos = new Vec3(this.getX(), this.getY(), this.getZ()).add(0.5, 0.5, 0.5);
                    particlePos = particlePos.add(ParticleUtil.pointInSphere());
                    this.level.addParticle(ParticleLineData.createData(new ParticleColor(255, 25, 180), scaleAge, baseAge + this.level.random.nextInt(20)), particlePos.x(), particlePos.y(), particlePos.z(), this.getX() + 0.5, this.getY() + 0.5, this.getZ() + 0.5);
                }
            }
            if (!this.stack.isEmpty() && this.recipe == null) {
                RecipeHolder<ImbuementRecipe> holder = this.getRecipeNow();
                this.recipe = holder != null ? (ImbuementRecipe)holder.value() : null;
            }
            return;
        }
        boolean bl = this.hasRecipe = this.recipe != null;
        if (this.backoff > 0) {
            --this.backoff;
            return;
        }
        if (this.stack.isEmpty()) {
            return;
        }
        if (this.craftTicks > 0) {
            --this.craftTicks;
        }
        if (this.recipe == null && (foundRecipe = this.getRecipeNow()) != null) {
            this.recipe = (ImbuementRecipe)foundRecipe.value();
            this.craftTicks = 100;
        }
        if (this.recipe == null || !this.recipe.matches(this, this.level)) {
            this.backoff = 20;
            this.recipe = null;
            if (this.draining) {
                this.draining = false;
                this.updateBlock();
            }
            return;
        }
        int transferRate = 200;
        if (this.level.getGameTime() % 20L == 0L && this.getSource() < this.recipe.source) {
            if (!this.canAcceptSource(Math.min(200, this.recipe.source))) {
                return;
            }
            ISpecialSourceProvider takePos = SourceUtil.takeSource(this.worldPosition, this.level, 2, Math.min(200, this.recipe.source));
            if (takePos != null) {
                this.addSource(transferRate);
                EntityFlyingItem item = new EntityFlyingItem(this.level, takePos.getCurrentPos().above(), this.worldPosition, 255, 50, 80).withNoTouch();
                item.setDistanceAdjust(2.0f);
                this.level.addFreshEntity((Entity)item);
                if (!this.draining) {
                    this.draining = true;
                    this.updateBlock();
                }
            } else {
                this.addSource(10);
                if (this.draining) {
                    this.draining = false;
                    this.updateBlock();
                }
            }
        }
        if (this.getSource() >= this.recipe.source && this.craftTicks <= 0) {
            this.setItem(0, this.recipe.output.copy());
            this.addSource(-this.recipe.source);
            ParticleUtil.spawnTouchPacket(this.level, this.worldPosition, ParticleColor.defaultParticleColor());
            this.updateBlock();
        }
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(tag, pRegistries);
        this.stack = ItemStack.parseOptional((HolderLookup.Provider)pRegistries, (CompoundTag)tag.getCompound("itemStack"));
        this.draining = tag.getBoolean("draining");
        this.hasRecipe = tag.getBoolean("hasRecipe");
        this.craftTicks = tag.getInt("craftTicks");
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(tag, pRegistries);
        if (!this.stack.isEmpty()) {
            Tag reagentTag = this.stack.save(pRegistries);
            tag.put("itemStack", reagentTag);
        }
        tag.putBoolean("draining", this.draining);
        tag.putBoolean("hasRecipe", this.hasRecipe);
        tag.putInt("craftTicks", this.craftTicks);
    }

    @Override
    public int getMaxSource() {
        return 10000000;
    }

    public int getContainerSize() {
        return 1;
    }

    public int getMaxStackSize() {
        return 1;
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        if (stack.isEmpty() || !this.stack.isEmpty()) {
            return false;
        }
        this.stack = stack.copy();
        RecipeHolder<ImbuementRecipe> recipe = this.getRecipeNow();
        this.stack = ItemStack.EMPTY;
        return recipe != null;
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public ItemStack getItem(int index) {
        return this.stack;
    }

    public int size() {
        return 1;
    }

    public ItemStack removeItem(int index, int count) {
        ItemStack split = this.stack.split(count);
        this.updateBlock();
        return split;
    }

    public ItemStack removeItemNoUpdate(int index) {
        ItemStack stack = this.stack.copy();
        this.stack = ItemStack.EMPTY;
        this.setChanged();
        return stack;
    }

    public void setItem(int index, ItemStack stack) {
        this.stack = stack;
        this.craftTicks = 100;
        this.updateBlock();
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void clearContent() {
        this.stack = ItemStack.EMPTY;
        this.updateBlock();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "controller", 1, this::idlePredicate));
        data.add(new AnimationController((GeoAnimatable)this, "slowcraft_controller", 1, this::slowCraftPredicate));
    }

    private PlayState slowCraftPredicate(AnimationState<?> AnimationState2) {
        AnimationState2.getController().setAnimation(RawAnimation.begin().thenPlay("imbue_slow"));
        return PlayState.CONTINUE;
    }

    private PlayState idlePredicate(AnimationState<?> AnimationState2) {
        AnimationState2.getController().setAnimation(RawAnimation.begin().thenPlay("float"));
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public List<ItemStack> getPedestalItems() {
        ArrayList<ItemStack> pedestalItems = new ArrayList<ItemStack>();
        for (BlockPos p : this.getNearbyPedestals()) {
            ArcanePedestalTile pedestalTile;
            BlockEntity blockEntity = this.level.getBlockEntity(p);
            if (!(blockEntity instanceof ArcanePedestalTile) || (pedestalTile = (ArcanePedestalTile)blockEntity).getStack().isEmpty()) continue;
            pedestalItems.add(pedestalTile.getStack());
        }
        return pedestalItems;
    }

    public List<BlockPos> getNearbyPedestals() {
        return this.pedestalList(this.getBlockPos(), 1, this.getLevel());
    }

    @Nullable
    public RecipeHolder<ImbuementRecipe> getRecipeNow() {
        return this.level.getRecipeManager().getAllRecipesFor((RecipeType)RecipeRegistry.IMBUEMENT_TYPE.get()).stream().filter(f -> ((ImbuementRecipe)f.value()).matches(this, this.level)).findFirst().orElse(null);
    }

    @Override
    public void getTooltip(List<Component> tooltip) {
        RecipeHolder<ImbuementRecipe> recipe = this.getRecipeNow();
        if (recipe != null && !((ImbuementRecipe)recipe.value()).output.isEmpty() && this.stack != null && !this.stack.isEmpty()) {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.crafting", (Object[])new Object[]{((ImbuementRecipe)recipe.value()).output.getHoverName()}));
            if (((ImbuementRecipe)recipe.value()).source > 0) {
                tooltip.add((Component)Component.translatable((String)"ars_nouveau.crafting_progress", (Object[])new Object[]{Math.min(100, this.getSource() * 100 / ((ImbuementRecipe)recipe.value()).source)}).withStyle(ChatFormatting.GOLD));
            }
        }
    }
}

