/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.event.EventQueue;
import com.hollingsworth.arsnouveau.common.block.tile.MirrorWeaveTile;
import com.hollingsworth.arsnouveau.common.event.timed.GhostweaveVisibilityEvent;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class GhostWeaveTile
extends MirrorWeaveTile {
    private boolean invisible;

    public GhostWeaveTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockRegistry.GHOST_WEAVE_TILE.get(), pos, state);
    }

    public void setVisibility(boolean invisible) {
        if (this.invisible == invisible) {
            return;
        }
        int ticks = 1;
        for (Direction d : Direction.values()) {
            BlockPos offset = this.getBlockPos().relative(d);
            BlockEntity blockEntity = this.level.getBlockEntity(offset);
            if (!(blockEntity instanceof GhostWeaveTile)) continue;
            GhostWeaveTile neighbor = (GhostWeaveTile)blockEntity;
            if (this.isInvisible() != neighbor.isInvisible()) continue;
            EventQueue.getServerInstance().addEvent(new GhostweaveVisibilityEvent(neighbor, ++ticks, invisible));
        }
        this.invisible = invisible;
        this.updateBlock();
    }

    public boolean isInvisible() {
        return this.invisible;
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(tag, pRegistries);
        tag.putBoolean("invisible", this.invisible);
    }

    @Override
    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.loadAdditional(compound, pRegistries);
        this.invisible = compound.getBoolean("invisible");
    }

    @Override
    public BlockState getDefaultBlockState() {
        return BlockRegistry.GHOST_WEAVE.defaultBlockState();
    }
}

