/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.tile.MobJarTile;
import com.hollingsworth.arsnouveau.common.block.tile.SummoningTile;
import com.hollingsworth.arsnouveau.common.entity.EntityDrygmy;
import com.hollingsworth.arsnouveau.common.entity.EntityFollowProjectile;
import com.hollingsworth.arsnouveau.common.lib.EntityTags;
import com.hollingsworth.arsnouveau.setup.config.Config;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;

public class DrygmyTile
extends SummoningTile
implements ITooltipProvider {
    public int progress;
    public int bonus;
    public boolean needsMana;
    private List<LivingEntity> nearbyEntities;

    public DrygmyTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockRegistry.DRYGMY_TILE.get(), pos, state);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level.isClientSide) {
            for (int i = 0; i < this.progress / 2; ++i) {
                this.level.addParticle(GlowParticleData.createData(new ParticleColor(50, 255, 20)), (double)this.getBlockPos().getX() + 0.5 + ParticleUtil.inRange(-0.1, 0.1), (double)(this.getBlockPos().getY() + 1) + ParticleUtil.inRange(-0.1, 0.1), (double)this.getBlockPos().getZ() + 0.5 + ParticleUtil.inRange(-0.1, 0.1), 0.0, 0.0, 0.0);
            }
        } else {
            if (this.level.getGameTime() % 100L == 0L) {
                this.refreshEntitiesAndBonus();
            }
            if (this.level.getGameTime() % 80L == 0L && this.needsMana && SourceUtil.takeSourceWithParticles(this.worldPosition, this.level, 7, (Integer)Config.DRYGMY_MANA_COST.get()) != null) {
                this.needsMana = false;
                this.updateBlock();
            }
            if (this.level.getGameTime() % 100L == 0L && !this.needsMana && this.progress >= this.getMaxProgress() && !this.getNearbyEntities().isEmpty()) {
                this.generateItems();
            }
        }
    }

    public List<LivingEntity> getNearbyEntities() {
        if (this.nearbyEntities == null) {
            this.refreshEntitiesAndBonus();
        }
        return this.nearbyEntities;
    }

    @Nullable
    public LivingEntity getRandomEntity() {
        if (this.getNearbyEntities().isEmpty()) {
            return null;
        }
        return this.getNearbyEntities().get(new Random().nextInt(this.getNearbyEntities().size()));
    }

    public void giveProgress() {
        if (this.progress < this.getMaxProgress()) {
            ++this.progress;
            this.updateBlock();
        }
    }

    public int getMaxProgress() {
        return (Integer)Config.DRYGMY_MAX_PROGRESS.get();
    }

    @Override
    public void convertedEffect() {
        super.convertedEffect();
        if (this.tickCounter >= 120 && !this.level.isClientSide) {
            this.converted = true;
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.level.getBlockState(this.worldPosition).setValue((Property)SummoningTile.CONVERTED, (Comparable)Boolean.valueOf(true)));
            EntityDrygmy entityDrygmy = new EntityDrygmy(this.level, true);
            entityDrygmy.setPos((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 1.0, (double)this.worldPosition.getZ() + 0.5);
            entityDrygmy.homePos = new BlockPos((Vec3i)this.getBlockPos());
            this.level.addFreshEntity((Entity)entityDrygmy);
            ParticleUtil.spawnPoof((ServerLevel)this.level, this.worldPosition.above());
            this.tickCounter = 0;
            return;
        }
        if (this.tickCounter % 10 == 0 && !this.level.isClientSide) {
            RandomSource r = this.level.random;
            int min = -2;
            int max = 2;
            EntityFollowProjectile proj1 = new EntityFollowProjectile(this.level, this.worldPosition.offset(r.nextInt(max - min) + min, 3, r.nextInt(max - min) + min), this.worldPosition, r.nextInt(255), r.nextInt(255), r.nextInt(255));
            this.level.addFreshEntity((Entity)proj1);
        }
    }

    public void refreshEntitiesAndBonus() {
        this.nearbyEntities = this.level.getEntitiesOfClass(LivingEntity.class, new AABB(this.getBlockPos().north(10).west(10).below(6).getBottomCenter(), this.getBlockPos().south(10).east(10).above(6).getBottomCenter()));
        for (BlockPos b : BlockPos.withinManhattan((BlockPos)this.getBlockPos(), (int)10, (int)10, (int)10)) {
            MobJarTile mobJarTile;
            BlockEntity blockEntity = this.level.getBlockEntity(b);
            if (!(blockEntity instanceof MobJarTile) || !((blockEntity = (mobJarTile = (MobJarTile)blockEntity).getEntity()) instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)blockEntity;
            this.nearbyEntities.add(livingEntity);
        }
        this.nearbyEntities = this.nearbyEntities.stream().filter(l -> !(l instanceof EntityDrygmy) && !(l instanceof Player)).collect(Collectors.toList());
        Set uniqueEntities = this.nearbyEntities.stream().map(l -> EntityType.getKey((EntityType)l.getType())).collect(Collectors.toSet());
        this.bonus = uniqueEntities.size() * (Integer)Config.DRYGMY_UNIQUE_BONUS.get() + Math.min((Integer)Config.DRYGMY_QUANTITY_CAP.get(), this.nearbyEntities.size());
        this.updateBlock();
    }

    public void generateItems() {
        ArrayList stacks = new ArrayList();
        ANFakePlayer fakePlayer = ANFakePlayer.getPlayer((ServerLevel)this.level);
        DamageSource damageSource = this.level.damageSources().playerAttack((Player)fakePlayer);
        int numberItems = (Integer)Config.DRYGMY_BASE_ITEM.get() + this.bonus;
        int exp = 0;
        for (LivingEntity entity : this.getNearbyEntities()) {
            Mob mob;
            if (entity.getType().is(EntityTags.DRYGMY_BLACKLIST)) continue;
            LootTable loottable = (LootTable)((Registry)this.level.registryAccess().registry(Registries.LOOT_TABLE).get()).get(entity.getLootTable());
            LootParams.Builder lootcontext$builder = new LootParams.Builder((ServerLevel)this.level).withParameter(LootContextParams.THIS_ENTITY, (Object)entity).withParameter(LootContextParams.ORIGIN, (Object)entity.position()).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)damageSource).withOptionalParameter(LootContextParams.ATTACKING_ENTITY, (Object)fakePlayer).withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)damageSource.getDirectEntity());
            lootcontext$builder = lootcontext$builder.withParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)fakePlayer).withLuck(fakePlayer.getLuck());
            stacks.addAll(loottable.getRandomItems(lootcontext$builder.create(LootContextParamSets.ENTITY)));
            int oldExp = 0;
            if (entity instanceof Mob) {
                mob = (Mob)entity;
                oldExp = mob.xpReward;
            }
            exp += entity.getExperienceReward((ServerLevel)this.level, (Entity)fakePlayer);
            if (!(entity instanceof Mob)) continue;
            mob = (Mob)entity;
            mob.xpReward = oldExp;
        }
        int itemsPicked = 0;
        if (!stacks.isEmpty()) {
            for (int i = 0; i < numberItems; ++i) {
                ItemStack stack = ((ItemStack)stacks.get(this.level.random.nextInt(stacks.size()))).copy();
                BlockUtil.insertItemAdjacent(this.level, this.worldPosition, stack);
                if ((itemsPicked += stack.getCount()) >= numberItems) break;
            }
        }
        if ((exp = (int)((double)exp * 0.25)) > 3) {
            int numLesser;
            int numGreater;
            if ((exp -= (numGreater = exp / 12) * 12) - (numLesser = exp / 3) * 3 > 0) {
                ++numLesser;
            }
            if (numGreater > 0) {
                BlockUtil.insertItemAdjacent(this.level, this.worldPosition, new ItemStack((ItemLike)ItemsRegistry.GREATER_EXPERIENCE_GEM.get(), numGreater));
            }
            if (numLesser > 0) {
                BlockUtil.insertItemAdjacent(this.level, this.worldPosition, new ItemStack((ItemLike)ItemsRegistry.EXPERIENCE_GEM.get(), numLesser));
            }
        }
        this.progress = 0;
        this.needsMana = true;
        this.updateBlock();
    }

    @Override
    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.loadAdditional(compound, pRegistries);
        this.progress = compound.getInt("progress");
        this.bonus = compound.getInt("bonus");
        this.needsMana = compound.getBoolean("needsMana");
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(tag, pRegistries);
        tag.putInt("progress", this.progress);
        tag.putInt("bonus", this.bonus);
        tag.putBoolean("needsMana", this.needsMana);
    }

    @Override
    public void getTooltip(List<Component> tooltip) {
        if (this.isOff) {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.tooltip.turned_off"));
        }
        if (this.needsMana) {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.wixie.need_mana"));
        }
    }
}

