/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.client.container.CraftingTerminalMenu;
import com.hollingsworth.arsnouveau.client.container.StoredItemStack;
import com.hollingsworth.arsnouveau.common.block.tile.StorageLecternTile;
import com.hollingsworth.arsnouveau.common.block.tile.TransientCustomContainer;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CraftingLecternTile
extends StorageLecternTile
implements GeoBlockEntity {
    private AbstractContainerMenu craftingContainer = new AbstractContainerMenu(MenuType.CRAFTING, 0){

        public boolean stillValid(Player player) {
            return false;
        }

        public void slotsChanged(Container inventory) {
            if (CraftingLecternTile.this.level != null && !((CraftingLecternTile)CraftingLecternTile.this).level.isClientSide) {
                CraftingLecternTile.this.onCraftingMatrixChanged();
            }
        }

        public ItemStack quickMoveStack(Player p_38941_, int p_38942_) {
            return ItemStack.EMPTY;
        }
    };
    private CraftingRecipe currentRecipe;
    private final TransientCustomContainer craftMatrix = new TransientCustomContainer(this.craftingContainer, 3, 3);
    private ResultContainer craftResult = new ResultContainer();
    private HashSet<CraftingTerminalMenu> craftingListeners = new HashSet();
    private boolean reading;
    AnimatableInstanceCache AnimatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public CraftingLecternTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockRegistry.CRAFTING_LECTERN_TILE.get(), pos, state);
    }

    @Override
    public AbstractContainerMenu createMenu(int id, Inventory plInv, Player arg2) {
        return new CraftingTerminalMenu(id, plInv, this);
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(tag, pRegistries);
        ListTag listnbt = new ListTag();
        for (int i = 0; i < this.craftMatrix.getContainerSize(); ++i) {
            ItemStack itemstack = this.craftMatrix.getItem(i);
            if (itemstack.isEmpty()) continue;
            CompoundTag compoundnbt = new CompoundTag();
            compoundnbt.putInt("Slot", i);
            compoundnbt.put("item", itemstack.save(pRegistries));
            listnbt.add((Object)compoundnbt);
        }
        tag.put("CraftingTable", (Tag)listnbt);
    }

    @Override
    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.loadAdditional(compound, pRegistries);
        this.reading = true;
        ListTag listnbt = compound.getList("CraftingTable", 10);
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundTag compoundnbt = listnbt.getCompound(i);
            int j = compoundnbt.getInt("Slot");
            if (j < 0 || j >= this.craftMatrix.getContainerSize()) continue;
            this.craftMatrix.setItem(j, ItemStack.parseOptional((HolderLookup.Provider)pRegistries, (CompoundTag)compoundnbt.getCompound("item")));
        }
        this.reading = false;
    }

    public CraftingContainer getCraftingInv() {
        return this.craftMatrix;
    }

    public ResultContainer getCraftResult() {
        return this.craftResult;
    }

    public void craftShift(Player player, @Nullable String tab) {
        ArrayList<ItemStack> craftedItemsList = new ArrayList<ItemStack>();
        int amountCrafted = 0;
        ItemStack crafted = this.craftResult.getItem(0);
        do {
            this.craft(player, tab);
            craftedItemsList.add(crafted.copy());
        } while (ItemStack.isSameItem((ItemStack)crafted, (ItemStack)this.craftResult.getItem(0)) && (amountCrafted += crafted.getCount()) + crafted.getCount() <= crafted.getMaxStackSize());
        for (ItemStack craftedItem : craftedItemsList) {
            ItemStack is;
            if (player.getInventory().add(craftedItem.copy()) || (is = this.pushStack(craftedItem, tab)).isEmpty()) continue;
            Containers.dropItemStack((Level)this.level, (double)player.getX(), (double)player.getY(), (double)player.getZ(), (ItemStack)is);
        }
        crafted.onCraftedBy(player.level, player, amountCrafted);
        ItemStack copyStack = crafted.copy();
        copyStack.setCount(amountCrafted);
        EventHooks.firePlayerCraftingEvent((Player)player, (ItemStack)copyStack, (Container)this.craftMatrix);
    }

    public void craft(Player thePlayer, @Nullable String tab) {
        if (this.currentRecipe == null) {
            return;
        }
        NonNullList remainder = this.currentRecipe.getRemainingItems((RecipeInput)this.craftMatrix.asCraftInput());
        boolean playerInvUpdate = false;
        for (int i = 0; i < remainder.size(); ++i) {
            ItemStack currentStack = this.craftMatrix.getItem(i);
            ItemStack oldItem = currentStack.copy();
            ItemStack rem = (ItemStack)remainder.get(i);
            if (!currentStack.isEmpty()) {
                this.craftMatrix.removeItemNoUpdate(i, 1);
                currentStack = this.craftMatrix.getItem(i);
            }
            if (currentStack.isEmpty() && !oldItem.isEmpty()) {
                StoredItemStack is = this.pullStack(new StoredItemStack(oldItem), 1, tab);
                if (is == null) {
                    for (int j = 0; j < thePlayer.getInventory().getContainerSize(); ++j) {
                        ItemStack st = thePlayer.getInventory().getItem(j);
                        if (!ItemStack.isSameItem((ItemStack)oldItem, (ItemStack)st) || !ItemStack.matches((ItemStack)oldItem, (ItemStack)st) || (st = thePlayer.getInventory().removeItem(j, 1)).isEmpty()) continue;
                        is = new StoredItemStack(st, 1L);
                        playerInvUpdate = true;
                        break;
                    }
                }
                if (is != null) {
                    this.craftMatrix.setItemNoUpdate(i, is.getActualStack());
                    currentStack = this.craftMatrix.getItem(i);
                }
            }
            if (rem.isEmpty()) continue;
            if (currentStack.isEmpty()) {
                this.craftMatrix.setItemNoUpdate(i, rem);
                continue;
            }
            if (ItemStack.isSameItem((ItemStack)currentStack, (ItemStack)rem) && ItemStack.matches((ItemStack)currentStack, (ItemStack)rem)) {
                rem.grow(currentStack.getCount());
                this.craftMatrix.setItemNoUpdate(i, rem);
                continue;
            }
            if ((rem = this.pushStack(rem, tab)).isEmpty() || thePlayer.getInventory().add(rem)) continue;
            thePlayer.drop(rem, false);
        }
        if (playerInvUpdate) {
            thePlayer.containerMenu.broadcastChanges();
        }
        this.onCraftingMatrixChanged();
    }

    public void unregisterCrafting(CraftingTerminalMenu containerCraftingTerminal) {
        this.craftingListeners.remove(containerCraftingTerminal);
    }

    public void registerCrafting(CraftingTerminalMenu containerCraftingTerminal) {
        this.craftingListeners.add(containerCraftingTerminal);
    }

    protected void onCraftingMatrixChanged() {
        RecipeHolder holder;
        if (!(this.currentRecipe != null && this.currentRecipe.matches((RecipeInput)this.craftMatrix.asCraftInput(), this.level) || (holder = (RecipeHolder)this.level.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)this.craftMatrix.asCraftInput(), this.level).orElse(null)) == null)) {
            this.currentRecipe = (CraftingRecipe)holder.value();
        }
        if (this.currentRecipe == null) {
            this.craftResult.setItem(0, ItemStack.EMPTY);
        } else {
            this.craftResult.setItem(0, this.currentRecipe.assemble((RecipeInput)this.craftMatrix.asCraftInput(), (HolderLookup.Provider)this.level.registryAccess()));
        }
        this.craftingListeners.forEach(CraftingTerminalMenu::onCraftMatrixChanged);
        if (!this.reading) {
            this.setChanged();
        }
    }

    public void clear(@Nullable String tab) {
        for (int i = 0; i < this.craftMatrix.getContainerSize(); ++i) {
            ItemStack st = this.craftMatrix.removeItemNoUpdate(i);
            if (st.isEmpty()) continue;
            this.pushOrDrop(st, tab);
        }
        this.onCraftingMatrixChanged();
    }

    public void transferToGrid(Player player, ItemStack[][] ingredients, @Nullable String tab) {
        this.clear(tab);
        for (int i = 0; i < 9; ++i) {
            ItemStack[] ingredient = ingredients[i];
            if (ingredient == null) continue;
            Map inv = this.itemCounts;
            ingredient = (ItemStack[])Arrays.stream(ingredient).filter(Objects::nonNull).sorted(Comparator.comparingLong(a -> inv.getOrDefault(((ItemStack)a).getItem(), 0L)).reversed()).toArray(ItemStack[]::new);
            ItemStack stack = ItemStack.EMPTY;
            for (ItemStack itemStack : ingredient) {
                ItemStack pulled = this.pullStack(itemStack, tab);
                if (pulled.isEmpty()) continue;
                stack = pulled;
                break;
            }
            if (stack.isEmpty()) {
                for (ItemStack itemStack : ingredient) {
                    boolean br = false;
                    Inventory playerInv = player.getInventory();
                    for (int k = 0; k < playerInv.getContainerSize(); ++k) {
                        if (!ItemStack.isSameItem((ItemStack)playerInv.getItem(k), (ItemStack)itemStack)) continue;
                        stack = playerInv.removeItem(k, 1);
                        br = true;
                        break;
                    }
                    if (br) break;
                }
            }
            if (stack.isEmpty()) continue;
            this.craftMatrix.setItem(i, stack);
        }
        this.onCraftingMatrixChanged();
    }

    private ItemStack pullStack(ItemStack itemStack, @Nullable String tab) {
        StoredItemStack is = this.pullStack(new StoredItemStack(itemStack), 1, tab);
        if (is == null) {
            return ItemStack.EMPTY;
        }
        return is.getActualStack();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "controller", 1, event -> {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("ledger_float"));
            return PlayState.CONTINUE;
        }));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.AnimatableInstanceCache;
    }
}

