/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.common.block.tile.PotionJarTile;
import com.hollingsworth.arsnouveau.common.block.tile.SourcelinkTile;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class AlchemicalSourcelinkTile
extends SourcelinkTile {
    public AlchemicalSourcelinkTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockRegistry.ALCHEMICAL_TILE.get(), pos, state);
    }

    @Override
    public int getMaxSource() {
        return 20000;
    }

    @Override
    public int getTransferRate() {
        return 10000;
    }

    @Override
    public void tick() {
        BlockEntity blockEntity;
        BlockPos potionPos;
        super.tick();
        if (this.level instanceof ServerLevel && this.level.getGameTime() % 20L == 0L && this.canAcceptSource() && (potionPos = AlchemicalSourcelinkTile.findNearbyPotion(this.level, this.worldPosition)) != null && (blockEntity = this.level.getBlockEntity(potionPos)) instanceof PotionJarTile) {
            PotionJarTile tile = (PotionJarTile)blockEntity;
            int source = 75;
            HashSet<MobEffect> effectTypes = new HashSet<MobEffect>();
            for (MobEffectInstance e : tile.getData().getAllEffects()) {
                source += e.getDuration() / 50;
                source += e.getAmplifier() * 250;
                source += 150;
                effectTypes.add((MobEffect)e.getEffect().value());
            }
            if (effectTypes.size() > 1) {
                source = (int)((double)source * Math.pow(2.1, effectTypes.size()));
            }
            if (source > 0 && this.canAcceptSource(source) || this.getSource() <= 0) {
                this.addSource(source);
                tile.remove(100);
            }
        }
    }

    @Nullable
    public static BlockPos findNearbyPotion(Level level, BlockPos worldPosition) {
        for (BlockPos p : BlockPos.withinManhattan((BlockPos)worldPosition.below(1), (int)1, (int)1, (int)1)) {
            PotionJarTile tile;
            BlockEntity blockEntity = level.getBlockEntity(p);
            if (!(blockEntity instanceof PotionJarTile) || (tile = (PotionJarTile)blockEntity).getAmount() < 100) continue;
            return p;
        }
        return null;
    }
}

