/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.hollingsworth.arsnouveau.api.recipe.MultiRecipeWrapper;
import com.hollingsworth.arsnouveau.common.block.SummonBlock;
import com.hollingsworth.arsnouveau.common.block.tile.SummoningTile;
import com.hollingsworth.arsnouveau.common.block.tile.WixieCauldronTile;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class WixieCauldron
extends SummonBlock {
    public static final BooleanProperty FILLED = BooleanProperty.create((String)"filled");

    public WixieCauldron() {
        super(WixieCauldron.defaultProperties().noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)SummoningTile.CONVERTED, (Comparable)Boolean.valueOf(false))).setValue((Property)FILLED, (Comparable)Boolean.valueOf(false)));
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (worldIn.isClientSide || handIn != InteractionHand.MAIN_HAND || !(worldIn.getBlockEntity(pos) instanceof WixieCauldronTile) || player.getMainHandItem().getItem() == ItemsRegistry.DOMINION_ROD.get()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (player.getMainHandItem().getItem() != ItemsRegistry.WIXIE_CHARM.get() && !player.getMainHandItem().isEmpty() && (blockEntity = worldIn.getBlockEntity(pos)) instanceof WixieCauldronTile) {
            WixieCauldronTile cauldronTile = (WixieCauldronTile)blockEntity;
            MultiRecipeWrapper wrapper = cauldronTile.getRecipesForStack(player.getMainHandItem());
            if (wrapper.isEmpty()) {
                PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_nouveau.wixie.no_recipe"));
            } else {
                cauldronTile.setSetStack(player.getMainHandItem().copy());
                PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_nouveau.wixie.recipe_set"));
            }
            return ItemInteractionResult.CONSUME;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FILLED});
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockEntity blockEntity;
        super.neighborChanged(state, world, pos, blockIn, fromPos, isMoving);
        if (!world.isClientSide() && (blockEntity = world.getBlockEntity(pos)) instanceof WixieCauldronTile) {
            WixieCauldronTile cauldronTile = (WixieCauldronTile)blockEntity;
            cauldronTile.isOff = world.hasNeighborSignal(pos);
            cauldronTile.updateBlock();
        }
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new WixieCauldronTile(pos, state);
    }
}

