/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.lib.EntityTags;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;
import org.jetbrains.annotations.Nullable;

public class SourceBerryBush
extends BushBlock
implements BonemealableBlock {
    public static final IntegerProperty AGE = BlockStateProperties.AGE_3;
    private static final VoxelShape BUSHLING_SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);
    private static final VoxelShape GROWING_SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    public static final MapCodec<SourceBerryBush> CODEC = SourceBerryBush.simpleCodec(SourceBerryBush::new);

    public SourceBerryBush(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<? extends BushBlock> codec() {
        return CODEC;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return new ItemStack(BlockRegistry.SOURCEBERRY_BUSH);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if ((Integer)state.getValue((Property)AGE) == 0) {
            return BUSHLING_SHAPE;
        }
        return (Integer)state.getValue((Property)AGE) < 3 ? GROWING_SHAPE : super.getShape(state, worldIn, pos, context);
    }

    public boolean isRandomlyTicking(BlockState state) {
        return (Integer)state.getValue((Property)AGE) < 3;
    }

    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        super.randomTick(state, worldIn, pos, random);
        int i = (Integer)state.getValue((Property)AGE);
        if (i < 3 && worldIn.getRawBrightness(pos.above(), 0) >= 9 && CommonHooks.canCropGrow((Level)worldIn, (BlockPos)pos, (BlockState)state, (random.nextInt(5) == 0 ? 1 : 0) != 0)) {
            worldIn.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
            CommonHooks.fireCropGrowPost((Level)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    public void entityInside(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof LivingEntity && !entityIn.getType().is(EntityTags.BERRY_BLACKLIST)) {
            entityIn.makeStuckInBlock(state, new Vec3((double)0.8f, 0.75, (double)0.8f));
            if (!(worldIn.isClientSide || (Integer)state.getValue((Property)AGE) <= 0 || entityIn.xOld == entityIn.getX() && entityIn.zOld == entityIn.getZ())) {
                double d0 = Math.abs(entityIn.getX() - entityIn.xOld);
                double d1 = Math.abs(entityIn.getZ() - entityIn.zOld);
                if (d0 >= (double)0.003f || d1 >= (double)0.003f) {
                    entityIn.hurt(worldIn.damageSources().sweetBerryBush(), 1.0f);
                }
            }
        }
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        boolean flag;
        int i = (Integer)state.getValue((Property)AGE);
        boolean bl = flag = i == 3;
        if (!flag && player.getItemInHand(handIn).is(Items.BONE_MEAL)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (i > 1) {
            int j = 1 + worldIn.random.nextInt(2);
            SourceBerryBush.popResource((Level)worldIn, (BlockPos)pos, (ItemStack)new ItemStack(BlockRegistry.SOURCEBERRY_BUSH, j + (flag ? 1 : 0)));
            worldIn.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + worldIn.random.nextFloat() * 0.4f);
            BlockState blockstate = (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(1));
            worldIn.setBlock(pos, blockstate, 3);
            return ItemInteractionResult.sidedSuccess((boolean)worldIn.isClientSide);
        }
        return super.useItemOn(stack, state, worldIn, pos, player, handIn, hit);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
    }

    public boolean isValidBonemealTarget(LevelReader pLevel, BlockPos pPos, BlockState pState) {
        return (Integer)pState.getValue((Property)AGE) < 3;
    }

    public boolean isBonemealSuccess(Level worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        int i = Math.min(3, (Integer)state.getValue((Property)AGE) + 1);
        worldIn.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(i)), 2);
    }

    @Nullable
    public PathType getBlockPathType(BlockState state, BlockGetter world, BlockPos pos, @Nullable Mob entity) {
        if (entity instanceof Starbuncle) {
            return PathType.WALKABLE;
        }
        return PathType.DAMAGE_OTHER;
    }
}

