/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.EntitySpellResolver;
import com.hollingsworth.arsnouveau.api.spell.ITurretBehavior;
import com.hollingsworth.arsnouveau.api.spell.SpellCaster;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.TileCaster;
import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.common.block.BasicSpellTurret;
import com.hollingsworth.arsnouveau.common.block.tile.RotatingTurretTile;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketOneShotAnimation;
import com.hollingsworth.arsnouveau.common.spell.method.MethodProjectile;
import com.hollingsworth.arsnouveau.common.spell.method.MethodTouch;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RotatingSpellTurret
extends BasicSpellTurret {
    public static HashMap<AbstractCastMethod, ITurretBehavior> ROT_TURRET_BEHAVIOR_MAP = new HashMap();

    @Override
    public void shootSpell(ServerLevel world, BlockPos pos) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (!(blockEntity instanceof RotatingTurretTile)) {
            return;
        }
        RotatingTurretTile tile = (RotatingTurretTile)blockEntity;
        SpellCaster caster = tile.spellCaster;
        if (caster.getSpell().isEmpty()) {
            return;
        }
        int manaCost = tile.getManaCost();
        if (manaCost > 0 && SourceUtil.takeSourceWithParticles(pos, (Level)world, 10, manaCost) == null) {
            return;
        }
        Networking.sendToNearbyClient((Level)world, pos, (CustomPacketPayload)new PacketOneShotAnimation(pos));
        Position iposition = RotatingSpellTurret.getDispensePosition(pos, tile);
        ANFakePlayer fakePlayer = ANFakePlayer.getPlayer(world);
        fakePlayer.setPos(pos.getX(), pos.getY(), pos.getZ());
        EntitySpellResolver resolver = new EntitySpellResolver(new SpellContext((Level)world, caster.getSpell(), (LivingEntity)fakePlayer, new TileCaster(tile, SpellContext.CasterType.TURRET)));
        if (resolver.castType != null && ROT_TURRET_BEHAVIOR_MAP.containsKey(resolver.castType)) {
            ROT_TURRET_BEHAVIOR_MAP.get(resolver.castType).onCast(resolver, world, pos, (Player)fakePlayer, iposition, RotatingSpellTurret.orderedByNearest(tile)[0].getOpposite());
            caster.playSound(pos, (Level)world, null, caster.getCurrentSound(), SoundSource.BLOCKS);
        }
    }

    public static Position getDispensePosition(BlockPos coords, RotatingTurretTile tile) {
        Vec3 direction = tile.getShootAngle().normalize();
        double d0 = (double)coords.getX() + 0.5 * direction.x();
        double d1 = (double)coords.getY() + 0.5 * direction.y();
        double d2 = (double)coords.getZ() + 0.5 * direction.z();
        return new Vec3(d0, d1, d2);
    }

    public static Direction[] orderedByNearest(RotatingTurretTile pEntity) {
        Direction direction2;
        float f = pEntity.getRotationY() * (float)Math.PI / 180.0f;
        float f1 = (90.0f + pEntity.getRotationX()) * (float)Math.PI / 180.0f;
        float f2 = Mth.sin((float)f);
        float f3 = Mth.cos((float)f);
        float f4 = Mth.sin((float)f1);
        float f5 = Mth.cos((float)f1);
        boolean flag = f4 > 0.0f;
        boolean flag1 = f2 < 0.0f;
        boolean flag2 = f5 > 0.0f;
        float f6 = flag ? f4 : -f4;
        float f7 = flag1 ? -f2 : f2;
        float f8 = flag2 ? f5 : -f5;
        float f9 = f6 * f3;
        float f10 = f8 * f3;
        Direction direction = flag ? Direction.EAST : Direction.WEST;
        Direction direction1 = flag1 ? Direction.UP : Direction.DOWN;
        Direction direction3 = direction2 = flag2 ? Direction.SOUTH : Direction.NORTH;
        if (f6 > f8) {
            if (f7 > f9) {
                return RotatingSpellTurret.makeDirectionArray(direction1, direction, direction2);
            }
            return f10 > f7 ? RotatingSpellTurret.makeDirectionArray(direction, direction2, direction1) : RotatingSpellTurret.makeDirectionArray(direction, direction1, direction2);
        }
        if (f7 > f10) {
            return RotatingSpellTurret.makeDirectionArray(direction1, direction2, direction);
        }
        return f9 > f7 ? RotatingSpellTurret.makeDirectionArray(direction2, direction, direction1) : RotatingSpellTurret.makeDirectionArray(direction2, direction1, direction);
    }

    static Direction[] makeDirectionArray(Direction pFirst, Direction pSecond, Direction pThird) {
        return new Direction[]{pFirst, pSecond, pThird, pThird.getOpposite(), pSecond.getOpposite(), pFirst.getOpposite()};
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        Direction orientation = placer == null ? Direction.WEST : Direction.orderedByNearest((Entity)placer)[0].getOpposite();
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (!(blockEntity instanceof RotatingTurretTile)) {
            return;
        }
        RotatingTurretTile turretTile = (RotatingTurretTile)blockEntity;
        switch (orientation) {
            case DOWN: {
                turretTile.rotationY = -90.0f;
                break;
            }
            case UP: {
                turretTile.rotationY = 90.0f;
                break;
            }
            case NORTH: {
                turretTile.rotationX = 270.0f;
                break;
            }
            case SOUTH: {
                turretTile.rotationX = 90.0f;
                break;
            }
            case WEST: {
                break;
            }
            case EAST: {
                turretTile.rotationX = 180.0f;
            }
        }
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new RotatingTurretTile(pos, state);
    }

    static {
        ROT_TURRET_BEHAVIOR_MAP.put(MethodProjectile.INSTANCE, new ITurretBehavior(){

            @Override
            public void onCast(SpellResolver resolver, ServerLevel world, BlockPos pos, Player fakePlayer, Position iposition, Direction direction) {
                BlockEntity blockEntity = world.getBlockEntity(pos);
                if (blockEntity instanceof RotatingTurretTile) {
                    RotatingTurretTile rotatingTurretTile = (RotatingTurretTile)blockEntity;
                    EntityProjectileSpell spell = new EntityProjectileSpell((Level)world, resolver);
                    spell.setOwner((Entity)fakePlayer);
                    spell.setPos(iposition.x(), iposition.y(), iposition.z());
                    Vec3 vec3d = rotatingTurretTile.getShootAngle().normalize();
                    spell.shoot(vec3d.x(), vec3d.y(), vec3d.z(), 0.5f, 0.0f);
                    world.addFreshEntity((Entity)spell);
                }
            }
        });
        ROT_TURRET_BEHAVIOR_MAP.put(MethodTouch.INSTANCE, new ITurretBehavior(){

            @Override
            public void onCast(SpellResolver resolver, ServerLevel serverLevel, BlockPos pos, Player fakePlayer, Position dispensePosition, Direction facingDir) {
                BlockPos touchPos = pos.relative(facingDir);
                BlockEntity blockEntity = serverLevel.getBlockEntity(pos);
                if (!(blockEntity instanceof RotatingTurretTile)) {
                    return;
                }
                RotatingTurretTile rotatingTurretTile = (RotatingTurretTile)blockEntity;
                Vec3 aimVec = rotatingTurretTile.getShootAngle().add(rotatingTurretTile.getX() + 0.5, rotatingTurretTile.getY() + 0.5, rotatingTurretTile.getZ() + 0.5);
                List entityList = serverLevel.getEntitiesOfClass(LivingEntity.class, new AABB(touchPos));
                if (!entityList.isEmpty()) {
                    LivingEntity entity = (LivingEntity)entityList.get(serverLevel.random.nextInt(entityList.size()));
                    resolver.onCastOnEntity(ItemStack.EMPTY, (Entity)entity, InteractionHand.MAIN_HAND);
                } else {
                    resolver.onCastOnBlock(new BlockHitResult(aimVec, facingDir, BlockPos.containing((double)aimVec.x(), (double)aimVec.y(), (double)aimVec.z()), true));
                }
            }
        });
    }
}

