/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.google.common.collect.ImmutableMap;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MagicFire
extends BaseFireBlock {
    public static final MapCodec<MagicFire> CODEC = MagicFire.simpleCodec(MagicFire::new);
    public static final int MAX_AGE = 7;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_7;
    public static final BooleanProperty NORTH = PipeBlock.NORTH;
    public static final BooleanProperty EAST = PipeBlock.EAST;
    public static final BooleanProperty SOUTH = PipeBlock.SOUTH;
    public static final BooleanProperty WEST = PipeBlock.WEST;
    public static final BooleanProperty UP = PipeBlock.UP;
    private static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = (Map)PipeBlock.PROPERTY_BY_DIRECTION.entrySet().stream().filter(p_53467_ -> p_53467_.getKey() != Direction.DOWN).collect(Util.toMap());
    private static final VoxelShape UP_AABB = Block.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_AABB = Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final VoxelShape SOUTH_AABB = Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private final Map<BlockState, VoxelShape> shapesCache;

    public MagicFire(BlockBehaviour.Properties pProperties) {
        this(pProperties, 1.0f);
    }

    public MagicFire(BlockBehaviour.Properties pProperties, float pFireDamage) {
        super(pProperties, pFireDamage);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)NORTH, (Comparable)Boolean.FALSE)).setValue((Property)EAST, (Comparable)Boolean.FALSE)).setValue((Property)SOUTH, (Comparable)Boolean.FALSE)).setValue((Property)WEST, (Comparable)Boolean.FALSE)).setValue((Property)UP, (Comparable)Boolean.FALSE));
        this.shapesCache = ImmutableMap.copyOf(this.stateDefinition.getPossibleStates().stream().filter(p_53497_ -> (Integer)p_53497_.getValue((Property)AGE) == 0).collect(Collectors.toMap(Function.identity(), MagicFire::calculateShape)));
    }

    protected MapCodec<? extends BaseFireBlock> codec() {
        return CODEC;
    }

    private static VoxelShape calculateShape(BlockState p_53491_) {
        VoxelShape voxelshape = Shapes.empty();
        if (((Boolean)p_53491_.getValue((Property)UP)).booleanValue()) {
            voxelshape = UP_AABB;
        }
        if (((Boolean)p_53491_.getValue((Property)NORTH)).booleanValue()) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)NORTH_AABB);
        }
        if (((Boolean)p_53491_.getValue((Property)SOUTH)).booleanValue()) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)SOUTH_AABB);
        }
        if (((Boolean)p_53491_.getValue((Property)EAST)).booleanValue()) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)EAST_AABB);
        }
        if (((Boolean)p_53491_.getValue((Property)WEST)).booleanValue()) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)WEST_AABB);
        }
        return voxelshape.isEmpty() ? DOWN_AABB : voxelshape;
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return this.canSurvive(pState, (LevelReader)pLevel, pCurrentPos) ? this.getStateWithAge(pLevel, pCurrentPos, (Integer)pState.getValue((Property)AGE)) : Blocks.AIR.defaultBlockState();
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.shapesCache.get(pState.setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected boolean canBurn(BlockState pState) {
        return false;
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return this.getStateForPlacement((BlockGetter)pContext.getLevel(), pContext.getClickedPos());
    }

    public BlockState getStateForPlacement(BlockGetter pLevel, BlockPos pPos) {
        BlockPos blockpos = pPos.below();
        BlockState blockstate = pLevel.getBlockState(blockpos);
        if (!this.canCatchFire(pLevel, pPos, Direction.UP) && !blockstate.isFaceSturdy(pLevel, blockpos, Direction.UP)) {
            BlockState blockstate1 = this.defaultBlockState();
            for (Direction direction : Direction.values()) {
                BooleanProperty booleanproperty = PROPERTY_BY_DIRECTION.get(direction);
                if (booleanproperty == null) continue;
                blockstate1 = (BlockState)blockstate1.setValue((Property)booleanproperty, (Comparable)Boolean.valueOf(this.canCatchFire(pLevel, pPos.relative(direction), direction.getOpposite())));
            }
            return blockstate1;
        }
        return this.defaultBlockState();
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockPos blockpos = pPos.below();
        return pLevel.getBlockState(blockpos).isFaceSturdy((BlockGetter)pLevel, blockpos, Direction.UP) || this.isValidFireLocation((BlockGetter)pLevel, pPos);
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        pLevel.scheduleTick(pPos, (Block)this, MagicFire.getFireTickDelay(pLevel.random));
        if (pLevel.getGameRules().getBoolean(GameRules.RULE_DOFIRETICK)) {
            BlockState blockstate = pLevel.getBlockState(pPos.below());
            boolean fireSourceBelow = blockstate.isFireSource((LevelReader)pLevel, pPos, Direction.UP);
            int age = (Integer)pState.getValue((Property)AGE);
            if (!fireSourceBelow && pLevel.isRaining() && this.isNearRain((Level)pLevel, pPos) && pRandom.nextFloat() < 0.2f + (float)age * 0.03f) {
                pLevel.removeBlock(pPos, false);
                pLevel.removeBlock(pPos, false);
            } else {
                int j = Math.min(7, age + pRandom.nextInt(3) / 2);
                if (age != j) {
                    pState = (BlockState)pState.setValue((Property)AGE, (Comparable)Integer.valueOf(j));
                    pLevel.setBlock(pPos, pState, 4);
                }
                if (!fireSourceBelow) {
                    if (!this.isValidFireLocation((BlockGetter)pLevel, pPos)) {
                        BlockPos blockpos = pPos.below();
                        if (!pLevel.getBlockState(blockpos).isFaceSturdy((BlockGetter)pLevel, blockpos, Direction.UP) || age > 3) {
                            pLevel.removeBlock(pPos, false);
                        }
                        return;
                    }
                    if (age == 7 && pRandom.nextInt(4) == 0 && !this.canCatchFire((BlockGetter)pLevel, pPos.below(), Direction.UP)) {
                        pLevel.removeBlock(pPos, false);
                        return;
                    }
                }
            }
        }
    }

    protected boolean isNearRain(Level pLevel, BlockPos pPos) {
        return pLevel.isRainingAt(pPos) || pLevel.isRainingAt(pPos.west()) || pLevel.isRainingAt(pPos.east()) || pLevel.isRainingAt(pPos.north()) || pLevel.isRainingAt(pPos.south());
    }

    private BlockState getStateWithAge(LevelAccessor pLevel, BlockPos pPos, int pAge) {
        BlockState blockstate = MagicFire.getState((BlockGetter)pLevel, pPos);
        return (BlockState)blockstate.setValue((Property)AGE, (Comparable)Integer.valueOf(pAge));
    }

    public static BlockState getState(BlockGetter pReader, BlockPos pPos) {
        return ((MagicFire)((Object)BlockRegistry.MAGIC_FIRE.get())).getStateForPlacement(pReader, pPos);
    }

    private boolean isValidFireLocation(BlockGetter pLevel, BlockPos pPos) {
        for (Direction direction : Direction.values()) {
            if (!this.canCatchFire(pLevel, pPos.relative(direction), direction.getOpposite())) continue;
            return true;
        }
        return false;
    }

    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        super.onPlace(pState, pLevel, pPos, pOldState, pIsMoving);
        pLevel.scheduleTick(pPos, (Block)this, MagicFire.getFireTickDelay(pLevel.random));
    }

    private static int getFireTickDelay(RandomSource pRandom) {
        return 30 + pRandom.nextInt(10);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{AGE, NORTH, EAST, SOUTH, WEST, UP});
    }

    public boolean canCatchFire(BlockGetter world, BlockPos pos, Direction face) {
        return world.getBlockState(pos).isFlammable(world, pos, face);
    }
}

