/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.hollingsworth.arsnouveau.common.block.SconceBlock;
import com.hollingsworth.arsnouveau.common.block.TickableModBlock;
import com.hollingsworth.arsnouveau.common.block.tile.MagelightTorchTile;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class MagelightTorch
extends TickableModBlock {
    public static final BooleanProperty FLOOR = BooleanProperty.create((String)"floor");
    public static final BooleanProperty ROOF = BooleanProperty.create((String)"roof");

    public MagelightTorch() {
        super(BlockBehaviour.Properties.of().sound(SoundType.STONE).strength(2.0f, 3.0f).noOcclusion().noCollission().lightLevel(b -> (Integer)b.getValue(SconceBlock.LIGHT_LEVEL)));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH)).setValue((Property)FLOOR, (Comparable)Boolean.valueOf(true))).setValue((Property)ROOF, (Comparable)Boolean.valueOf(false)));
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pLevel.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        BlockEntity tile = pLevel.getBlockEntity(pPos);
        if (tile instanceof MagelightTorchTile) {
            MagelightTorchTile torchTile;
            torchTile.setHorizontalFire(!(torchTile = (MagelightTorchTile)tile).isHorizontalFire());
        }
        return super.useItemOn(stack, pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction clickedDirection = context.getClickedFace();
        if (clickedDirection == Direction.UP) {
            return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)context.getNearestLookingDirection().getOpposite())).setValue((Property)FLOOR, (Comparable)Boolean.TRUE);
        }
        if (clickedDirection == Direction.DOWN) {
            Direction direction = context.getHorizontalDirection();
            if (direction == Direction.SOUTH) {
                direction = Direction.NORTH;
            }
            if (direction == Direction.WEST) {
                direction = Direction.EAST;
            }
            if (direction == Direction.DOWN) {
                direction = Direction.EAST;
            }
            return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)direction)).setValue((Property)ROOF, (Comparable)Boolean.TRUE)).setValue((Property)FLOOR, (Comparable)Boolean.valueOf(false));
        }
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)clickedDirection)).setValue((Property)FLOOR, (Comparable)Boolean.valueOf(false))).setValue((Property)ROOF, (Comparable)Boolean.valueOf(false));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.FACING}).add(new Property[]{SconceBlock.LIGHT_LEVEL}).add(new Property[]{FLOOR}).add(new Property[]{ROOF});
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)BlockStateProperties.FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)BlockStateProperties.FACING)));
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new MagelightTorchTile(pPos, pState);
    }
}

