/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.hollingsworth.arsnouveau.common.block.tile.ArchwoodChestTile;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;

public class ArchwoodChest
extends ChestBlock {
    public ArchwoodChest() {
        super(BlockBehaviour.Properties.of().strength(2.5f).sound(SoundType.WOOD), () -> (BlockEntityType)BlockRegistry.ARCHWOOD_CHEST_TILE.get());
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ArchwoodChestTile(pos, state);
    }

    public static class Item
    extends BlockItem {
        public Item(Block block, Item.Properties props) {
            super(block, props);
        }

        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            super.initializeClient(consumer);
            consumer.accept(new IClientItemExtensions(){

                public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                    final Minecraft mc = Minecraft.getInstance();
                    return new BlockEntityWithoutLevelRenderer(mc.getBlockEntityRenderDispatcher(), mc.getEntityModels()){
                        private final BlockEntity tile;
                        {
                            super(arg0, arg1);
                            this.tile = new ArchwoodChestTile(BlockPos.ZERO, this.getBlock().defaultBlockState());
                        }

                        public void renderByItem(ItemStack stack, ItemDisplayContext transformType, PoseStack pose, MultiBufferSource buffer, int x, int y) {
                            mc.getBlockEntityRenderDispatcher().renderItem(this.tile, pose, buffer, x, y);
                        }
                    };
                }
            });
        }
    }
}

