/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.hollingsworth.arsnouveau.common.block.ModBlock;
import com.hollingsworth.arsnouveau.common.block.tile.ArcanePedestalTile;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class ArcanePedestal
extends ModBlock
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final VoxelShape shape = Stream.of(Block.box((double)2.0, (double)11.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0), Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)3.0, (double)11.0), Block.box((double)5.0, (double)8.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0), Block.box((double)6.0, (double)3.0, (double)6.0, (double)10.0, (double)8.0, (double)10.0), Stream.of(Block.box((double)7.0, (double)8.0, (double)1.0, (double)9.0, (double)11.0, (double)5.0), Block.box((double)7.0, (double)3.0, (double)3.0, (double)9.0, (double)8.0, (double)5.0), Block.box((double)7.0, (double)0.0, (double)1.0, (double)9.0, (double)3.0, (double)5.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Stream.of(Block.box((double)1.0, (double)8.0, (double)7.0, (double)5.0, (double)11.0, (double)9.0), Block.box((double)3.0, (double)3.0, (double)7.0, (double)5.0, (double)8.0, (double)9.0), Block.box((double)1.0, (double)0.0, (double)7.0, (double)5.0, (double)3.0, (double)9.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Stream.of(Block.box((double)7.0, (double)8.0, (double)11.0, (double)9.0, (double)11.0, (double)15.0), Block.box((double)7.0, (double)3.0, (double)11.0, (double)9.0, (double)8.0, (double)13.0), Block.box((double)7.0, (double)0.0, (double)11.0, (double)9.0, (double)3.0, (double)15.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Stream.of(Block.box((double)11.0, (double)8.0, (double)7.0, (double)15.0, (double)11.0, (double)9.0), Block.box((double)11.0, (double)3.0, (double)7.0, (double)13.0, (double)8.0, (double)9.0), Block.box((double)11.0, (double)0.0, (double)7.0, (double)15.0, (double)3.0, (double)9.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get()).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();

    public ArcanePedestal() {
        super(ModBlock.defaultProperties().noOcclusion().forceSolidOn());
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public ItemInteractionResult useItemOn(ItemStack pStack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (handIn != InteractionHand.MAIN_HAND) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!world.isClientSide && (blockEntity = world.getBlockEntity(pos)) instanceof ArcanePedestalTile) {
            ArcanePedestalTile tile = (ArcanePedestalTile)blockEntity;
            if (tile.getStack() != null && player.getItemInHand(handIn).isEmpty()) {
                item = new ItemEntity(world, player.getX(), player.getY(), player.getZ(), tile.getStack());
                world.addFreshEntity((Entity)item);
                tile.setStack(ItemStack.EMPTY);
            } else if (!player.getInventory().getSelected().isEmpty()) {
                if (tile.getStack() != null) {
                    item = new ItemEntity(world, player.getX(), player.getY(), player.getZ(), tile.getStack());
                    world.addFreshEntity((Entity)item);
                }
                tile.setStack(player.getInventory().removeItem(player.getInventory().selected, 1));
            }
            world.sendBlockUpdated(pos, state, state, 2);
        }
        return ItemInteractionResult.SUCCESS;
    }

    public BlockState playerWillDestroy(Level worldIn, BlockPos pos, BlockState state, Player player) {
        ArcanePedestalTile tile;
        super.playerWillDestroy(worldIn, pos, state, player);
        BlockEntity blockEntity = worldIn.getBlockEntity(pos);
        if (blockEntity instanceof ArcanePedestalTile && (tile = (ArcanePedestalTile)blockEntity).getStack() != null) {
            worldIn.addFreshEntity((Entity)new ItemEntity(worldIn, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), tile.getStack()));
        }
        return state;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return shape;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ArcanePedestalTile(pos, state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.WATERLOGGED});
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : Fluids.EMPTY.defaultFluidState();
    }

    @NotNull
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
    }

    public BlockState updateShape(BlockState stateIn, Direction side, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        return stateIn;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level worldIn, BlockPos pos) {
        ArcanePedestalTile tile = (ArcanePedestalTile)worldIn.getBlockEntity(pos);
        if (tile == null || tile.getStack().isEmpty()) {
            return 0;
        }
        return 15;
    }

    public void neighborChanged(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        BlockEntity blockEntity;
        super.neighborChanged(pState, pLevel, pPos, pBlock, pFromPos, pIsMoving);
        if (!pLevel.isClientSide && (blockEntity = pLevel.getBlockEntity(pPos)) instanceof ArcanePedestalTile) {
            ArcanePedestalTile tile = (ArcanePedestalTile)blockEntity;
            if (tile.hasSignal != pLevel.hasNeighborSignal(pPos)) {
                tile.hasSignal = !tile.hasSignal;
                tile.updateBlock();
            }
        }
    }

    protected boolean isPathfindable(BlockState pState, PathComputationType pPathComputationType) {
        return false;
    }
}

