/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.item;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.registry.SpellCasterRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractCaster;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.renderer.item.FixedGeoItemRenderer;
import com.hollingsworth.arsnouveau.common.items.ScryCaster;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.util.Color;

public class ScryCasterRenderer
extends FixedGeoItemRenderer<ScryCaster> {
    public ScryCasterRenderer() {
        super((GeoModel)new GeoModel<ScryCaster>(){

            public ResourceLocation getModelResource(ScryCaster wand) {
                return ArsNouveau.prefix("geo/enchanters_eye.geo.json");
            }

            public ResourceLocation getTextureResource(ScryCaster wand) {
                return ArsNouveau.prefix("textures/item/enchanters_eye.png");
            }

            public ResourceLocation getAnimationResource(ScryCaster wand) {
                return ArsNouveau.prefix("animations/enchanters_eye.json");
            }
        });
    }

    public void renderRecursively(PoseStack poseStack, ScryCaster animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int packedColor) {
        if (bone.getName().equals("eye")) {
            super.renderRecursively(poseStack, (Item)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, packedColor);
        } else {
            super.renderRecursively(poseStack, (Item)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, Color.WHITE.argbInt());
        }
    }

    public Color getRenderColor(ScryCaster animatable, float partialTick, int packedLight) {
        ParticleColor color = ParticleColor.defaultParticleColor();
        AbstractCaster<?> caster = SpellCasterRegistry.from(this.currentItemStack);
        if (caster != null) {
            color = caster.getColor();
        }
        return Color.ofRGBA((float)color.getRed(), (float)color.getGreen(), (float)color.getBlue(), (float)0.85f).brighter((double)1.2f);
    }

    public RenderType getRenderType(ScryCaster animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return RenderType.entityTranslucent((ResourceLocation)texture);
    }
}

