/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.entity.familiar;

import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleSparkleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.client.renderer.entity.WhirlisprigModel;
import com.hollingsworth.arsnouveau.client.renderer.entity.familiar.GenericFamiliarRenderer;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarWhirlisprig;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.cache.object.GeoBone;

public class FamiliarWhirlisprigRenderer<T extends FamiliarWhirlisprig>
extends GenericFamiliarRenderer<T> {
    public FamiliarWhirlisprigRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, new WhirlisprigModel());
    }

    public void render(T entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        super.render(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        if (Minecraft.getInstance().isPaused()) {
            return;
        }
        Level world = entityIn.getCommandSenderWorld();
        Random rand = ParticleUtil.r;
        Vec3 particlePos = entityIn.position();
        GeoBone sylph = (GeoBone)this.getGeoModel().getBone("sylph").get();
        GeoBone propellers = (GeoBone)this.getGeoModel().getBone("propellers").get();
        float offsetY = sylph.getPosY() / 9.0f;
        float roteAngle = propellers.getRotY() / 4.0f;
        if (rand.nextInt(5) == 0) {
            for (int i = 0; i < 5; ++i) {
                world.addParticle(ParticleSparkleData.createData(new ParticleColor(52, 255, 36), 0.05f, 60), particlePos.x() + Math.cos(roteAngle) / 2.0, particlePos.y() + 0.5 + (double)offsetY, particlePos.z() + Math.sin(roteAngle) / 2.0, 0.0, 0.0, 0.0);
            }
        }
    }
}

