/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.keybindings;

import com.hollingsworth.arsnouveau.api.item.IRadialProvider;
import com.hollingsworth.arsnouveau.api.item.ISpellHotkeyListener;
import com.hollingsworth.arsnouveau.api.util.CuriosUtil;
import com.hollingsworth.arsnouveau.api.util.StackUtil;
import com.hollingsworth.arsnouveau.client.gui.book.GuiSpellBook;
import com.hollingsworth.arsnouveau.client.gui.radial_menu.GuiRadialMenu;
import com.hollingsworth.arsnouveau.client.registry.ModKeyBindings;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketGenericClientMessage;
import com.hollingsworth.arsnouveau.common.network.PacketHotkeyPressed;
import com.hollingsworth.arsnouveau.common.network.PacketQuickCast;
import com.hollingsworth.arsnouveau.common.network.PacketToggleFamiliar;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;

@EventBusSubscriber(value={Dist.CLIENT}, modid="ars_nouveau")
public class KeyHandler {
    private static final Minecraft MINECRAFT = Minecraft.getInstance();
    public static KeyMapping[] CURIO_MAPPINGS = new KeyMapping[]{ModKeyBindings.HEAD_CURIO_HOTKEY};

    public static void checkKeysPressed(int key) {
        KeyHandler.checkCurioHotkey(key);
        if (key == ModKeyBindings.FAMILIAR_TOGGLE.getKey().getValue() && !ModKeyBindings.FAMILIAR_TOGGLE.isUnbound()) {
            Networking.sendToServer(new PacketToggleFamiliar());
        }
        if (key == ModKeyBindings.OPEN_RADIAL_HUD.getKey().getValue() && !ModKeyBindings.OPEN_RADIAL_HUD.isUnbound() && KeyHandler.MINECRAFT.screen instanceof GuiRadialMenu) {
            KeyHandler.MINECRAFT.player.closeContainer();
            return;
        }
        KeyHandler.checkCasterKeys(key);
    }

    public static void checkCasterKeys(int key) {
        int slot;
        InteractionHand hand;
        if (key == -1) {
            return;
        }
        LocalPlayer player = KeyHandler.MINECRAFT.player;
        ItemStack radialStack = StackUtil.getHeldRadial((Player)player);
        Item item = radialStack.getItem();
        if (item instanceof IRadialProvider) {
            IRadialProvider radialProvider = (IRadialProvider)item;
            if (key == ((IRadialProvider)radialStack.getItem()).forKey()) {
                if (KeyHandler.MINECRAFT.screen == null) {
                    radialProvider.onRadialKeyPressed(radialStack, (Player)player);
                    return;
                }
                if (KeyHandler.MINECRAFT.screen instanceof GuiRadialMenu) {
                    KeyHandler.MINECRAFT.player.closeContainer();
                    return;
                }
            }
        }
        if ((hand = StackUtil.getHeldCasterTool((Player)player)) == null) {
            return;
        }
        ItemStack stack = player.getItemInHand(hand);
        if (stack.isEmpty()) {
            return;
        }
        Item item2 = stack.getItem();
        if (!(item2 instanceof ISpellHotkeyListener)) {
            return;
        }
        ISpellHotkeyListener hotkeyListener = (ISpellHotkeyListener)item2;
        if (key == ModKeyBindings.NEXT_SLOT.getKey().getValue()) {
            KeyHandler.sendHotkeyPacket(PacketHotkeyPressed.Key.NEXT);
            return;
        }
        if (key == ModKeyBindings.PREVIOUS_SLOT.getKey().getValue()) {
            KeyHandler.sendHotkeyPacket(PacketHotkeyPressed.Key.PREVIOUS);
            return;
        }
        if (key == ModKeyBindings.OPEN_BOOK.getKey().getValue()) {
            if (KeyHandler.MINECRAFT.screen instanceof GuiSpellBook && !((GuiSpellBook)KeyHandler.MINECRAFT.screen).spell_name.isFocused()) {
                KeyHandler.MINECRAFT.player.closeContainer();
                return;
            }
            if (KeyHandler.MINECRAFT.screen == null) {
                ItemStack spellbook = StackUtil.getHeldSpellbook((Player)player);
                if (!spellbook.isEmpty()) {
                    hotkeyListener.onOpenBookMenuKeyPressed(spellbook, (Player)player);
                } else {
                    Item item3 = stack.getItem();
                    if (item3 instanceof ISpellHotkeyListener) {
                        ISpellHotkeyListener listener = (ISpellHotkeyListener)item3;
                        listener.onOpenBookMenuKeyPressed(stack, (Player)player);
                    } else {
                        InteractionHand otherHand = hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
                        ItemStack otherStack = player.getItemInHand(otherHand);
                        Item item4 = otherStack.getItem();
                        if (item4 instanceof ISpellHotkeyListener) {
                            ISpellHotkeyListener offhandListener = (ISpellHotkeyListener)item4;
                            offhandListener.onOpenBookMenuKeyPressed(otherStack, (Player)player);
                        }
                    }
                }
            }
        }
        if ((slot = ModKeyBindings.usedQuickSlot(key)) != -1) {
            Networking.sendToServer(new PacketQuickCast(slot));
        }
    }

    public static void checkCurioHotkey(int keyMapping) {
    }

    @SubscribeEvent
    public static void mouseEvent(InputEvent.MouseButton.Post event) {
        if (KeyHandler.MINECRAFT.player == null || event.getAction() != 1) {
            return;
        }
        if (KeyHandler.MINECRAFT.screen == null || KeyHandler.MINECRAFT.screen instanceof GuiRadialMenu) {
            KeyHandler.checkKeysPressed(event.getButton());
        }
    }

    @SubscribeEvent
    public static void keyEvent(InputEvent.Key event) {
        if (KeyHandler.MINECRAFT.player == null || event.getAction() != 1) {
            return;
        }
        if (KeyHandler.MINECRAFT.screen == null || KeyHandler.MINECRAFT.screen instanceof GuiRadialMenu) {
            KeyHandler.checkKeysPressed(event.getKey());
        }
        if (event.getKey() == Minecraft.getInstance().options.keyJump.getKey().getValue() && Minecraft.getInstance().player != null && !Minecraft.getInstance().player.onGround() && CuriosUtil.hasItem((LivingEntity)Minecraft.getInstance().player, (Item)ItemsRegistry.JUMP_RING.get()) && Minecraft.getInstance().screen == null) {
            Networking.sendToServer(new PacketGenericClientMessage(PacketGenericClientMessage.Action.JUMP_RING));
        }
    }

    public static void sendHotkeyPacket(PacketHotkeyPressed.Key key) {
        Networking.sendToServer(new PacketHotkeyPressed(key));
    }
}

