/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.jei;

import com.hollingsworth.arsnouveau.client.jei.JEIArsNouveauPlugin;
import com.hollingsworth.arsnouveau.client.jei.MultiInputCategory;
import com.hollingsworth.arsnouveau.common.crafting.recipes.EnchantingApparatusRecipe;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class EnchantingApparatusRecipeCategory<T extends EnchantingApparatusRecipe>
extends MultiInputCategory<T> {
    public IDrawable background;
    public IDrawable icon;

    public EnchantingApparatusRecipeCategory(IGuiHelper helper) {
        super(helper, enchantingApparatusRecipe -> new MultiInputCategory.MultiProvider(enchantingApparatusRecipe.result(), enchantingApparatusRecipe.pedestalItems(), enchantingApparatusRecipe.reagent()));
        this.background = helper.createBlankDrawable(114, 108);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack(BlockRegistry.ENCHANTING_APP_BLOCK));
    }

    public RecipeType<T> getRecipeType() {
        return JEIArsNouveauPlugin.ENCHANTING_APP_RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"ars_nouveau.enchanting_apparatus");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(EnchantingApparatusRecipe recipe, @NotNull IRecipeSlotsView slotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Font renderer = Minecraft.getInstance().font;
        if (recipe.consumesSource()) {
            guiGraphics.drawString(renderer, (Component)Component.translatable((String)"ars_nouveau.source", (Object[])new Object[]{recipe.sourceCost()}), 0, 100, 10, false);
        }
    }
}

