/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui.book;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.registry.FamiliarRegistry;
import com.hollingsworth.arsnouveau.api.registry.GlyphRegistry;
import com.hollingsworth.arsnouveau.api.registry.SpellCasterRegistry;
import com.hollingsworth.arsnouveau.api.sound.ConfiguredSpellSound;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractCaster;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.ISpellValidator;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellValidationError;
import com.hollingsworth.arsnouveau.api.util.ManaUtil;
import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.client.gui.Color;
import com.hollingsworth.arsnouveau.client.gui.GuiUtils;
import com.hollingsworth.arsnouveau.client.gui.NoShadowTextField;
import com.hollingsworth.arsnouveau.client.gui.book.BaseBook;
import com.hollingsworth.arsnouveau.client.gui.book.GuiColorScreen;
import com.hollingsworth.arsnouveau.client.gui.book.GuiFamiliarScreen;
import com.hollingsworth.arsnouveau.client.gui.book.GuiSettingsScreen;
import com.hollingsworth.arsnouveau.client.gui.book.SoundScreen;
import com.hollingsworth.arsnouveau.client.gui.buttons.CraftingButton;
import com.hollingsworth.arsnouveau.client.gui.buttons.CreateSpellButton;
import com.hollingsworth.arsnouveau.client.gui.buttons.GlyphButton;
import com.hollingsworth.arsnouveau.client.gui.buttons.GuiImageButton;
import com.hollingsworth.arsnouveau.client.gui.buttons.GuiSpellSlot;
import com.hollingsworth.arsnouveau.client.gui.utils.RenderUtils;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.capability.ANPlayerDataCap;
import com.hollingsworth.arsnouveau.common.compat.PatchouliHandler;
import com.hollingsworth.arsnouveau.common.items.SpellBook;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketUpdateCaster;
import com.hollingsworth.arsnouveau.common.spell.validation.CombinedSpellValidator;
import com.hollingsworth.arsnouveau.common.spell.validation.GlyphMaxTierValidator;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import com.hollingsworth.arsnouveau.setup.registry.CreativeTabRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class GuiSpellBook
extends BaseBook {
    public int numLinks = 10;
    public int selectedSpellSlot = 0;
    public EditBox spell_name;
    public NoShadowTextField searchBar;
    public GuiSpellSlot selected_slot;
    public List<CraftingButton> craftingCells = new ArrayList<CraftingButton>();
    public List<AbstractSpellPart> unlockedSpells;
    public List<AbstractSpellPart> displayedGlyphs;
    public List<GlyphButton> glyphButtons = new ArrayList<GlyphButton>();
    public int page = 0;
    public PageButton nextButton;
    public PageButton previousButton;
    public ISpellValidator spellValidator;
    public String previousString = "";
    public ItemStack bookStack;
    public int formTextRow = 0;
    public int augmentTextRow = 0;
    public int effectTextRow = 0;
    public int glyphsPerPage = 58;
    public InteractionHand hand;
    public int maxManaCache = 0;
    int currentCostCache = 0;
    public CreateSpellButton createSpellButton;
    public boolean setFocusOnLoad = true;
    public Renderable hoveredWidget = null;

    public GuiSpellBook(InteractionHand hand) {
        this.hand = hand;
        ANPlayerDataCap cap = CapabilityRegistry.getPlayerDataCap((LivingEntity)Minecraft.getInstance().player);
        ItemStack heldStack = Minecraft.getInstance().player.getItemInHand(hand);
        ArrayList<AbstractSpellPart> parts = cap == null ? new ArrayList<AbstractSpellPart>() : new ArrayList<AbstractSpellPart>(cap.getKnownGlyphs().stream().filter(AbstractSpellPart::shouldShowInSpellBook).toList());
        this.maxManaCache = ManaUtil.getMaxMana((Player)Minecraft.getInstance().player);
        parts.addAll(GlyphRegistry.getDefaultStartingSpells());
        if (heldStack.getItem() == ItemsRegistry.CREATIVE_SPELLBOOK.get()) {
            parts = new ArrayList<AbstractSpellPart>(GlyphRegistry.getSpellpartMap().values().stream().filter(AbstractSpellPart::shouldShowInSpellBook).toList());
        }
        int tier = 1;
        Item item = heldStack.getItem();
        if (item instanceof SpellBook) {
            SpellBook book = (SpellBook)item;
            tier = book.getTier().value;
        }
        this.bookStack = heldStack;
        this.unlockedSpells = parts;
        this.displayedGlyphs = new ArrayList<AbstractSpellPart>(this.unlockedSpells);
        this.validationErrors = new LinkedList();
        this.spellValidator = new CombinedSpellValidator(ArsNouveauAPI.getInstance().getSpellCraftingSpellValidator(), new GlyphMaxTierValidator(tier));
    }

    @Override
    public void init() {
        int i;
        super.init();
        AbstractCaster<?> caster = SpellCasterRegistry.from(this.bookStack);
        int selectedSlot = caster.getCurrentSlot();
        for (i = 0; i < this.numLinks; ++i) {
            int offset = i >= 5 ? 14 : 0;
            CraftingButton cell = new CraftingButton(this.bookLeft + 19 + 24 * i + offset, this.bookTop + 194 - 47, this::onCraftingSlotClick);
            this.addRenderableWidget((GuiEventListener)cell);
            this.craftingCells.add(cell);
        }
        this.updateCraftingSlots(selectedSlot);
        this.layoutAllGlyphs(0);
        this.createSpellButton = (CreateSpellButton)this.addRenderableWidget((GuiEventListener)new CreateSpellButton(this.bookRight - 71, this.bookBottom - 13, this::onCreateClick, () -> !this.validationErrors.isEmpty()));
        this.addRenderableWidget((GuiEventListener)new GuiImageButton(this.bookRight - 126, this.bookBottom - 13, 0, 0, 41, 12, 41, 12, "textures/gui/clear_icon.png", this::clear));
        this.spell_name = new NoShadowTextField(this.minecraft.font, this.bookLeft + 32, this.bookTop + 194 - 11, 88, 12, null, (Component)Component.translatable((String)"ars_nouveau.spell_book_gui.spell_name"));
        this.spell_name.setBordered(false);
        this.spell_name.setTextColor(12694931);
        this.searchBar = new NoShadowTextField(this.minecraft.font, this.bookRight - 73, this.bookTop + 2, 54, 12, null, (Component)Component.translatable((String)"ars_nouveau.spell_book_gui.search"));
        this.searchBar.setBordered(false);
        this.searchBar.setTextColor(12694931);
        this.searchBar.onClear = val -> {
            this.onSearchChanged("");
            return null;
        };
        this.spell_name.setValue(caster.getSpellName(caster.getCurrentSlot()));
        if (this.spell_name.getValue().isEmpty()) {
            this.spell_name.setSuggestion(Component.translatable((String)"ars_nouveau.spell_book_gui.spell_name").getString());
        }
        if (this.searchBar.getValue().isEmpty()) {
            this.searchBar.setSuggestion(Component.translatable((String)"ars_nouveau.spell_book_gui.search").getString());
        }
        this.searchBar.setResponder(this::onSearchChanged);
        this.addRenderableWidget((GuiEventListener)this.spell_name);
        this.addRenderableWidget((GuiEventListener)this.searchBar);
        for (i = 0; i < 10; ++i) {
            String name = caster.getSpellName(i);
            GuiSpellSlot slot = new GuiSpellSlot(this.bookLeft + 281, this.bookTop + 1 + 15 * (i + 1), i, name, this::onSlotChange);
            if (i == selectedSlot) {
                this.selected_slot = slot;
                this.selectedSpellSlot = i;
                slot.isSelected = true;
            }
            this.addRenderableWidget((GuiEventListener)slot);
        }
        this.addRenderableWidget((GuiEventListener)new GuiImageButton(this.bookLeft - 15, this.bookTop + 22, 0, 0, 23, 20, 23, 20, "textures/gui/worn_book_bookmark.png", this::onDocumentationClick).withTooltip((Component)Component.translatable((String)"ars_nouveau.gui.notebook")));
        this.addRenderableWidget((GuiEventListener)new GuiImageButton(this.bookLeft - 15, this.bookTop + 46, 0, 0, 23, 20, 23, 20, "textures/gui/color_wheel_bookmark.png", this::onColorClick).withTooltip((Component)Component.translatable((String)"ars_nouveau.gui.color")));
        this.addRenderableWidget((GuiEventListener)new GuiImageButton(this.bookLeft - 15, this.bookTop + 70, 0, 0, 23, 20, 23, 20, "textures/gui/summon_circle_bookmark.png", this::onFamiliarClick).withTooltip((Component)Component.translatable((String)"ars_nouveau.gui.familiar")));
        this.addRenderableWidget((GuiEventListener)new GuiImageButton(this.bookLeft - 15, this.bookTop + 94, 0, 0, 23, 20, 23, 20, "textures/gui/sounds_tab.png", this::onSoundsClick).withTooltip((Component)Component.translatable((String)"ars_nouveau.gui.sounds")));
        this.addRenderableWidget((GuiEventListener)new GuiImageButton(this.bookLeft - 15, this.bookTop + 118, 0, 0, 23, 20, 23, 20, "textures/gui/settings_tab.png", b -> Minecraft.getInstance().setScreen((Screen)new GuiSettingsScreen(this))).withTooltip((Component)Component.translatable((String)"ars_nouveau.gui.settings")));
        this.addRenderableWidget((GuiEventListener)new GuiImageButton(this.bookLeft - 15, this.bookTop + 142, 0, 0, 23, 20, 23, 20, "textures/gui/discord_tab.png", b -> {
            try {
                Util.getPlatform().openUri(new URI("https://discord.com/invite/y7TMXZu"));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }).withTooltip((Component)Component.translatable((String)"ars_nouveau.gui.discord")));
        this.nextButton = (PageButton)this.addRenderableWidget((GuiEventListener)new PageButton(this.bookRight - 20, this.bookBottom - 10, true, this::onPageIncrease, true));
        this.previousButton = (PageButton)this.addRenderableWidget((GuiEventListener)new PageButton(this.bookLeft - 5, this.bookBottom - 10, false, this::onPageDec, true));
        this.updateNextPageButtons();
        this.previousButton.active = false;
        this.previousButton.visible = false;
        this.validate();
    }

    public int getNumPages() {
        return (int)Math.ceil((double)this.displayedGlyphs.size() / 58.0);
    }

    private void layoutAllGlyphs(int page) {
        this.clearButtons(this.glyphButtons);
        this.formTextRow = 0;
        this.augmentTextRow = 0;
        this.effectTextRow = 0;
        int PER_ROW = 6;
        int MAX_ROWS = 6;
        boolean nextPage = false;
        int xStart = nextPage ? this.bookLeft + 154 : this.bookLeft + 20;
        int adjustedRowsPlaced = 0;
        int yStart = this.bookTop + 20;
        boolean foundForms = false;
        boolean foundAugments = false;
        boolean foundEffects = false;
        List sorted = new ArrayList<AbstractSpellPart>();
        sorted.addAll(this.displayedGlyphs.stream().filter(s -> s instanceof AbstractCastMethod).toList());
        sorted.addAll(this.displayedGlyphs.stream().filter(s -> s instanceof AbstractAugment).toList());
        sorted.addAll(this.displayedGlyphs.stream().filter(s -> s instanceof AbstractEffect).toList());
        sorted.sort(CreativeTabRegistry.COMPARE_SPELL_TYPE_NAME);
        sorted = sorted.subList(this.glyphsPerPage * page, Math.min(sorted.size(), this.glyphsPerPage * (page + 1)));
        int adjustedXPlaced = 0;
        int totalRowsPlaced = 0;
        int row_offset = page == 0 ? 2 : 0;
        for (int i = 0; i < sorted.size(); ++i) {
            AbstractSpellPart part = (AbstractSpellPart)sorted.get(i);
            if (!foundForms && part instanceof AbstractCastMethod) {
                foundForms = true;
                ++adjustedRowsPlaced;
                this.formTextRow = page != 0 ? 0 : ++totalRowsPlaced;
                adjustedXPlaced = 0;
            }
            if (!foundAugments && part instanceof AbstractAugment) {
                foundAugments = true;
                adjustedRowsPlaced += row_offset;
                this.augmentTextRow = page != 0 ? 0 : (totalRowsPlaced += row_offset) - 1;
                adjustedXPlaced = 0;
            } else if (!foundEffects && part instanceof AbstractEffect) {
                foundEffects = true;
                adjustedRowsPlaced += row_offset;
                this.effectTextRow = page != 0 ? 0 : (totalRowsPlaced += row_offset) - 1;
                adjustedXPlaced = 0;
            } else if (adjustedXPlaced >= 6) {
                ++adjustedRowsPlaced;
                ++totalRowsPlaced;
                adjustedXPlaced = 0;
            }
            if (adjustedRowsPlaced > 6) {
                if (nextPage) break;
                nextPage = true;
                adjustedXPlaced = 0;
                adjustedRowsPlaced = 0;
            }
            int xOffset = 20 * (adjustedXPlaced % 6) + (nextPage ? 134 : 0);
            int yPlace = adjustedRowsPlaced * 18 + yStart;
            GlyphButton cell = new GlyphButton(xStart + xOffset, yPlace, part, this::onGlyphClick);
            this.addRenderableWidget((GuiEventListener)cell);
            this.glyphButtons.add(cell);
            ++adjustedXPlaced;
        }
    }

    public void resetPageState() {
        this.updateNextPageButtons();
        this.page = 0;
        this.previousButton.active = false;
        this.previousButton.visible = false;
        this.layoutAllGlyphs(this.page);
        this.validate();
    }

    public void onSearchChanged(String str) {
        if (str.equals(this.previousString)) {
            return;
        }
        this.previousString = str;
        if (!str.isEmpty()) {
            this.searchBar.setSuggestion("");
            this.displayedGlyphs = new ArrayList<AbstractSpellPart>();
            for (AbstractSpellPart spellPart : this.unlockedSpells) {
                if (!spellPart.getLocaleName().toLowerCase().contains(str.toLowerCase())) continue;
                this.displayedGlyphs.add(spellPart);
            }
            for (Renderable w : this.renderables) {
                AbstractSpellPart part;
                if (!(w instanceof GlyphButton)) continue;
                GlyphButton glyphButton = (GlyphButton)w;
                if (glyphButton.abstractSpellPart.getRegistryName() == null || (part = GlyphRegistry.getSpellpartMap().get(glyphButton.abstractSpellPart.getRegistryName())) == null) continue;
                glyphButton.visible = part.getLocaleName().toLowerCase().contains(str.toLowerCase());
            }
        } else {
            this.searchBar.setSuggestion(Component.translatable((String)"ars_nouveau.spell_book_gui.search").getString());
            this.displayedGlyphs = this.unlockedSpells;
            for (Renderable w : this.renderables) {
                if (!(w instanceof GlyphButton)) continue;
                ((GlyphButton)w).visible = true;
            }
        }
        this.resetPageState();
    }

    public void updateNextPageButtons() {
        if (this.displayedGlyphs.size() < this.glyphsPerPage) {
            this.nextButton.visible = false;
            this.nextButton.active = false;
        } else {
            this.nextButton.visible = true;
            this.nextButton.active = true;
        }
    }

    public void onPageIncrease(Button button) {
        if (this.page + 1 >= this.getNumPages()) {
            return;
        }
        ++this.page;
        if (this.displayedGlyphs.size() < this.glyphsPerPage * (this.page + 1)) {
            this.nextButton.visible = false;
            this.nextButton.active = false;
        }
        this.previousButton.active = true;
        this.previousButton.visible = true;
        this.layoutAllGlyphs(this.page);
        this.validate();
    }

    public void onPageDec(Button button) {
        if (this.page <= 0) {
            this.page = 0;
            return;
        }
        --this.page;
        if (this.page == 0) {
            this.previousButton.active = false;
            this.previousButton.visible = false;
        }
        if (this.displayedGlyphs.size() > this.glyphsPerPage * (this.page + 1)) {
            this.nextButton.visible = true;
            this.nextButton.active = true;
        }
        this.layoutAllGlyphs(this.page);
        this.validate();
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        SoundManager manager = Minecraft.getInstance().getSoundManager();
        if (pScrollX < 0.0 && this.nextButton.active) {
            this.onPageIncrease((Button)this.nextButton);
            manager.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f));
        } else if (pScrollX > 0.0 && this.previousButton.active) {
            this.onPageDec((Button)this.previousButton);
            manager.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f));
        }
        return true;
    }

    public void onDocumentationClick(Button button) {
        if (ArsNouveau.patchouliLoaded) {
            PatchouliHandler.openBookClient();
        } else {
            try {
                Util.getPlatform().openUri(new URI("https://www.arsnouveau.wiki/"));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void onColorClick(Button button) {
        ParticleColor.IntWrapper color = SpellCasterRegistry.from(this.bookStack).getColor(this.selectedSpellSlot).toWrapper();
        Minecraft.getInstance().setScreen((Screen)new GuiColorScreen(color.r, color.g, color.b, this.selectedSpellSlot, this.hand));
    }

    public void onSoundsClick(Button button) {
        ConfiguredSpellSound spellSound = SpellCasterRegistry.from(this.bookStack).getSound(this.selectedSpellSlot);
        Minecraft.getInstance().setScreen((Screen)new SoundScreen(spellSound, this.selectedSpellSlot, this.hand));
    }

    public void onFamiliarClick(Button button) {
        Collection familiarHolders = new ArrayList();
        ANPlayerDataCap cap = CapabilityRegistry.getPlayerDataCap((LivingEntity)ArsNouveau.proxy.getPlayer());
        if (cap != null) {
            familiarHolders = cap.getUnlockedFamiliars().stream().map(s -> s.familiarHolder.getRegistryName()).collect(Collectors.toList());
        }
        ArrayList finalFamiliarHolders = familiarHolders;
        Minecraft.getInstance().setScreen((Screen)new GuiFamiliarScreen(FamiliarRegistry.getFamiliarHolderMap().values().stream().filter(f -> finalFamiliarHolders.contains(f.getRegistryName())).collect(Collectors.toList()), this));
    }

    public void onCraftingSlotClick(Button button) {
        ((CraftingButton)button).clear();
        this.validate();
    }

    public void onGlyphClick(Button button) {
        GlyphButton button1 = (GlyphButton)button;
        if (button1.validationErrors.isEmpty()) {
            for (CraftingButton b : this.craftingCells) {
                if (b.getAbstractSpellPart() != null) continue;
                b.setAbstractSpellPart(button1.abstractSpellPart);
                this.validate();
                return;
            }
        }
    }

    public void onSlotChange(Button button) {
        this.selected_slot.isSelected = false;
        this.selected_slot = (GuiSpellSlot)button;
        this.selected_slot.isSelected = true;
        this.selectedSpellSlot = this.selected_slot.slotNum;
        this.updateCraftingSlots(this.selectedSpellSlot);
        this.spell_name.setValue(SpellCasterRegistry.from(this.bookStack).getSpellName(this.selectedSpellSlot));
        this.validate();
    }

    public boolean charTyped(char pCodePoint, int pModifiers) {
        Renderable renderable = this.hoveredWidget;
        if (renderable instanceof GlyphButton) {
            GlyphButton glyphButton = (GlyphButton)renderable;
            if (glyphButton.validationErrors.isEmpty() && pCodePoint >= '0' && pCodePoint <= '9') {
                int num = Integer.parseInt(String.valueOf(pCodePoint));
                if (num == 0) {
                    num = 10;
                }
                this.craftingCells.get(--num).setAbstractSpellPart(glyphButton.abstractSpellPart);
                this.validate();
                return true;
            }
        }
        return super.charTyped(pCodePoint, pModifiers);
    }

    public void updateCraftingSlots(int bookSlot) {
        Spell recipe = SpellCasterRegistry.from(this.bookStack).getSpell(bookSlot);
        for (int i = 0; i < this.craftingCells.size(); ++i) {
            CraftingButton slot = this.craftingCells.get(i);
            slot.clear();
            if (i >= recipe.size()) continue;
            slot.setAbstractSpellPart(recipe.get(i));
        }
    }

    public void clear(Button button) {
        boolean allWereEmpty = true;
        for (CraftingButton slot : this.craftingCells) {
            if (slot.getAbstractSpellPart() != null) {
                allWereEmpty = false;
            }
            slot.clear();
        }
        if (allWereEmpty) {
            this.spell_name.setValue("");
        }
        this.validate();
    }

    public void onCreateClick(Button button) {
        this.validate();
        if (this.validationErrors.isEmpty()) {
            Spell.Mutable spell = new Spell().mutable();
            for (CraftingButton slot : this.craftingCells) {
                AbstractSpellPart spellPart = slot.getAbstractSpellPart();
                if (spellPart == null) continue;
                spell.add(spellPart);
            }
            Networking.sendToServer(new PacketUpdateCaster(spell.immutable(), this.selectedSpellSlot, this.spell_name.getValue(), this.hand == InteractionHand.MAIN_HAND));
        }
    }

    public static void open(InteractionHand hand) {
        Minecraft.getInstance().setScreen((Screen)new GuiSpellBook(hand));
    }

    @Override
    public void drawBackgroundElements(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawBackgroundElements(graphics, mouseX, mouseY, partialTicks);
        if (this.formTextRow >= 1) {
            graphics.drawString(this.font, Component.translatable((String)"ars_nouveau.spell_book_gui.form").getString(), this.formTextRow > 6 ? 154 : 20, 5 + 18 * (this.formTextRow + (this.formTextRow == 1 ? 0 : 1)), -8355712, false);
        }
        if (this.effectTextRow >= 1) {
            graphics.drawString(this.font, Component.translatable((String)"ars_nouveau.spell_book_gui.effect").getString(), this.effectTextRow > 6 ? 154 : 20, 5 + 18 * (this.effectTextRow + 1), -8355712, false);
        }
        if (this.augmentTextRow >= 1) {
            graphics.drawString(this.font, Component.translatable((String)"ars_nouveau.spell_book_gui.augment").getString(), this.augmentTextRow > 6 ? 154 : 20, 5 + 18 * (this.augmentTextRow + 1), -8355712, false);
        }
        graphics.blit(ArsNouveau.prefix("textures/gui/spell_name_paper.png"), 16, 179, 0.0f, 0.0f, 109, 15, 109, 15);
        graphics.blit(ArsNouveau.prefix("textures/gui/search_paper.png"), 203, 0, 0.0f, 0.0f, 72, 15, 72, 15);
        graphics.blit(ArsNouveau.prefix("textures/gui/clear_paper.png"), 161, 179, 0.0f, 0.0f, 47, 15, 47, 15);
        graphics.blit(ArsNouveau.prefix("textures/gui/create_paper.png"), 216, 179, 0.0f, 0.0f, 56, 15, 56, 15);
        if (this.validationErrors.isEmpty()) {
            graphics.drawString(this.font, (Component)Component.translatable((String)"ars_nouveau.spell_book_gui.create"), 233, 183, -8355712, false);
        } else {
            MutableComponent textComponent = Component.translatable((String)"ars_nouveau.spell_book_gui.create").withStyle(s -> s.withStrikethrough(Boolean.valueOf(true)).withColor((TextColor)TextColor.parseColor((String)"#FFB2B2").getOrThrow()));
            graphics.drawString(this.font, (Component)textComponent, 233, 183, -8355712, false);
        }
        graphics.drawString(this.font, Component.translatable((String)"ars_nouveau.spell_book_gui.clear").getString(), 177, 183, -8355712, false);
        int manaLength = 96;
        manaLength = this.maxManaCache > 0 ? (int)Mth.clamp((float)((float)manaLength * ((float)(this.maxManaCache - this.currentCostCache) / (float)this.maxManaCache)), (float)-1.0f, (float)96.0f) : 0;
        int offsetLeft = 89;
        int yOffset = 210;
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.scale(1.2f, 1.2f, 1.2f);
        poseStack.translate(-25.0f, -30.0f, 0.0f);
        graphics.blit(ArsNouveau.prefix("textures/gui/manabar_gui_border.png"), offsetLeft, yOffset - 18, 0.0f, 0.0f, 108, 18, 256, 256);
        int manaOffset = (int)(((float)ClientInfo.ticksInGame + partialTicks) / 3.0f % 33.0f) * 6;
        if (manaLength >= 0) {
            graphics.blit(ArsNouveau.prefix("textures/gui/manabar_gui_mana.png"), offsetLeft + 9, yOffset - 9, 0.0f, (float)manaOffset, manaLength, 6, 256, 256);
        } else {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ArsNouveau.prefix("textures/gui/manabar_gui_grayscale.png"));
            RenderUtils.colorBlit(graphics.pose(), offsetLeft + 8, yOffset - 10, 0, manaOffset, 100, 8, 256, 256, manaLength < 0 ? Color.RED : Color.rainbowColor(ClientInfo.ticksInGame));
        }
        if (ArsNouveauAPI.ENABLE_DEBUG_NUMBERS && this.minecraft != null) {
            String text = this.currentCostCache + "  /  " + this.maxManaCache;
            int maxWidth = this.minecraft.font.width(this.maxManaCache + "  /  " + this.maxManaCache);
            int offset = offsetLeft - maxWidth / 2 + (maxWidth - this.minecraft.font.width(text));
            graphics.drawString(this.minecraft.font, text, offset + 55, yOffset - 10, 0xFFFFFF, false);
        }
        graphics.blit(ArsNouveau.prefix("textures/gui/manabar_gui_border.png"), offsetLeft, yOffset - 17, 0.0f, 18.0f, 108, 20, 256, 256);
        poseStack.popPose();
    }

    private int getCurrentManaCost() {
        Spell spell = new Spell();
        for (CraftingButton button : this.craftingCells) {
            AbstractSpellPart part = button.getAbstractSpellPart();
            if (part == null) continue;
            spell = spell.add(part);
        }
        int cost = spell.getCost() - ManaUtil.getPlayerDiscounts((LivingEntity)Minecraft.getInstance().player, spell, this.bookStack);
        return Math.max(cost, 0);
    }

    private void validate() {
        AbstractList recipe = new LinkedList<AbstractSpellPart>();
        int firstBlankSlot = -1;
        for (int i = 0; i < this.craftingCells.size(); ++i) {
            CraftingButton b = this.craftingCells.get(i);
            b.validationErrors.clear();
            if (b.getAbstractSpellPart() == null) {
                recipe.add(null);
                if (firstBlankSlot >= 0) continue;
                firstBlankSlot = i;
                continue;
            }
            recipe.add(b.getAbstractSpellPart());
        }
        List<SpellValidationError> errors = this.spellValidator.validate(recipe);
        for (SpellValidationError ve : errors) {
            if (ve.getPosition() < 0 || ve.getPosition() > this.craftingCells.size()) continue;
            CraftingButton b = this.craftingCells.get(ve.getPosition());
            b.validationErrors.add(ve);
        }
        this.validationErrors = errors;
        if (firstBlankSlot >= 0) {
            recipe = new ArrayList(recipe.subList(0, firstBlankSlot));
        }
        for (GlyphButton button : this.glyphButtons) {
            this.validateGlyphButton(recipe, button);
        }
        this.currentCostCache = this.getCurrentManaCost();
        this.maxManaCache = ManaUtil.getMaxMana((Player)Minecraft.getInstance().player);
    }

    private void validateGlyphButton(List<AbstractSpellPart> recipe, GlyphButton glyphButton) {
        glyphButton.validationErrors.clear();
        recipe.add(GlyphRegistry.getSpellpartMap().get(glyphButton.abstractSpellPart.getRegistryName()));
        glyphButton.validationErrors.addAll(this.spellValidator.validate(recipe).stream().filter(ve -> ve.getPosition() >= recipe.size() - 1).toList());
        recipe.remove(recipe.size() - 1);
    }

    @Override
    public void render(GuiGraphics ms, int mouseX, int mouseY, float partialTicks) {
        super.render(ms, mouseX, mouseY, partialTicks);
        if (this.setFocusOnLoad) {
            this.setFocusOnLoad = false;
            this.setInitialFocus((GuiEventListener)this.searchBar);
        }
        this.hoveredWidget = null;
        for (Renderable widget : this.renderables) {
            AbstractWidget abstractWidget;
            if (!(widget instanceof AbstractWidget) || !GuiUtils.isMouseInRelativeRange(mouseX, mouseY, abstractWidget = (AbstractWidget)widget)) continue;
            this.hoveredWidget = widget;
            break;
        }
        this.spell_name.setSuggestion(this.spell_name.getValue().isEmpty() ? Component.translatable((String)"ars_nouveau.spell_book_gui.spell_name").getString() : "");
    }

    @Override
    public void collectTooltips(GuiGraphics stack, int mouseX, int mouseY, List<Component> tooltip) {
        if (GuiUtils.isMouseInRelativeRange(mouseX, mouseY, (AbstractWidget)this.createSpellButton)) {
            if (!this.validationErrors.isEmpty()) {
                boolean foundGlyphErrors = false;
                tooltip.add((Component)Component.translatable((String)"ars_nouveau.spell.validation.crafting.invalid").withStyle(ChatFormatting.RED));
                for (SpellValidationError error : this.validationErrors) {
                    if (error.getPosition() < 0) {
                        tooltip.add((Component)error.makeTextComponentExisting());
                        continue;
                    }
                    foundGlyphErrors = true;
                }
                if (foundGlyphErrors) {
                    tooltip.add((Component)Component.translatable((String)"ars_nouveau.spell.validation.crafting.invalid_glyphs"));
                }
            }
        } else {
            super.collectTooltips(stack, mouseX, mouseY, tooltip);
        }
    }
}

