/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui;

import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.client.gui.Color;
import com.hollingsworth.arsnouveau.common.items.data.ItemScrollData;
import com.hollingsworth.arsnouveau.setup.config.Config;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class GuiEntityInfoHUD {
    public static MultiBufferSource.BufferSource renderType = MultiBufferSource.immediate((ByteBufferBuilder)new ByteBufferBuilder(1536));
    public static final LayeredDraw.Layer OVERLAY = GuiEntityInfoHUD::renderOverlay;
    public static int hoverTicks = 0;
    public static Object lastHovered = null;
    public static final Color VANILLA_TOOLTIP_BORDER_1 = new Color(0x505000FF, true);
    public static final Color VANILLA_TOOLTIP_BORDER_2 = new Color(1344798847, true);
    public static final Color VANILLA_TOOLTIP_BACKGROUND = new Color(-267386864, true);

    public static void renderOverlay(GuiGraphics graphics, DeltaTracker tracker) {
        PoseStack poseStack = graphics.pose();
        Minecraft mc = Minecraft.getInstance();
        if (mc.options.hideGui || mc.gameMode.getPlayerMode() == GameType.SPECTATOR) {
            return;
        }
        HitResult objectMouseOver = mc.hitResult;
        ArrayList<Component> tooltip = new ArrayList<Component>();
        BlockPos hovering = null;
        if (objectMouseOver instanceof BlockHitResult) {
            BlockHitResult hitResult = (BlockHitResult)objectMouseOver;
            hovering = hitResult.getBlockPos();
            var10_9 = mc.level.getBlockEntity(hitResult.getBlockPos());
            if (var10_9 instanceof ITooltipProvider) {
                ITooltipProvider iTooltipProvider = (ITooltipProvider)var10_9;
                iTooltipProvider.getTooltip(tooltip);
            }
        } else if (objectMouseOver instanceof EntityHitResult) {
            EntityHitResult result = (EntityHitResult)objectMouseOver;
            var10_9 = result.getEntity();
            if (var10_9 instanceof ITooltipProvider) {
                ITooltipProvider iTooltipProvider = (ITooltipProvider)var10_9;
                iTooltipProvider.getTooltip(tooltip);
            }
            if ((var10_9 = result.getEntity()) instanceof ItemFrame) {
                ItemFrame itemFrame = (ItemFrame)var10_9;
                ItemScrollData data = (ItemScrollData)itemFrame.getItem().getOrDefault(DataComponentRegistry.ITEM_SCROLL_DATA, (Object)new ItemScrollData(List.of()));
                for (ItemStack i : data.getItems()) {
                    tooltip.add(i.getHoverName());
                }
            }
            hovering = result.getEntity();
        }
        if (hovering == null || lastHovered != null && !lastHovered.equals(hovering)) {
            lastHovered = null;
            hoverTicks = 0;
        }
        hoverTicks = lastHovered == null || lastHovered.equals(hovering) ? ++hoverTicks : 0;
        lastHovered = hovering;
        if (tooltip.isEmpty()) {
            return;
        }
        poseStack.pushPose();
        int tooltipTextWidth = 0;
        for (FormattedText formattedText : tooltip) {
            int textLineWidth = mc.font.width(formattedText);
            if (textLineWidth <= tooltipTextWidth) continue;
            tooltipTextWidth = textLineWidth;
        }
        int tooltipHeight = 8;
        if (tooltip.size() > 1) {
            tooltipHeight += 2;
            tooltipHeight += (tooltip.size() - 1) * 10;
        }
        int n = (Integer)Config.TOOLTIP_X_OFFSET.get();
        int width = Minecraft.getInstance().getWindow().getGuiScaledWidth();
        int height = Minecraft.getInstance().getWindow().getGuiScaledHeight();
        int posX = width / 2 + n;
        int posY = height / 2 + (Integer)Config.TOOLTIP_Y_OFFSET.get();
        posX = Math.min(posX, width - tooltipTextWidth - 20);
        posY = Math.min(posY, height - tooltipHeight - 20);
        float fade = Mth.clamp((float)(((float)hoverTicks + tracker.getGameTimeDeltaTicks()) / 12.0f), (float)0.0f, (float)1.0f);
        Color colorBackground = VANILLA_TOOLTIP_BACKGROUND.scaleAlpha(0.75f);
        Color colorBorderTop = VANILLA_TOOLTIP_BORDER_1;
        Color colorBorderBot = VANILLA_TOOLTIP_BORDER_2;
        if (fade < 1.0f) {
            poseStack.translate((1.0f - fade) * Math.signum((float)n + 0.5f) * 4.0f, 0.0f, 0.0f);
            colorBackground.scaleAlpha(fade);
            colorBorderTop.scaleAlpha(fade);
            colorBorderBot.scaleAlpha(fade);
        }
        GuiEntityInfoHUD.drawHoveringText(ItemStack.EMPTY, graphics, tooltip, posX, posY, width, height, -1, colorBackground.getRGB(), colorBorderTop.getRGB(), colorBorderBot.getRGB(), mc.font);
        poseStack.popPose();
    }

    public static void drawHoveringText(@NotNull ItemStack stack, GuiGraphics graphics, List<? extends FormattedText> textLines, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, int backgroundColor, int borderColorStart, int borderColorEnd, Font font) {
        int n;
        if (textLines.isEmpty()) {
            return;
        }
        PoseStack pStack = graphics.pose();
        List list = ClientHooks.gatherTooltipComponents((ItemStack)stack, textLines, (Optional)stack.getTooltipImage(), (int)mouseX, (int)screenWidth, (int)screenHeight, (Font)font);
        RenderTooltipEvent.Pre event = new RenderTooltipEvent.Pre(stack, graphics, mouseX, mouseY, screenWidth, screenHeight, font, list, DefaultTooltipPositioner.INSTANCE);
        NeoForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return;
        }
        mouseX = event.getX();
        mouseY = event.getY();
        screenWidth = event.getScreenWidth();
        screenHeight = event.getScreenHeight();
        font = event.getFont();
        RenderSystem.disableDepthTest();
        int tooltipTextWidth = 0;
        for (FormattedText formattedText : textLines) {
            int textLineWidth = font.width(formattedText);
            if (textLineWidth <= tooltipTextWidth) continue;
            tooltipTextWidth = textLineWidth;
        }
        boolean needsWrap = false;
        boolean bl = true;
        int tooltipX = mouseX + 12;
        if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
            tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
            needsWrap = true;
        }
        if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
            tooltipTextWidth = maxTextWidth;
            needsWrap = true;
        }
        if (needsWrap) {
            int wrappedTooltipWidth = 0;
            ArrayList<? extends FormattedText> wrappedTextLines = new ArrayList<FormattedText>();
            for (int i = 0; i < textLines.size(); ++i) {
                FormattedText textLine = textLines.get(i);
                List wrappedLine = font.getSplitter().splitLines(textLine, tooltipTextWidth, Style.EMPTY);
                if (i == 0) {
                    n = wrappedLine.size();
                }
                for (FormattedText line : wrappedLine) {
                    int lineWidth = font.width(line);
                    if (lineWidth > wrappedTooltipWidth) {
                        wrappedTooltipWidth = lineWidth;
                    }
                    wrappedTextLines.add((FormattedText)line);
                }
            }
            tooltipTextWidth = wrappedTooltipWidth;
            textLines = wrappedTextLines;
            tooltipX = mouseX > screenWidth / 2 ? mouseX - 16 - tooltipTextWidth : mouseX + 12;
        }
        int tooltipY = mouseY - 12;
        int tooltipHeight = 8;
        if (textLines.size() > 1) {
            tooltipHeight += (textLines.size() - 1) * 10;
            if (textLines.size() > n) {
                tooltipHeight += 2;
            }
        }
        if (tooltipY < 4) {
            tooltipY = 4;
        } else if (tooltipY + tooltipHeight + 4 > screenHeight) {
            tooltipY = screenHeight - tooltipHeight - 4;
        }
        int zLevel = 400;
        RenderTooltipEvent.Color colorEvent = new RenderTooltipEvent.Color(stack, graphics, tooltipX, tooltipY, font, backgroundColor, borderColorStart, borderColorEnd, list);
        NeoForge.EVENT_BUS.post((Event)colorEvent);
        backgroundColor = colorEvent.getBackgroundStart();
        borderColorStart = colorEvent.getBorderStart();
        borderColorEnd = colorEvent.getBorderEnd();
        pStack.pushPose();
        Matrix4f mat = pStack.last().pose();
        graphics.fillGradient(tooltipX - 3, tooltipY - 4, tooltipX + tooltipTextWidth + 3, tooltipY - 3, backgroundColor, backgroundColor);
        graphics.fillGradient(tooltipX - 3, tooltipY + tooltipHeight + 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 4, backgroundColor, backgroundColor);
        graphics.fillGradient(tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
        graphics.fillGradient(tooltipX - 4, tooltipY - 3, tooltipX - 3, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
        graphics.fillGradient(tooltipX + tooltipTextWidth + 3, tooltipY - 3, tooltipX + tooltipTextWidth + 4, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
        graphics.fillGradient(tooltipX - 3, tooltipY - 3 + 1, tooltipX - 3 + 1, tooltipY + tooltipHeight + 3 - 1, borderColorStart, borderColorEnd);
        graphics.fillGradient(tooltipX + tooltipTextWidth + 2, tooltipY - 3 + 1, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3 - 1, borderColorStart, borderColorEnd);
        graphics.fillGradient(tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY - 3 + 1, borderColorStart, borderColorStart);
        graphics.fillGradient(tooltipX - 3, tooltipY + tooltipHeight + 2, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, borderColorEnd, borderColorEnd);
        pStack.translate(0.0, 0.0, 400.0);
        for (int lineNumber = 0; lineNumber < list.size(); ++lineNumber) {
            FormattedText line;
            line = (ClientTooltipComponent)list.get(lineNumber);
            if (line != null) {
                line.renderText(font, tooltipX, tooltipY, mat, renderType);
            }
            if (lineNumber + 1 == n) {
                tooltipY += 2;
            }
            tooltipY += 10;
        }
        renderType.endBatch();
        pStack.popPose();
        RenderSystem.enableDepthTest();
    }
}

