/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui;

import com.hollingsworth.arsnouveau.client.ClientInfo;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class GlyphRecipeTooltip
implements ClientTooltipComponent {
    public static final ResourceLocation TEXTURE_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/gui/container/bundle/background.png");
    private static final int MARGIN_Y = 4;
    private static final int BORDER_WIDTH = 1;
    private static final int TEX_SIZE = 128;
    private static final int SLOT_SIZE_X = 18;
    private static final int SLOT_SIZE_Y = 20;
    private final List<Ingredient> items;

    public GlyphRecipeTooltip(List<Ingredient> items) {
        this.items = items;
    }

    public int getHeight() {
        return this.gridSizeY() * 20 + 2 + 4;
    }

    public int getWidth(Font pFont) {
        return this.gridSizeX() * 18 + 2;
    }

    public void renderImage(Font pFont, int pMouseX, int pMouseY, GuiGraphics graphics) {
        if (this.items.isEmpty()) {
            return;
        }
        int i = this.gridSizeX();
        int j = this.gridSizeY();
        boolean overWEight = false;
        int k = 0;
        for (int l = 0; l < j; ++l) {
            for (int i1 = 0; i1 < i; ++i1) {
                int j1 = pMouseX + i1 * 18 + 1;
                int k1 = pMouseY + l * 20 + 1;
                this.renderSlot(j1, k1, k++, overWEight, pFont, graphics);
            }
        }
        this.drawBorder(pMouseX, pMouseY, i, j, graphics);
    }

    private void renderSlot(int pX, int pY, int pItemIndex, boolean pIsBundleFull, Font pFont, GuiGraphics graphics) {
        if (pItemIndex >= this.items.size()) {
            this.blit(graphics, pX, pY, pIsBundleFull ? Texture.BLOCKED_SLOT : Texture.SLOT);
        } else {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>(List.of(this.items.get(pItemIndex).getItems()));
            ItemStack itemstack = (ItemStack)items.get(ClientInfo.ticksInGame / 20 % items.size());
            this.blit(graphics, pX, pY, Texture.SLOT);
            graphics.renderItem(itemstack, pX + 1, pY + 1, pItemIndex);
            graphics.renderItemDecorations(pFont, itemstack, pX + 1, pY + 1);
        }
    }

    private void drawBorder(int pX, int pY, int pSlotWidth, int pSlotHeight, GuiGraphics pPoseStack) {
        this.blit(pPoseStack, pX, pY, Texture.BORDER_CORNER_TOP);
        this.blit(pPoseStack, pX + pSlotWidth * 18 + 1, pY, Texture.BORDER_CORNER_TOP);
        for (int i = 0; i < pSlotWidth; ++i) {
            this.blit(pPoseStack, pX + 1 + i * 18, pY, Texture.BORDER_HORIZONTAL_TOP);
            this.blit(pPoseStack, pX + 1 + i * 18, pY + pSlotHeight * 20, Texture.BORDER_HORIZONTAL_BOTTOM);
        }
        for (int j = 0; j < pSlotHeight; ++j) {
            this.blit(pPoseStack, pX, pY + j * 20 + 1, Texture.BORDER_VERTICAL);
            this.blit(pPoseStack, pX + pSlotWidth * 18 + 1, pY + j * 20 + 1, Texture.BORDER_VERTICAL);
        }
        this.blit(pPoseStack, pX, pY + pSlotHeight * 20, Texture.BORDER_CORNER_BOTTOM);
        this.blit(pPoseStack, pX + pSlotWidth * 18 + 1, pY + pSlotHeight * 20, Texture.BORDER_CORNER_BOTTOM);
    }

    private void blit(GuiGraphics graphics, int pX, int pY, Texture pTexture) {
        graphics.blit(TEXTURE_LOCATION, pX, pY, (float)pTexture.x, (float)pTexture.y, pTexture.w, pTexture.h, 128, 128);
    }

    private int gridSizeX() {
        return this.items.size() == 0 ? 0 : Math.min(3, this.items.size());
    }

    private int gridSizeY() {
        if (this.items.isEmpty()) {
            return 0;
        }
        if (this.items.size() % 3 != 0) {
            return this.items.size() / 3 + 1;
        }
        return this.items.size() / 3;
    }

    @OnlyIn(value=Dist.CLIENT)
    static enum Texture {
        SLOT(0, 0, 18, 20),
        BLOCKED_SLOT(0, 40, 18, 20),
        BORDER_VERTICAL(0, 18, 1, 20),
        BORDER_HORIZONTAL_TOP(0, 20, 18, 1),
        BORDER_HORIZONTAL_BOTTOM(0, 60, 18, 1),
        BORDER_CORNER_TOP(0, 20, 1, 1),
        BORDER_CORNER_BOTTOM(0, 60, 1, 1);

        public final int x;
        public final int y;
        public final int w;
        public final int h;

        private Texture(int p_169928_, int p_169929_, int p_169930_, int p_169931_) {
            this.x = p_169928_;
            this.y = p_169929_;
            this.w = p_169930_;
            this.h = p_169931_;
        }
    }
}

