/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.container;

import java.util.Comparator;
import java.util.function.Function;
import net.minecraft.world.item.ItemStack;

public class StoredItemStack {
    private ItemStack stack;
    private long count;
    private static final String ITEM_COUNT_NAME = "c";
    private static final String ITEMSTACK_NAME = "s";
    private int hash;

    public StoredItemStack(ItemStack stack, long count) {
        this.stack = stack;
        this.count = count;
    }

    public StoredItemStack(ItemStack stack) {
        this.stack = stack.copy();
        this.stack.setCount(1);
        this.count = stack.getCount();
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public long getQuantity() {
        return this.count;
    }

    public ItemStack getActualStack() {
        ItemStack s = this.stack.copy();
        s.setCount((int)this.count);
        return s;
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = ItemStack.hashItemAndComponents((ItemStack)this.stack);
        }
        return this.hash;
    }

    public String getDisplayName() {
        return this.stack.getHoverName().getString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StoredItemStack other = (StoredItemStack)obj;
        if (this.stack == null) {
            return other.stack == null;
        }
        return ItemStack.isSameItem((ItemStack)this.stack, (ItemStack)other.stack) && ItemStack.matches((ItemStack)this.stack, (ItemStack)other.stack);
    }

    public boolean equals(StoredItemStack other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.count != other.count) {
            return false;
        }
        if (this.stack == null) {
            return other.stack == null;
        }
        return ItemStack.isSameItem((ItemStack)this.stack, (ItemStack)other.stack) && ItemStack.matches((ItemStack)this.stack, (ItemStack)other.stack);
    }

    public void grow(long c) {
        this.count += c;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public int getMaxStackSize() {
        return this.stack.getMaxStackSize();
    }

    public static enum SortingTypes {
        AMOUNT(ComparatorAmount::new),
        NAME(ComparatorName::new);

        public static final SortingTypes[] VALUES;
        private final Function<Boolean, IStoredItemStackComparator> factory;

        private SortingTypes(Function<Boolean, IStoredItemStackComparator> factory) {
            this.factory = factory;
        }

        public IStoredItemStackComparator create(boolean rev) {
            return this.factory.apply(rev);
        }

        static {
            VALUES = SortingTypes.values();
        }
    }

    public static interface IStoredItemStackComparator
    extends Comparator<StoredItemStack> {
        public boolean isReversed();

        public void setReversed(boolean var1);

        public int type();
    }

    public static class ComparatorName
    implements IStoredItemStackComparator {
        public boolean reversed;

        public ComparatorName(boolean reversed) {
            this.reversed = reversed;
        }

        @Override
        public int compare(StoredItemStack in1, StoredItemStack in2) {
            int c = in1.getDisplayName().compareTo(in2.getDisplayName());
            return this.reversed ? -c : c;
        }

        @Override
        public boolean isReversed() {
            return this.reversed;
        }

        @Override
        public int type() {
            return 1;
        }

        @Override
        public void setReversed(boolean rev) {
            this.reversed = rev;
        }
    }

    public static class ComparatorAmount
    implements IStoredItemStackComparator {
        public boolean reversed;

        public ComparatorAmount(boolean reversed) {
            this.reversed = reversed;
        }

        @Override
        public int compare(StoredItemStack in1, StoredItemStack in2) {
            int c = in2.getQuantity() > in1.getQuantity() ? 1 : (in1.getQuantity() == in2.getQuantity() ? in1.getStack().getHoverName().getString().compareTo(in2.getStack().getHoverName().getString()) : -1);
            return this.reversed ? -c : c;
        }

        @Override
        public boolean isReversed() {
            return this.reversed;
        }

        @Override
        public int type() {
            return 0;
        }

        @Override
        public void setReversed(boolean rev) {
            this.reversed = rev;
        }
    }
}

