/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.container;

import com.hollingsworth.arsnouveau.client.container.SlotStorage;
import com.hollingsworth.arsnouveau.client.container.SortSettings;
import com.hollingsworth.arsnouveau.client.container.StoredItemStack;
import com.hollingsworth.arsnouveau.client.container.TerminalSyncManager;
import com.hollingsworth.arsnouveau.common.block.tile.StorageLecternTile;
import com.hollingsworth.arsnouveau.common.network.ClientToServerStoragePacket;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.setup.registry.MenuRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;

public class StorageTerminalMenu
extends RecipeBookMenu<CraftingInput, CraftingRecipe> {
    protected StorageLecternTile te;
    protected int playerSlotsStart;
    protected List<SlotStorage> storageSlotList = new ArrayList<SlotStorage>();
    public List<StoredItemStack> itemList = new ArrayList<StoredItemStack>();
    public List<StoredItemStack> itemListClient = new ArrayList<StoredItemStack>();
    public List<StoredItemStack> itemListClientSorted = new ArrayList<StoredItemStack>();
    public TerminalSyncManager sync = new TerminalSyncManager();
    private int lines;
    protected Inventory pinv;
    public Runnable onPacket;
    public SortSettings terminalData = null;
    public String search;
    public boolean noSort;
    public List<String> tabNames = new ArrayList<String>();
    public String selectedTab = null;

    public StorageTerminalMenu(int id, Inventory inv, StorageLecternTile te) {
        this((MenuType)MenuRegistry.STORAGE.get(), id, inv, te);
        this.addPlayerSlots(inv, 8, 120);
    }

    public StorageTerminalMenu(MenuType<?> type, int id, Inventory inv, StorageLecternTile te) {
        super(type, id);
        this.te = te;
        this.pinv = inv;
        this.addStorageSlots();
    }

    public StorageTerminalMenu(MenuType<?> type, int id, Inventory inv) {
        this(type, id, inv, null);
    }

    protected void addStorageSlots() {
        this.addStorageSlots(8, 18);
    }

    protected void addPlayerSlots(Inventory playerInventory, int x, int y) {
        int i;
        this.playerSlotsStart = this.slots.size() - 1;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, x + j * 18, y + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, x + i * 18, y + 58));
        }
    }

    public void addStorageSlots(int x, int y) {
        this.storageSlotList.clear();
        this.lines = this.terminalData == null || !this.terminalData.expanded ? 3 : 7;
        for (int i = 0; i < this.lines; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlotToContainer(new SlotStorage(this.te, i * 9 + j, x + j * 18, y + i * 18));
            }
        }
        this.scrollTo(0.0f);
    }

    protected final void addSlotToContainer(SlotStorage slotStorage) {
        this.storageSlotList.add(slotStorage);
    }

    public boolean stillValid(Player playerIn) {
        return this.te != null && this.te.canInteractWith(playerIn);
    }

    public final void scrollTo(float p_148329_1_) {
        int i = (this.itemListClientSorted.size() + 9 - 1) / 9 - this.lines;
        int j = (int)((double)(p_148329_1_ * (float)i) + 0.5);
        if (j < 0) {
            j = 0;
        }
        for (int k = 0; k < this.lines; ++k) {
            for (int l = 0; l < 9; ++l) {
                int i1 = l + (k + j) * 9;
                if (i1 >= 0 && i1 < this.itemListClientSorted.size()) {
                    this.setSlotContents(l + k * 9, this.itemListClientSorted.get(i1));
                    continue;
                }
                this.setSlotContents(l + k * 9, null);
            }
        }
    }

    public final void setSlotContents(int id, StoredItemStack stack) {
        this.storageSlotList.get((int)id).stack = stack;
    }

    public final SlotStorage getSlotByID(int id) {
        return this.storageSlotList.get(id);
    }

    public void broadcastChanges() {
        if (this.te == null) {
            return;
        }
        Map<StoredItemStack, Long> itemsCount = this.te.getStacks(this.selectedTab);
        this.sync.update(itemsCount, (ServerPlayer)this.pinv.player, tag -> {
            if (!this.te.getLastSearch().equals(this.search)) {
                this.search = this.te.getLastSearch();
                tag.putString("search", this.search);
            }
            ListTag tabs = new ListTag();
            for (String s : this.te.getTabNames()) {
                CompoundTag nameTag = new CompoundTag();
                nameTag.putString("name", s);
                tabs.add((Object)nameTag);
            }
            tag.put("tabs", (Tag)tabs);
            tag.put("sortSettings", (Tag)this.te.sortSettings.toTag());
        });
        super.broadcastChanges();
    }

    public final ItemStack quickMoveStack(Player playerIn, int index) {
        if (this.slots.size() <= index) {
            return ItemStack.EMPTY;
        }
        if (index > this.playerSlotsStart && this.te != null) {
            if (this.slots.get(index) != null && ((Slot)this.slots.get(index)).hasItem()) {
                Slot slot = (Slot)this.slots.get(index);
                ItemStack slotStack = slot.getItem();
                StoredItemStack c = this.te.pushStack(new StoredItemStack(slotStack, slotStack.getCount()), this.selectedTab);
                ItemStack itemstack = c != null ? c.getActualStack() : ItemStack.EMPTY;
                slot.set(itemstack);
                if (!playerIn.level.isClientSide) {
                    this.broadcastChanges();
                }
            }
        } else {
            return this.shiftClickItems(playerIn, index);
        }
        return ItemStack.EMPTY;
    }

    protected ItemStack shiftClickItems(Player playerIn, int index) {
        return ItemStack.EMPTY;
    }

    public void fillCraftSlotsStackedContents(StackedContents itemHelperIn) {
    }

    public void clearCraftingContent() {
    }

    public boolean recipeMatches(RecipeHolder pRecipe) {
        return false;
    }

    public int getResultSlotIndex() {
        return 0;
    }

    public int getGridWidth() {
        return 0;
    }

    public int getGridHeight() {
        return 0;
    }

    public int getSize() {
        return 0;
    }

    public void sendMessage(CompoundTag compound) {
        Networking.sendToServer(new ClientToServerStoragePacket(compound));
    }

    public final void receiveClientNBTPacket(CompoundTag message) {
        if (this.sync.receiveUpdate(message)) {
            this.itemList = this.sync.getAsList();
            if (this.noSort) {
                this.itemListClient.forEach(s -> s.setCount(this.sync.getAmount((StoredItemStack)s)));
            } else {
                this.itemListClient = new ArrayList<StoredItemStack>(this.itemList);
            }
            this.pinv.setChanged();
        }
        if (message.contains("search")) {
            this.search = message.getString("search");
        }
        if (message.contains("sortSettings")) {
            boolean isExpanded = this.terminalData != null && this.terminalData.expanded;
            this.terminalData = SortSettings.fromTag(message.getCompound("sortSettings"));
            if (isExpanded != this.terminalData.expanded) {
                this.addStorageSlots();
            }
        }
        if (message.contains("tabs")) {
            ListTag tabs = message.getList("tabs", 10);
            this.tabNames = new ArrayList<String>();
            for (int i = 0; i < tabs.size(); ++i) {
                this.tabNames.add(tabs.getCompound(i).getString("name"));
            }
            Collections.sort(this.tabNames);
        }
        if (this.onPacket != null) {
            this.onPacket.run();
        }
    }

    public void receive(HolderLookup.Provider reg, CompoundTag message) {
        if (this.pinv.player.isSpectator()) {
            return;
        }
        if (message.contains("search")) {
            this.te.setLastSearch(message.getString("search"));
        }
        this.sync.receiveInteract(message, this);
        if (message.contains("termData")) {
            CompoundTag d = message.getCompound("termData");
            this.te.setSorting(SortSettings.fromTag(d.getCompound("sortSettings")));
            this.selectedTab = null;
            if (d.contains("selectedTab")) {
                this.selectedTab = d.getString("selectedTab");
            }
        }
    }

    public RecipeBookType getRecipeBookType() {
        return RecipeBookType.CRAFTING;
    }

    public boolean shouldMoveToInventory(int p_150635_) {
        return false;
    }

    public void onInteract(StoredItemStack clicked, SlotAction act, boolean pullOne) {
        ServerPlayer player = (ServerPlayer)this.pinv.player;
        player.resetLastActionTime();
        if (act == SlotAction.SPACE_CLICK) {
            for (int i = this.playerSlotsStart + 1; i < this.playerSlotsStart + 28; ++i) {
                this.quickMoveStack((Player)player, i);
            }
        } else if (act == SlotAction.PULL_OR_PUSH_STACK) {
            ItemStack stack = this.getCarried();
            if (!stack.isEmpty()) {
                StoredItemStack rem = this.te.pushStack(new StoredItemStack(stack), this.selectedTab);
                ItemStack itemstack = rem == null ? ItemStack.EMPTY : rem.getActualStack();
                this.setCarried(itemstack);
            } else {
                if (clicked == null) {
                    return;
                }
                StoredItemStack pulled = this.te.pullStack(clicked, clicked.getMaxStackSize(), this.selectedTab);
                if (pulled != null) {
                    this.setCarried(pulled.getActualStack());
                }
            }
        } else if (act == SlotAction.PULL_ONE) {
            ItemStack stack = this.getCarried();
            if (clicked == null) {
                return;
            }
            if (pullOne) {
                StoredItemStack pulled = this.te.pullStack(clicked, 1, this.selectedTab);
                if (pulled != null) {
                    ItemStack itemstack = pulled.getActualStack();
                    this.moveItemStackTo(itemstack, this.playerSlotsStart + 1, this.slots.size(), true);
                    if (itemstack.getCount() > 0) {
                        this.te.pushOrDrop(itemstack, this.selectedTab);
                    }
                    player.getInventory().setChanged();
                }
            } else if (!stack.isEmpty()) {
                StoredItemStack pulled;
                if (ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)clicked.getStack()) && stack.getCount() + 1 <= stack.getMaxStackSize() && (pulled = this.te.pullStack(clicked, 1, this.selectedTab)) != null) {
                    stack.grow(1);
                }
            } else {
                StoredItemStack pulled = this.te.pullStack(clicked, 1, this.selectedTab);
                if (pulled != null) {
                    this.setCarried(pulled.getActualStack());
                }
            }
        } else if (act == SlotAction.GET_HALF) {
            ItemStack stack = this.getCarried();
            if (!stack.isEmpty()) {
                ItemStack stack1 = stack.split(Math.max(Math.min(stack.getCount(), stack.getMaxStackSize()) / 2, 1));
                ItemStack itemstack = this.te.pushStack(stack1, this.selectedTab);
                stack.grow(!itemstack.isEmpty() ? itemstack.getCount() : 0);
                this.setCarried(stack);
            } else {
                if (clicked == null) {
                    return;
                }
                StoredItemStack pulled = this.te.pullStack(clicked, (int)Math.max(Math.min(clicked.getQuantity() / 2L, (long)(clicked.getMaxStackSize() / 2)), 1L), this.selectedTab);
                if (pulled != null) {
                    this.setCarried(pulled.getActualStack());
                }
            }
        } else if (act == SlotAction.GET_QUARTER) {
            ItemStack stack = this.getCarried();
            if (!stack.isEmpty()) {
                ItemStack stack1 = stack.split(Math.max(Math.min(stack.getCount(), stack.getMaxStackSize()) / 4, 1));
                ItemStack itemstack = this.te.pushStack(stack1, this.selectedTab);
                stack.grow(!itemstack.isEmpty() ? itemstack.getCount() : 0);
                this.setCarried(stack);
            } else {
                if (clicked == null) {
                    return;
                }
                long maxCount = 64L;
                for (StoredItemStack e : this.itemList) {
                    if (!e.equals(clicked)) continue;
                    maxCount = e.getQuantity();
                }
                StoredItemStack pulled = this.te.pullStack(clicked, (int)Math.max(Math.min(maxCount, (long)clicked.getMaxStackSize()) / 4L, 1L), this.selectedTab);
                if (pulled != null) {
                    this.setCarried(pulled.getActualStack());
                }
            }
        } else {
            if (clicked == null) {
                return;
            }
            StoredItemStack pulled = this.te.pullStack(clicked, clicked.getMaxStackSize(), this.selectedTab);
            if (pulled != null) {
                ItemStack itemstack = pulled.getActualStack();
                this.moveItemStackTo(itemstack, this.playerSlotsStart + 1, this.slots.size(), true);
                if (itemstack.getCount() > 0) {
                    this.te.pushOrDrop(itemstack, this.selectedTab);
                }
                player.getInventory().setChanged();
            }
        }
    }

    public static enum SlotAction {
        PULL_OR_PUSH_STACK,
        PULL_ONE,
        SPACE_CLICK,
        SHIFT_PULL,
        GET_HALF,
        GET_QUARTER;

    }
}

