/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.util;

import com.hollingsworth.arsnouveau.api.item.ICasterTool;
import com.hollingsworth.arsnouveau.api.item.IRadialProvider;
import com.hollingsworth.arsnouveau.api.item.ISpellHotkeyListener;
import com.hollingsworth.arsnouveau.api.registry.SpellCasterRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractCaster;
import com.hollingsworth.arsnouveau.common.items.SpellBook;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class StackUtil {
    @NotNull
    public static ItemStack getHeldSpellbook(Player playerEntity) {
        ItemStack book;
        ItemStack itemStack = book = playerEntity.getMainHandItem().getItem() instanceof SpellBook ? playerEntity.getMainHandItem() : null;
        return book == null ? (playerEntity.getOffhandItem().getItem() instanceof SpellBook ? playerEntity.getOffhandItem() : ItemStack.EMPTY) : book;
    }

    @Nullable
    public static InteractionHand getBookHand(Player playerEntity) {
        ItemStack mainStack = playerEntity.getMainHandItem();
        ItemStack offStack = playerEntity.getOffhandItem();
        if (mainStack.getItem() instanceof SpellBook) {
            return InteractionHand.MAIN_HAND;
        }
        if (offStack.getItem() instanceof SpellBook) {
            return InteractionHand.OFF_HAND;
        }
        return null;
    }

    @Nullable
    public static InteractionHand getHeldCasterTool(Player player) {
        return StackUtil.getHeldCasterTool(player, tool -> true);
    }

    @Nullable
    public static InteractionHand getHeldCasterTool(Player player, Predicate<AbstractCaster<?>> filter) {
        ItemStack mainStack = player.getMainHandItem();
        ItemStack offStack = player.getOffhandItem();
        AbstractCaster<?> mainCaster = SpellCasterRegistry.from(mainStack);
        AbstractCaster<?> offCaster = SpellCasterRegistry.from(offStack);
        if (mainCaster != null && filter.test(mainCaster)) {
            return InteractionHand.MAIN_HAND;
        }
        if (offCaster != null && filter.test(offCaster)) {
            return InteractionHand.OFF_HAND;
        }
        return null;
    }

    @Nullable
    public static InteractionHand getQuickCaster(Player player) {
        ISpellHotkeyListener listener;
        InteractionHand casterTool;
        Item item = player.getMainHandItem().getItem();
        InteractionHand interactionHand = casterTool = item instanceof ISpellHotkeyListener && (listener = (ISpellHotkeyListener)item).canQuickCast() ? InteractionHand.MAIN_HAND : null;
        return casterTool == null ? ((item = player.getOffhandItem().getItem()) instanceof ISpellHotkeyListener && (listener = (ISpellHotkeyListener)item).canQuickCast() ? InteractionHand.OFF_HAND : null) : casterTool;
    }

    @NotNull
    public static ItemStack getHeldRadial(Player playerEntity) {
        ItemStack book = playerEntity.getMainHandItem().getItem() instanceof IRadialProvider ? playerEntity.getMainHandItem() : ItemStack.EMPTY;
        return book.isEmpty() ? playerEntity.getOffhandItem() : book;
    }

    public static ItemStack getHeldCasterToolOrEmpty(Player player) {
        ItemStack stack = ItemStack.EMPTY;
        if (player.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof ICasterTool) {
            stack = player.getItemInHand(InteractionHand.MAIN_HAND);
        } else if (player.getItemInHand(InteractionHand.OFF_HAND).getItem() instanceof ICasterTool) {
            stack = player.getItemInHand(InteractionHand.OFF_HAND);
        }
        return stack;
    }
}

