/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.util;

import com.hollingsworth.arsnouveau.api.source.ISpecialSourceProvider;
import com.hollingsworth.arsnouveau.api.source.SourceManager;
import com.hollingsworth.arsnouveau.api.source.SourceProvider;
import com.hollingsworth.arsnouveau.common.block.tile.SourceJarTile;
import com.hollingsworth.arsnouveau.common.entity.EntityFollowProjectile;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class SourceUtil {
    public static List<ISpecialSourceProvider> canGiveSource(BlockPos pos, Level world, int range) {
        ArrayList<ISpecialSourceProvider> posList = new ArrayList<ISpecialSourceProvider>();
        BlockPos.withinManhattanStream((BlockPos)pos, (int)range, (int)range, (int)range).forEach(b -> {
            SourceJarTile jar;
            BlockEntity patt0$temp;
            if (world.isLoaded(b) && (patt0$temp = world.getBlockEntity(b)) instanceof SourceJarTile && (jar = (SourceJarTile)patt0$temp).canAcceptSource()) {
                posList.add(new SourceProvider(jar, b.immutable()));
            }
        });
        List<ISpecialSourceProvider> provider = SourceManager.INSTANCE.canGiveSourceNearby(pos, world, range);
        for (ISpecialSourceProvider p : provider) {
            posList.add(new SourceProvider(p));
        }
        return posList;
    }

    public static List<ISpecialSourceProvider> canTakeSource(BlockPos pos, Level world, int range) {
        ArrayList<ISpecialSourceProvider> posList = new ArrayList<ISpecialSourceProvider>();
        BlockPos.withinManhattanStream((BlockPos)pos, (int)range, (int)range, (int)range).forEach(b -> {
            SourceJarTile jar;
            BlockEntity patt0$temp;
            if (world.isLoaded(b) && (patt0$temp = world.getBlockEntity(b)) instanceof SourceJarTile && (jar = (SourceJarTile)patt0$temp).getSource() > 0) {
                posList.add(new SourceProvider(jar, b.immutable()));
            }
        });
        List<ISpecialSourceProvider> provider = SourceManager.INSTANCE.canTakeSourceNearby(pos, world, range);
        for (ISpecialSourceProvider p : provider) {
            posList.add(new SourceProvider(p));
        }
        return posList;
    }

    @Nullable
    public static ISpecialSourceProvider takeSource(BlockPos pos, Level level, int range, int source) {
        List<ISpecialSourceProvider> providers = SourceUtil.canTakeSource(pos, level, range);
        for (ISpecialSourceProvider provider : providers) {
            if (provider.getSource().getSource() < source) continue;
            provider.getSource().removeSource(source);
            return provider;
        }
        return null;
    }

    @Nullable
    public static ISpecialSourceProvider takeSourceWithParticles(BlockPos pos, Level level, int range, int source) {
        ISpecialSourceProvider result = SourceUtil.takeSource(pos, level, range, source);
        if (result != null) {
            EntityFollowProjectile aoeProjectile = new EntityFollowProjectile(level, result.getCurrentPos(), pos);
            level.addFreshEntity((Entity)aoeProjectile);
        }
        return result;
    }

    public static boolean hasSourceNearby(BlockPos pos, Level world, int range, int source) {
        Optional loc = BlockPos.findClosestMatch((BlockPos)pos, (int)range, (int)range, b -> {
            SourceJarTile jar;
            BlockEntity patt0$temp = world.getBlockEntity(b);
            return patt0$temp instanceof SourceJarTile && (jar = (SourceJarTile)patt0$temp).getSource() >= source;
        });
        if (loc.isPresent()) {
            return true;
        }
        return SourceManager.INSTANCE.hasSourceNearby(pos, world, range, source) != null;
    }
}

