/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.util;

import com.hollingsworth.arsnouveau.api.item.inv.FilterableItemHandler;
import com.hollingsworth.arsnouveau.common.items.ItemScroll;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.PlayerMainInvWrapper;

public class InvUtil {
    public static List<FilterableItemHandler> adjacentInventories(Level level, BlockPos pos) {
        ArrayList<FilterableItemHandler> inventories = new ArrayList<FilterableItemHandler>();
        for (Direction d : Direction.values()) {
            IItemHandler handler;
            BlockEntity adjacentInvTile = level.getBlockEntity(pos.relative(d));
            if (adjacentInvTile == null || adjacentInvTile.isRemoved() || (handler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, (Object)d)) == null) continue;
            inventories.add(new FilterableItemHandler(handler, InvUtil.filtersOnTile(adjacentInvTile)));
        }
        return inventories;
    }

    public static List<Function<ItemStack, ItemScroll.SortPref>> filtersOnTile(@Nullable BlockEntity thisTile) {
        if (thisTile == null || thisTile.isRemoved()) {
            return new ArrayList<Function<ItemStack, ItemScroll.SortPref>>();
        }
        Level level = thisTile.getLevel();
        BlockPos pos = thisTile.getBlockPos();
        ArrayList<Function<ItemStack, ItemScroll.SortPref>> filters = new ArrayList<Function<ItemStack, ItemScroll.SortPref>>();
        IItemHandler inv = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, level.getBlockState(pos), thisTile, null);
        if (inv == null) {
            return filters;
        }
        for (ItemFrame i : level.getEntitiesOfClass(ItemFrame.class, new AABB(pos).inflate(1.0))) {
            BlockEntity tileOnFrame = level.getBlockEntity(i.blockPosition().relative(i.getDirection().getOpposite()));
            ItemStack stackInFrame = i.getItem();
            if (tileOnFrame == null || !tileOnFrame.equals(thisTile) || i.getItem().isEmpty() || stackInFrame.isEmpty()) continue;
            Item item = stackInFrame.getItem();
            if (item instanceof ItemScroll) {
                ItemScroll scrollItem = (ItemScroll)item;
                filters.add(stackToStore -> scrollItem.getSortPref((ItemStack)stackToStore, stackInFrame, inv));
                continue;
            }
            filters.add(stackToStore -> stackToStore.getItem() == stackInFrame.getItem() ? ItemScroll.SortPref.HIGHEST : ItemScroll.SortPref.INVALID);
        }
        return filters;
    }

    public static List<FilterableItemHandler> fromPlayer(Player player) {
        ArrayList<FilterableItemHandler> list = new ArrayList<FilterableItemHandler>();
        list.add(new FilterableItemHandler((IItemHandler)new PlayerMainInvWrapper(player.inventory), new ArrayList<Function<ItemStack, ItemScroll.SortPref>>()));
        return list;
    }
}

