/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.spell.wrapped_caster;

import com.hollingsworth.arsnouveau.api.item.inv.FilterableItemHandler;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.util.InvUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class TileCaster
implements IWrappedCaster {
    protected SpellContext.CasterType casterType;
    protected BlockEntity tile;

    public TileCaster(BlockEntity tile, SpellContext.CasterType casterType) {
        this.tile = tile;
        this.casterType = casterType;
    }

    @Override
    @NotNull
    public List<FilterableItemHandler> getInventory() {
        return new ArrayList<FilterableItemHandler>(InvUtil.adjacentInventories(this.tile.getLevel(), this.tile.getBlockPos()));
    }

    @Override
    public SpellContext.CasterType getCasterType() {
        return this.casterType;
    }

    public BlockEntity getTile() {
        return this.tile;
    }

    @Override
    public Direction getFacingDirection() {
        if (this.tile.getBlockState().hasProperty((Property)BlockStateProperties.FACING)) {
            return (Direction)this.tile.getBlockState().getValue((Property)BlockStateProperties.FACING);
        }
        return Direction.NORTH;
    }

    @Override
    public BlockEntity getNearbyBlockEntity(Predicate<BlockEntity> predicate) {
        for (Direction dir : Direction.values()) {
            BlockEntity tile = this.tile.getLevel().getBlockEntity(this.tile.getBlockPos().relative(dir));
            if (tile == null || !predicate.test(tile)) continue;
            return tile;
        }
        return null;
    }

    @Override
    public Vec3 getPosition() {
        return new Vec3((double)this.tile.getBlockPos().getX(), (double)this.tile.getBlockPos().getY(), (double)this.tile.getBlockPos().getZ());
    }
}

