/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.spell.wrapped_caster;

import com.hollingsworth.arsnouveau.api.item.inv.FilterableItemHandler;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.PlayerCaster;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class LivingCaster
implements IWrappedCaster {
    public LivingEntity livingEntity;

    public LivingCaster(LivingEntity livingEntity) {
        this.livingEntity = livingEntity;
    }

    public static LivingCaster from(LivingEntity livingEntity) {
        Player player;
        if (livingEntity instanceof Player && !((player = (Player)livingEntity) instanceof FakePlayer)) {
            return new PlayerCaster(player);
        }
        return new LivingCaster(livingEntity);
    }

    @Override
    public SpellContext.CasterType getCasterType() {
        return SpellContext.CasterType.LIVING_ENTITY;
    }

    @Override
    @NotNull
    public List<FilterableItemHandler> getInventory() {
        ArrayList<FilterableItemHandler> filterableItemHandlers = new ArrayList<FilterableItemHandler>();
        IItemHandler cap = (IItemHandler)this.livingEntity.getCapability(Capabilities.ItemHandler.ENTITY);
        if (cap != null) {
            filterableItemHandlers.add(new FilterableItemHandler(cap));
        }
        return filterableItemHandlers;
    }

    @Override
    public Direction getFacingDirection() {
        return this.livingEntity.getDirection();
    }

    @Override
    public Vec3 getPosition() {
        return this.livingEntity.position();
    }
}

