/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.spell;

import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.common.util.ANCodecs;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public record SpellSlotMap(Map<Integer, Spell> slots) {
    public static final Codec<SpellSlotMap> CODEC = ANCodecs.intMap(Spell.CODEC.codec(), SpellSlotMap::new, SpellSlotMap::slots);
    public static final StreamCodec<RegistryFriendlyByteBuf, SpellSlotMap> STREAM = StreamCodec.ofMember((val, buf) -> {
        Set<Map.Entry<Integer, Spell>> entries = val.slots.entrySet();
        buf.writeInt(entries.size());
        for (Map.Entry<Integer, Spell> entry : entries) {
            buf.writeInt(entry.getKey().intValue());
            Spell.STREAM.encode(buf, (Object)entry.getValue());
        }
    }, buf -> {
        int size = buf.readInt();
        Map slots = (Map)Util.make(new HashMap(), map -> {
            for (int i = 0; i < size; ++i) {
                int key = buf.readInt();
                Spell value = (Spell)Spell.STREAM.decode(buf);
                map.put(key, value);
            }
        });
        return new SpellSlotMap(slots);
    });

    public Spell getOrDefault(int slot, Spell spell) {
        return this.slots.getOrDefault(slot, spell);
    }

    public Spell get(int slot) {
        return this.slots.get(slot);
    }

    public SpellSlotMap put(int slot, Spell spell) {
        return new SpellSlotMap(Util.copyAndPut(this.slots, (Object)slot, (Object)spell));
    }
}

