/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.spell;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public interface IFilter {
    public boolean shouldResolveOnBlock(BlockHitResult var1, Level var2);

    default public boolean shouldResolveOnBlock(BlockPos pos, Direction direction, Level level) {
        return this.shouldResolveOnBlock(new BlockHitResult(new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()), direction, pos, false), level);
    }

    public boolean shouldResolveOnEntity(EntityHitResult var1, Level var2);

    default public boolean shouldResolveOnEntity(Entity entity, Level level) {
        return this.shouldResolveOnEntity(new EntityHitResult(entity), level);
    }

    default public boolean shouldAffect(HitResult rayTraceResult, Level level) {
        if (rayTraceResult instanceof BlockHitResult) {
            BlockHitResult block = (BlockHitResult)rayTraceResult;
            return this.shouldResolveOnBlock(block, level);
        }
        if (rayTraceResult instanceof EntityHitResult) {
            EntityHitResult entity = (EntityHitResult)rayTraceResult;
            return this.shouldResolveOnEntity(entity, level);
        }
        return false;
    }
}

