/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.spell;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.event.SpellDamageEvent;
import com.hollingsworth.arsnouveau.api.perk.PerkAttributes;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.util.DamageUtil;
import com.hollingsworth.arsnouveau.api.util.LootUtil;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentFortune;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentRandomize;
import com.hollingsworth.arsnouveau.setup.registry.DamageTypesRegistry;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.NotNull;

public interface IDamageEffect {
    default public boolean canDamage(LivingEntity shooter, SpellStats stats, SpellContext spellContext, SpellResolver resolver, @NotNull Entity entity) {
        LivingEntity living;
        return !(entity instanceof LivingEntity && (living = (LivingEntity)entity).getHealth() <= 0.0f || entity.isAlliedTo((Entity)shooter));
    }

    default public boolean attemptDamage(Level world, @NotNull LivingEntity shooter, SpellStats stats, SpellContext spellContext, SpellResolver resolver, Entity entity, DamageSource source, float baseDamage) {
        LivingEntity mob;
        if (!this.canDamage(shooter, stats, spellContext, resolver, entity)) {
            return false;
        }
        ServerLevel server = (ServerLevel)world;
        float totalDamage = (float)((double)baseDamage + stats.getDamageModifier() + (shooter.getAttributes().hasAttribute(PerkAttributes.SPELL_DAMAGE_BONUS) ? shooter.getAttributeValue(PerkAttributes.SPELL_DAMAGE_BONUS) : 0.0));
        if (stats.isRandomized()) {
            totalDamage += (float)this.randomRolls(stats, server);
        }
        SpellDamageEvent.Pre preDamage = new SpellDamageEvent.Pre(source, shooter, entity, totalDamage, spellContext);
        NeoForge.EVENT_BUS.post((Event)preDamage);
        source = preDamage.damageSource;
        totalDamage = preDamage.damage;
        if (totalDamage <= 0.0f || preDamage.isCanceled()) {
            return false;
        }
        if (!entity.hurt(source, totalDamage)) {
            return false;
        }
        shooter.setLastHurtMob(entity);
        SpellDamageEvent.Post postDamage = new SpellDamageEvent.Post(source, shooter, entity, totalDamage, spellContext);
        NeoForge.EVENT_BUS.post((Event)postDamage);
        if (entity instanceof LivingEntity && (mob = (LivingEntity)entity).getHealth() <= 0.0f && !mob.isRemoved() && stats.hasBuff(AugmentFortune.INSTANCE)) {
            ANFakePlayer aNFakePlayer;
            if (shooter instanceof Player) {
                Player player = (Player)shooter;
                aNFakePlayer = player;
            } else {
                aNFakePlayer = ANFakePlayer.getPlayer(server);
            }
            ANFakePlayer playerContext = aNFakePlayer;
            int looting = stats.getBuffCount(AugmentFortune.INSTANCE);
            LootParams lootContext = LootUtil.getLootingContext(server, shooter, mob, looting, world.damageSources().playerAttack((Player)playerContext)).create(LootContextParamSets.ENTITY);
            LootTable loottable = server.getServer().reloadableRegistries().getLootTable(mob.getLootTable());
            ObjectArrayList items = loottable.getRandomItems(lootContext);
            items.forEach(arg_0 -> ((LivingEntity)mob).spawnAtLocation(arg_0));
        }
        return true;
    }

    default public int randomRolls(SpellStats stats, ServerLevel server) {
        return stats.getBuffCount(AugmentRandomize.INSTANCE) * server.random.nextIntBetweenInclusive(-1, 1);
    }

    /*
     * WARNING - void declaration
     */
    default public DamageSource buildDamageSource(Level world, LivingEntity shooter) {
        ANFakePlayer aNFakePlayer;
        if (!(shooter instanceof Player)) {
            aNFakePlayer = ANFakePlayer.getPlayer((ServerLevel)world);
        } else {
            void var3_3;
            Player player = (Player)shooter;
            aNFakePlayer = var3_3;
        }
        return DamageUtil.source((LevelAccessor)world, DamageTypesRegistry.GENERIC_SPELL_DAMAGE, (Entity)aNFakePlayer);
    }
}

