/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.sound;

import com.hollingsworth.arsnouveau.api.registry.SpellSoundRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;

public class SpellSound {
    public static MapCodec<SpellSound> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SoundEvent.CODEC.fieldOf("soundEvent").forGetter(s -> s.soundEvent), (App)ComponentSerialization.CODEC.fieldOf("soundName").forGetter(s -> s.soundName)).apply((Applicative)instance, SpellSound::new));
    public static StreamCodec<RegistryFriendlyByteBuf, SpellSound> STREAM = StreamCodec.of((buf, val) -> buf.writeResourceLocation(val.getId()), buf -> SpellSoundRegistry.getSpellSoundsRegistry().get(buf.readResourceLocation()));
    private Holder<SoundEvent> soundEvent;
    private Component soundName;

    public SpellSound(Holder<SoundEvent> soundEvent, Component soundName) {
        this.soundEvent = soundEvent;
        this.soundName = soundName;
    }

    public ResourceLocation getId() {
        return ((ResourceKey)this.soundEvent.unwrapKey().get()).location();
    }

    public Holder<SoundEvent> getSoundEvent() {
        return this.soundEvent;
    }

    public Component getSoundName() {
        return this.soundName;
    }

    public ResourceLocation getTexturePath() {
        return ResourceLocation.fromNamespaceAndPath((String)this.getId().getNamespace(), (String)("textures/sounds/" + this.getId().getPath() + ".png"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpellSound that = (SpellSound)o;
        return Objects.equals(this.soundEvent, that.soundEvent) && Objects.equals(this.soundName, that.soundName);
    }

    public int hashCode() {
        return Objects.hash(this.soundEvent, this.soundName);
    }

    public String toString() {
        return "SpellSound{soundEvent=" + String.valueOf(this.soundEvent) + ", soundName=" + String.valueOf(this.soundName) + "}";
    }
}

