/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.perk;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.hollingsworth.arsnouveau.api.perk.PerkSlot;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public interface IPerk {
    default public Multimap<Attribute, AttributeModifier> getModifiers(EquipmentSlot pEquipmentSlot, ItemStack stack, int slotValue) {
        return new ImmutableMultimap.Builder().build();
    }

    default public ImmutableMultimap.Builder<Attribute, AttributeModifier> attributeBuilder() {
        return new ImmutableMultimap.Builder();
    }

    default public PerkSlot minimumSlot() {
        return PerkSlot.ONE;
    }

    default public boolean validForSlot(PerkSlot slot, ItemStack stack, Player player) {
        if (this.minimumSlot().value() > slot.value()) {
            PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_nouveau.perk.invalid_for_slot", (Object[])new Object[]{this.minimumSlot().value()}));
            return false;
        }
        return true;
    }

    public ResourceLocation getRegistryName();

    default public String getName() {
        return Component.translatable((String)(this.getRegistryName().getNamespace() + ".thread_of"), (Object[])new Object[]{Component.translatable((String)("item." + this.getRegistryName().getNamespace() + "." + this.getRegistryName().getPath())).getString()}).getString();
    }

    default public String getLangName() {
        return "";
    }

    default public String getLangDescription() {
        return "";
    }

    default public String getDescriptionKey() {
        return this.getRegistryName().getNamespace() + ".perk_desc." + this.getRegistryName().getPath();
    }
}

